/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;

public class AlternativeItemNames {
    private static final HashMap<String, Material> nameToItem = new HashMap();
    private static final HashMap<Material, String> itemToName = new HashMap();
    public static final Map<String, Material> NAME_TO_ITEM = Collections.unmodifiableMap(nameToItem);

    private static void addItem(Material material, String name) {
        itemToName.put(material, name);
        nameToItem.put(name.toUpperCase().replace(" ", ""), material);
    }

    public static String getName(Material material) {
        return itemToName.get(material);
    }

    public static Material getItem(String uppercaseName) {
        return nameToItem.get(uppercaseName);
    }

    static {
        AlternativeItemNames.addItem(Material.WITHER_SKELETON_SKULL, "WITHER_SKEL_HEAD");
        AlternativeItemNames.addItem(Material.STRIPPED_DARK_OAK_LOG, "STR_DARK_OAK_LOG");
        AlternativeItemNames.addItem(Material.STRIPPED_DARK_OAK_WOOD, "STR_DARK_OAK_WOOD");
        for (Material mat : Material.values()) {
            String name = mat.name();
            if (name.startsWith("LEGACY_")) continue;
            if (name.endsWith("_STAINED_GLASS") || name.endsWith("_STAINED_GLASS_PANE")) {
                AlternativeItemNames.addItem(mat, mat.name().replace("STAINED_", ""));
            }
            if (!name.startsWith("DEAD_") || !name.contains("_CORAL_")) continue;
            AlternativeItemNames.addItem(mat, mat.name().replace("DEAD_", "DE_"));
        }
    }
}

