/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Commands;

import com.Acrobot.Breeze.Utils.InventoryUtil;
import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.NumberUtil;
import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Permission;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Give
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!Permission.has(sender, Permission.ADMIN)) {
            sender.sendMessage(Messages.prefix(Messages.ACCESS_DENIED));
            return true;
        }
        if (args.length < 1) {
            return false;
        }
        Player receiver = sender instanceof Player ? (Player)sender : null;
        int quantity = 1;
        ArrayList<Integer> disregardedIndexes = new ArrayList<Integer>();
        if (args.length > 1) {
            int index;
            for (index = args.length - 1; index >= 0; --index) {
                Player target = Bukkit.getPlayer((String)args[index]);
                if (target == null) continue;
                receiver = target;
                disregardedIndexes.add(index);
                break;
            }
            for (index = args.length - 1; index >= 0; --index) {
                if (!NumberUtil.isInteger(args[index]) || Integer.parseInt(args[index]) < 0) continue;
                quantity = Integer.parseInt(args[index]);
                disregardedIndexes.add(index);
                break;
            }
        }
        if (receiver == null) {
            sender.sendMessage(Messages.prefix(Messages.PLAYER_NOT_FOUND));
            return true;
        }
        ItemStack item = Give.getItem(args, disregardedIndexes);
        if (MaterialUtil.isEmpty(item)) {
            sender.sendMessage(Messages.prefix(Messages.INCORRECT_ITEM_ID));
            return true;
        }
        item.setAmount(quantity);
        InventoryUtil.add(item, (Inventory)receiver.getInventory());
        sender.sendMessage(Messages.prefix(Messages.ITEM_GIVEN.replace("%item", MaterialUtil.getName(item.getType())).replace("%player", receiver.getName())));
        return true;
    }

    private static ItemStack getItem(String[] arguments, List<Integer> disregardedElements) {
        StringBuilder builder = new StringBuilder(arguments.length * 5);
        for (int index = 0; index < arguments.length; ++index) {
            if (disregardedElements.contains(index)) continue;
            builder.append(arguments[index]).append(' ');
        }
        return MaterialUtil.getItem(builder.toString().trim());
    }
}

