/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.nbt;

import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagType;

public final class DoubleTag
extends Tag {
    private final double value;

    public DoubleTag(double value) {
        this.value = value;
    }

    public Object getValue() {
        return this.getRawValue();
    }

    public double getRawValue() {
        return this.value;
    }

    @Override
    public TagType getType() {
        return TagType.DOUBLE;
    }

    @Override
    public String toString() {
        return "" + this.getRawValue() + 'd';
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.value) ^ Double.doubleToLongBits(this.value) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleTag other = (DoubleTag)obj;
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }
}

