/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.nbt;

import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagType;

public final class StringTag
extends Tag<String> {
    private final String value;

    public StringTag(String value) {
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public TagType getType() {
        return TagType.STRING;
    }

    @Override
    public String toString() {
        return StringTag.toString(this.getValue());
    }

    public static String toString(String s) {
        StringBuilder ret = new StringBuilder(s.length() + 4);
        ret.append('\"');
        block9: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\b': {
                    ret.append("\\b");
                    continue block9;
                }
                case '\f': {
                    ret.append("\\f");
                    continue block9;
                }
                case '\n': {
                    ret.append("\\n");
                    continue block9;
                }
                case '\r': {
                    ret.append("\\r");
                    continue block9;
                }
                case '\t': {
                    ret.append("\\t");
                    continue block9;
                }
                case '\\': {
                    ret.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    ret.append("\\\"");
                    continue block9;
                }
                default: {
                    ret.append(ch);
                }
            }
        }
        ret.append('\"');
        return ret.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + (this.value != null ? this.value.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringTag other = (StringTag)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

