/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.unsafe.v1_8_R2;

import java.io.File;
import net.minecraft.server.v1_8_R2.EntityTracker;
import net.minecraft.server.v1_8_R2.EnumDifficulty;
import net.minecraft.server.v1_8_R2.IDataManager;
import net.minecraft.server.v1_8_R2.IWorldAccess;
import net.minecraft.server.v1_8_R2.MethodProfiler;
import net.minecraft.server.v1_8_R2.MinecraftServer;
import net.minecraft.server.v1_8_R2.WorldData;
import net.minecraft.server.v1_8_R2.WorldManager;
import net.minecraft.server.v1_8_R2.WorldServer;
import org.bukkit.Difficulty;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_8_R2.CraftServer;
import org.bukkit.craftbukkit.v1_8_R2.scoreboard.CraftScoreboard;
import org.bukkit.event.Event;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.cyberiantiger.minecraft.Coord;
import org.cyberiantiger.minecraft.generator.VoidGenerator;
import org.cyberiantiger.minecraft.unsafe.AbstractInstanceTools;
import org.cyberiantiger.minecraft.unsafe.v1_8_R2.InstanceDataManager;

public final class InstanceTools
extends AbstractInstanceTools {
    public void unloadWorld(Plugin plugin, World world) {
        plugin.getServer().unloadWorld(world, false);
    }

    public World createInstance(Plugin plugin, String instanceName, World.Environment env, Difficulty difficulty, File source, File destination) {
        this.checkDirectories(source, destination);
        MinecraftServer console = ((CraftServer)plugin.getServer()).getServer();
        if (console == null) {
            throw new IllegalStateException("Minecraft console was null");
        }
        InstanceDataManager dataManager = new InstanceDataManager(plugin, instanceName, source, destination);
        int dimension = 10 + console.worlds.size();
        boolean used = false;
        block0: do {
            for (WorldServer server : console.worlds) {
                used = server.dimension == dimension;
                if (!used) continue;
                ++dimension;
                continue block0;
            }
        } while (used);
        MethodProfiler profiler = console.methodProfiler;
        WorldData wd = dataManager.getWorldData();
        VoidGenerator generator = new VoidGenerator(Biome.PLAINS, new Coord(wd.c(), wd.d(), wd.e()));
        WorldServer instanceWorld = (WorldServer)new WorldServer(console, (IDataManager)dataManager, wd, dimension, console.methodProfiler, env, (ChunkGenerator)generator).b();
        instanceWorld.scoreboard = ((CraftScoreboard)plugin.getServer().getScoreboardManager().getMainScoreboard()).getHandle();
        instanceWorld.tracker = new EntityTracker(instanceWorld);
        instanceWorld.addIWorldAccess((IWorldAccess)new WorldManager(console, instanceWorld));
        instanceWorld.getWorldData().setDifficulty(EnumDifficulty.values()[difficulty.ordinal()]);
        instanceWorld.setSpawnFlags(true, true);
        instanceWorld.keepSpawnInMemory = false;
        console.worlds.add(instanceWorld);
        instanceWorld.getWorld().getPopulators().addAll(generator.getDefaultPopulators((World)instanceWorld.getWorld()));
        plugin.getServer().getPluginManager().callEvent((Event)new WorldInitEvent((World)instanceWorld.getWorld()));
        plugin.getServer().getPluginManager().callEvent((Event)new WorldLoadEvent((World)instanceWorld.getWorld()));
        return instanceWorld.getWorld();
    }
}

