/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.unsafe.v1_18_R2;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.cyberiantiger.minecraft.nbt.ByteArrayTag;
import org.cyberiantiger.minecraft.nbt.ByteTag;
import org.cyberiantiger.minecraft.nbt.CompoundTag;
import org.cyberiantiger.minecraft.nbt.DoubleTag;
import org.cyberiantiger.minecraft.nbt.FloatTag;
import org.cyberiantiger.minecraft.nbt.IntArrayTag;
import org.cyberiantiger.minecraft.nbt.IntTag;
import org.cyberiantiger.minecraft.nbt.ListTag;
import org.cyberiantiger.minecraft.nbt.LongArrayTag;
import org.cyberiantiger.minecraft.nbt.LongTag;
import org.cyberiantiger.minecraft.nbt.ShortTag;
import org.cyberiantiger.minecraft.nbt.StringTag;
import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagType;

public final class NBTTools
implements org.cyberiantiger.minecraft.unsafe.NBTTools {
    public ok toNativeCompound(CompoundTag tag) {
        ok result = new ok();
        for (Map.Entry e : tag.getValue().entrySet()) {
            String name = (String)e.getKey();
            Tag t = (Tag)e.getValue();
            result.a(name, (pd)(switch (t.getType()) {
                case TagType.BYTE -> oi.a((byte)((ByteTag)t).getRawValue());
                case TagType.BYTE_ARRAY -> new oh(((ByteArrayTag)t).getValue());
                case TagType.COMPOUND -> this.toNativeCompound((CompoundTag)t);
                case TagType.DOUBLE -> ol.a((double)((DoubleTag)t).getRawValue());
                case TagType.FLOAT -> on.a((float)((FloatTag)t).getRawValue());
                case TagType.INT -> op.a((int)((IntTag)t).getRawValue());
                case TagType.INT_ARRAY -> new oo(((IntArrayTag)t).getValue());
                case TagType.LIST -> this.toNativeList((ListTag)t);
                case TagType.LONG -> os.a((long)((LongTag)t).getRawValue());
                case TagType.SHORT -> oy.a((short)((ShortTag)t).getRawValue());
                case TagType.STRING -> pb.a((String)((StringTag)t).getValue());
                case TagType.LONG_ARRAY -> new or(((LongArrayTag)t).getValue());
                default -> throw new IllegalArgumentException();
            }));
        }
        return result;
    }

    public oq toNativeList(ListTag tag) {
        oq result = new oq();
        switch (tag.getListType()) {
            case BYTE: {
                for (ByteTag byteTag : (ByteTag[])tag.getValue()) {
                    result.add((Object)oi.a((byte)byteTag.getRawValue()));
                }
                break;
            }
            case BYTE_ARRAY: {
                for (ByteArrayTag byteArrayTag : (ByteArrayTag[])tag.getValue()) {
                    result.add((Object)new oh(byteArrayTag.getValue()));
                }
                break;
            }
            case COMPOUND: {
                for (CompoundTag compoundTag : (CompoundTag[])tag.getValue()) {
                    result.add((Object)this.toNativeCompound(compoundTag));
                }
                break;
            }
            case DOUBLE: {
                for (DoubleTag doubleTag : (DoubleTag[])tag.getValue()) {
                    result.add((Object)ol.a((double)doubleTag.getRawValue()));
                }
                break;
            }
            case FLOAT: {
                for (FloatTag floatTag : (FloatTag[])tag.getValue()) {
                    result.add((Object)on.a((float)floatTag.getRawValue()));
                }
                break;
            }
            case INT: {
                for (IntTag intTag : (IntTag[])tag.getValue()) {
                    result.add((Object)op.a((int)intTag.getRawValue()));
                }
                break;
            }
            case INT_ARRAY: {
                for (IntArrayTag intArrayTag : (IntArrayTag[])tag.getValue()) {
                    result.add((Object)new oo(intArrayTag.getValue()));
                }
                break;
            }
            case LIST: {
                for (ListTag listTag : (ListTag[])tag.getValue()) {
                    result.add((Object)this.toNativeList(listTag));
                }
            }
            case LONG: {
                for (ListTag listTag : (LongTag[])tag.getValue()) {
                    result.add((Object)os.a((long)listTag.getRawValue()));
                }
                break;
            }
            case SHORT: {
                for (ShortTag shortTag : (ShortTag[])tag.getValue()) {
                    result.add((Object)oy.a((short)shortTag.getRawValue()));
                }
                break;
            }
            case STRING: {
                for (StringTag stringTag : (StringTag[])tag.getValue()) {
                    result.add((Object)pb.a((String)stringTag.getValue()));
                }
                break;
            }
            case LONG_ARRAY: {
                for (LongArrayTag longArrayTag : (LongArrayTag[])tag.getValue()) {
                    result.add((Object)new or(longArrayTag.getValue()));
                }
                break;
            }
        }
        return result;
    }

    public CompoundTag fromNativeCompound(ok tag) {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String name : tag.d()) {
                pd b = tag.c(name);
                switch (TagType.values()[b.a()]) {
                    case BYTE: {
                        result.put(name, new ByteTag(((oi)b).h()));
                        break;
                    }
                    case BYTE_ARRAY: {
                        result.put(name, new ByteArrayTag(((oh)b).d()));
                        break;
                    }
                    case COMPOUND: {
                        result.put(name, this.fromNativeCompound((ok)b));
                        break;
                    }
                    case DOUBLE: {
                        result.put(name, new DoubleTag(((ol)b).i()));
                        break;
                    }
                    case FLOAT: {
                        result.put(name, new FloatTag(((on)b).j()));
                        break;
                    }
                    case INT: {
                        result.put(name, new IntTag(((op)b).f()));
                        break;
                    }
                    case INT_ARRAY: {
                        result.put(name, new IntArrayTag(((oo)b).f()));
                        break;
                    }
                    case LIST: {
                        result.put(name, this.fromNativeList((oq)b));
                        break;
                    }
                    case LONG: {
                        result.put(name, new LongTag(((os)b).e()));
                        break;
                    }
                    case SHORT: {
                        result.put(name, new ShortTag(((oy)b).g()));
                        break;
                    }
                    case STRING: {
                        result.put(name, new StringTag(((pb)b).e_()));
                        break;
                    }
                    case LONG_ARRAY: {
                        result.put(name, new LongArrayTag(((or)b).f()));
                        break;
                    }
                }
            }
            return new CompoundTag(result);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public ListTag fromNativeList(oq tag) {
        try {
            TagType type = TagType.values()[tag.e()];
            if (type == TagType.END) {
                type = TagType.BYTE;
            }
            oq tagAsList = tag;
            Tag[] t = (Tag[])Array.newInstance(type.getTagClass(), tag.size());
            switch (type) {
                case BYTE: 
                case END: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ByteTag(((oi)tagAsList.get(i)).h());
                    }
                    break;
                }
                case BYTE_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ByteArrayTag(((oh)tagAsList.get(i)).d());
                    }
                    break;
                }
                case COMPOUND: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = tagAsList.get(i) == null ? new CompoundTag() : this.fromNativeCompound((ok)tagAsList.get(i));
                    }
                    break;
                }
                case DOUBLE: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new DoubleTag(((ol)tagAsList.get(i)).i());
                    }
                    break;
                }
                case FLOAT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new FloatTag(((on)tagAsList.get(i)).j());
                    }
                    break;
                }
                case INT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new IntTag(((op)tagAsList.get(i)).f());
                    }
                    break;
                }
                case INT_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new IntArrayTag(((oo)tagAsList.get(i)).f());
                    }
                    break;
                }
                case LIST: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = this.fromNativeList((oq)tagAsList.get(i));
                    }
                    break;
                }
                case LONG: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new LongTag(((os)tagAsList.get(i)).e());
                    }
                    break;
                }
                case SHORT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ShortTag(((oy)tagAsList.get(i)).g());
                    }
                    break;
                }
                case STRING: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new StringTag(((pb)tagAsList.get(i)).e_());
                    }
                    break;
                }
                case LONG_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new LongArrayTag(((or)tagAsList.get(i)).f());
                    }
                    break;
                }
            }
            return new ListTag(type, t);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void writeTileEntity(Block block, CompoundTag tag) {
        CraftWorld craftWorld = (CraftWorld)block.getWorld();
        gj pos = new gj(block.getX(), block.getY(), block.getZ());
        cmr tileEntity = craftWorld.getHandle().c_(pos);
        if (tileEntity == null) {
            return;
        }
        adw handle = craftWorld.getHandle();
        cov blockData = handle.a_(pos);
        tileEntity.a(this.toNativeCompound(tag));
        tileEntity.e();
        craftWorld.getHandle().a(pos, blockData, blockData, 3);
    }

    public CompoundTag readTileEntity(Block block) {
        CraftWorld craftWorld = (CraftWorld)block.getWorld();
        gj pos = new gj(block.getX(), block.getY(), block.getZ());
        cmr tileEntity = craftWorld.getHandle().c_(pos);
        if (tileEntity == null) {
            return null;
        }
        ok tag = new ok();
        tag = tileEntity.m();
        return this.fromNativeCompound(tag);
    }

    public CompoundTag readItemStack(ItemStack stack) {
        buw nativeStack = CraftItemStack.asNMSCopy((ItemStack)stack);
        if (nativeStack == null) {
            return null;
        }
        ok compound = new ok();
        nativeStack.b(compound);
        return this.fromNativeCompound(compound);
    }

    public ItemStack createItemStack(CompoundTag tag) {
        buw nativeStack = buw.a((ok)this.toNativeCompound(tag));
        return CraftItemStack.asCraftMirror((buw)nativeStack);
    }

    public CompoundTag readEntity(Entity e) {
        axk handle = ((CraftEntity)e).getHandle();
        ok compound = new ok();
        handle.e(compound);
        return this.fromNativeCompound(compound);
    }

    public void updateEntity(Entity entity, CompoundTag tag) {
        CraftEntity craftEntity = (CraftEntity)entity;
        craftEntity.getHandle().g(this.toNativeCompound(tag));
    }

    public Entity getEntityByUUID(World world, UUID id) {
        CraftWorld craftWorld = (CraftWorld)world;
        axk entity = craftWorld.getHandle().a(id);
        if (entity == null) {
            return null;
        }
        return entity.getBukkitEntity();
    }

    public boolean isEntityByIdSupported() {
        return false;
    }

    public boolean isEntityByUuidSupported() {
        return true;
    }

    public Entity getEntityById(World world, int id) {
        throw new UnsupportedOperationException("Not supported");
    }
}

