/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.nbt;

import java.util.Arrays;
import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagType;

public final class LongArrayTag
extends Tag<long[]> {
    private final long[] value;

    public LongArrayTag(long[] value) {
        this.value = value;
    }

    @Override
    public long[] getValue() {
        return this.value;
    }

    @Override
    public TagType getType() {
        return TagType.LONG_ARRAY;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append('\u00ab');
        long[] v = this.getValue();
        for (int i = 0; i < v.length; ++i) {
            if (i != 0) {
                ret.append(", ");
            }
            ret.append(v[i]);
        }
        ret.append('\u00bb');
        return ret.toString();
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + Arrays.hashCode(this.value);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LongArrayTag other = (LongArrayTag)obj;
        return Arrays.equals(this.value, other.value);
    }
}

