/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.unsafe.v1_19_R1;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R1.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.cyberiantiger.minecraft.nbt.ByteArrayTag;
import org.cyberiantiger.minecraft.nbt.ByteTag;
import org.cyberiantiger.minecraft.nbt.CompoundTag;
import org.cyberiantiger.minecraft.nbt.DoubleTag;
import org.cyberiantiger.minecraft.nbt.FloatTag;
import org.cyberiantiger.minecraft.nbt.IntArrayTag;
import org.cyberiantiger.minecraft.nbt.IntTag;
import org.cyberiantiger.minecraft.nbt.ListTag;
import org.cyberiantiger.minecraft.nbt.LongArrayTag;
import org.cyberiantiger.minecraft.nbt.LongTag;
import org.cyberiantiger.minecraft.nbt.ShortTag;
import org.cyberiantiger.minecraft.nbt.StringTag;
import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagType;

public final class NBTTools
implements org.cyberiantiger.minecraft.unsafe.NBTTools {
    public pj toNativeCompound(CompoundTag tag) {
        pj result = new pj();
        for (Map.Entry e : tag.getValue().entrySet()) {
            String name = (String)e.getKey();
            Tag t = (Tag)e.getValue();
            result.a(name, (qc)(switch (t.getType()) {
                case TagType.BYTE -> ph.a((byte)((ByteTag)t).getRawValue());
                case TagType.BYTE_ARRAY -> new pg(((ByteArrayTag)t).getValue());
                case TagType.COMPOUND -> this.toNativeCompound((CompoundTag)t);
                case TagType.DOUBLE -> pk.a((double)((DoubleTag)t).getRawValue());
                case TagType.FLOAT -> pm.a((float)((FloatTag)t).getRawValue());
                case TagType.INT -> po.a((int)((IntTag)t).getRawValue());
                case TagType.INT_ARRAY -> new pn(((IntArrayTag)t).getValue());
                case TagType.LIST -> this.toNativeList((ListTag)t);
                case TagType.LONG -> pr.a((long)((LongTag)t).getRawValue());
                case TagType.SHORT -> px.a((short)((ShortTag)t).getRawValue());
                case TagType.STRING -> qa.a((String)((StringTag)t).getValue());
                case TagType.LONG_ARRAY -> new pq(((LongArrayTag)t).getValue());
                default -> throw new IllegalArgumentException();
            }));
        }
        return result;
    }

    public pp toNativeList(ListTag tag) {
        pp result = new pp();
        switch (tag.getListType()) {
            case BYTE: {
                for (ByteTag byteTag : (ByteTag[])tag.getValue()) {
                    result.add((Object)ph.a((byte)byteTag.getRawValue()));
                }
                break;
            }
            case BYTE_ARRAY: {
                for (ByteArrayTag byteArrayTag : (ByteArrayTag[])tag.getValue()) {
                    result.add((Object)new pg(byteArrayTag.getValue()));
                }
                break;
            }
            case COMPOUND: {
                for (CompoundTag compoundTag : (CompoundTag[])tag.getValue()) {
                    result.add((Object)this.toNativeCompound(compoundTag));
                }
                break;
            }
            case DOUBLE: {
                for (DoubleTag doubleTag : (DoubleTag[])tag.getValue()) {
                    result.add((Object)pk.a((double)doubleTag.getRawValue()));
                }
                break;
            }
            case FLOAT: {
                for (FloatTag floatTag : (FloatTag[])tag.getValue()) {
                    result.add((Object)pm.a((float)floatTag.getRawValue()));
                }
                break;
            }
            case INT: {
                for (IntTag intTag : (IntTag[])tag.getValue()) {
                    result.add((Object)po.a((int)intTag.getRawValue()));
                }
                break;
            }
            case INT_ARRAY: {
                for (IntArrayTag intArrayTag : (IntArrayTag[])tag.getValue()) {
                    result.add((Object)new pn(intArrayTag.getValue()));
                }
                break;
            }
            case LIST: {
                for (ListTag listTag : (ListTag[])tag.getValue()) {
                    result.add((Object)this.toNativeList(listTag));
                }
            }
            case LONG: {
                for (ListTag listTag : (LongTag[])tag.getValue()) {
                    result.add((Object)pr.a((long)listTag.getRawValue()));
                }
                break;
            }
            case SHORT: {
                for (ShortTag shortTag : (ShortTag[])tag.getValue()) {
                    result.add((Object)px.a((short)shortTag.getRawValue()));
                }
                break;
            }
            case STRING: {
                for (StringTag stringTag : (StringTag[])tag.getValue()) {
                    result.add((Object)qa.a((String)stringTag.getValue()));
                }
                break;
            }
            case LONG_ARRAY: {
                for (LongArrayTag longArrayTag : (LongArrayTag[])tag.getValue()) {
                    result.add((Object)new pq(longArrayTag.getValue()));
                }
                break;
            }
        }
        return result;
    }

    public CompoundTag fromNativeCompound(pj tag) {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String name : tag.d()) {
                qc b = tag.c(name);
                switch (TagType.values()[b.a()]) {
                    case BYTE: {
                        result.put(name, new ByteTag(((ph)b).h()));
                        break;
                    }
                    case BYTE_ARRAY: {
                        result.put(name, new ByteArrayTag(((pg)b).d()));
                        break;
                    }
                    case COMPOUND: {
                        result.put(name, this.fromNativeCompound((pj)b));
                        break;
                    }
                    case DOUBLE: {
                        result.put(name, new DoubleTag(((pk)b).i()));
                        break;
                    }
                    case FLOAT: {
                        result.put(name, new FloatTag(((pm)b).j()));
                        break;
                    }
                    case INT: {
                        result.put(name, new IntTag(((po)b).f()));
                        break;
                    }
                    case INT_ARRAY: {
                        result.put(name, new IntArrayTag(((pn)b).f()));
                        break;
                    }
                    case LIST: {
                        result.put(name, this.fromNativeList((pp)b));
                        break;
                    }
                    case LONG: {
                        result.put(name, new LongTag(((pr)b).e()));
                        break;
                    }
                    case SHORT: {
                        result.put(name, new ShortTag(((px)b).g()));
                        break;
                    }
                    case STRING: {
                        result.put(name, new StringTag(((qa)b).e_()));
                        break;
                    }
                    case LONG_ARRAY: {
                        result.put(name, new LongArrayTag(((pq)b).f()));
                        break;
                    }
                }
            }
            return new CompoundTag(result);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public ListTag fromNativeList(pp tag) {
        try {
            TagType type = TagType.values()[tag.e()];
            if (type == TagType.END) {
                type = TagType.BYTE;
            }
            pp tagAsList = tag;
            Tag[] t = (Tag[])Array.newInstance(type.getTagClass(), tag.size());
            switch (type) {
                case BYTE: 
                case END: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ByteTag(((ph)tagAsList.get(i)).h());
                    }
                    break;
                }
                case BYTE_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ByteArrayTag(((pg)tagAsList.get(i)).d());
                    }
                    break;
                }
                case COMPOUND: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = tagAsList.get(i) == null ? new CompoundTag() : this.fromNativeCompound((pj)tagAsList.get(i));
                    }
                    break;
                }
                case DOUBLE: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new DoubleTag(((pk)tagAsList.get(i)).i());
                    }
                    break;
                }
                case FLOAT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new FloatTag(((pm)tagAsList.get(i)).j());
                    }
                    break;
                }
                case INT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new IntTag(((po)tagAsList.get(i)).f());
                    }
                    break;
                }
                case INT_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new IntArrayTag(((pn)tagAsList.get(i)).f());
                    }
                    break;
                }
                case LIST: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = this.fromNativeList((pp)tagAsList.get(i));
                    }
                    break;
                }
                case LONG: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new LongTag(((pr)tagAsList.get(i)).e());
                    }
                    break;
                }
                case SHORT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ShortTag(((px)tagAsList.get(i)).g());
                    }
                    break;
                }
                case STRING: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new StringTag(((qa)tagAsList.get(i)).e_());
                    }
                    break;
                }
                case LONG_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new LongArrayTag(((pq)tagAsList.get(i)).f());
                    }
                    break;
                }
            }
            return new ListTag(type, t);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void writeTileEntity(Block block, CompoundTag tag) {
        CraftWorld craftWorld = (CraftWorld)block.getWorld();
        gt pos = new gt(block.getX(), block.getY(), block.getZ());
        csl tileEntity = craftWorld.getHandle().c_(pos);
        if (tileEntity == null) {
            return;
        }
        afo handle = craftWorld.getHandle();
        cur blockData = handle.a_(pos);
        tileEntity.a(this.toNativeCompound(tag));
        tileEntity.e();
        craftWorld.getHandle().a(pos, blockData, blockData, 3);
    }

    public CompoundTag readTileEntity(Block block) {
        CraftWorld craftWorld = (CraftWorld)block.getWorld();
        gt pos = new gt(block.getX(), block.getY(), block.getZ());
        csl tileEntity = craftWorld.getHandle().c_(pos);
        if (tileEntity == null) {
            return null;
        }
        pj tag = new pj();
        tag = tileEntity.m();
        return this.fromNativeCompound(tag);
    }

    public CompoundTag readItemStack(ItemStack stack) {
        caa nativeStack = CraftItemStack.asNMSCopy((ItemStack)stack);
        if (nativeStack == null) {
            return null;
        }
        pj compound = new pj();
        nativeStack.b(compound);
        return this.fromNativeCompound(compound);
    }

    public ItemStack createItemStack(CompoundTag tag) {
        caa nativeStack = caa.a((pj)this.toNativeCompound(tag));
        return CraftItemStack.asCraftMirror((caa)nativeStack);
    }

    public CompoundTag readEntity(Entity e) {
        baq handle = ((CraftEntity)e).getHandle();
        pj compound = new pj();
        handle.e(compound);
        return this.fromNativeCompound(compound);
    }

    public void updateEntity(Entity entity, CompoundTag tag) {
        CraftEntity craftEntity = (CraftEntity)entity;
        craftEntity.getHandle().g(this.toNativeCompound(tag));
    }

    public Entity getEntityByUUID(World world, UUID id) {
        CraftWorld craftWorld = (CraftWorld)world;
        baq entity = craftWorld.getHandle().a(id);
        if (entity == null) {
            return null;
        }
        return entity.getBukkitEntity();
    }

    public boolean isEntityByIdSupported() {
        return false;
    }

    public boolean isEntityByUuidSupported() {
        return true;
    }

    public Entity getEntityById(World world, int id) {
        throw new UnsupportedOperationException("Not supported");
    }
}

