/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.unsafe.v1_16_R2;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.v1_16_R2.BlockPosition;
import net.minecraft.server.v1_16_R2.IBlockData;
import net.minecraft.server.v1_16_R2.ItemStack;
import net.minecraft.server.v1_16_R2.NBTBase;
import net.minecraft.server.v1_16_R2.NBTTagByte;
import net.minecraft.server.v1_16_R2.NBTTagByteArray;
import net.minecraft.server.v1_16_R2.NBTTagCompound;
import net.minecraft.server.v1_16_R2.NBTTagDouble;
import net.minecraft.server.v1_16_R2.NBTTagFloat;
import net.minecraft.server.v1_16_R2.NBTTagInt;
import net.minecraft.server.v1_16_R2.NBTTagIntArray;
import net.minecraft.server.v1_16_R2.NBTTagList;
import net.minecraft.server.v1_16_R2.NBTTagLong;
import net.minecraft.server.v1_16_R2.NBTTagLongArray;
import net.minecraft.server.v1_16_R2.NBTTagShort;
import net.minecraft.server.v1_16_R2.NBTTagString;
import net.minecraft.server.v1_16_R2.TileEntity;
import net.minecraft.server.v1_16_R2.WorldServer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_16_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R2.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.cyberiantiger.minecraft.nbt.ByteArrayTag;
import org.cyberiantiger.minecraft.nbt.ByteTag;
import org.cyberiantiger.minecraft.nbt.CompoundTag;
import org.cyberiantiger.minecraft.nbt.DoubleTag;
import org.cyberiantiger.minecraft.nbt.FloatTag;
import org.cyberiantiger.minecraft.nbt.IntArrayTag;
import org.cyberiantiger.minecraft.nbt.IntTag;
import org.cyberiantiger.minecraft.nbt.ListTag;
import org.cyberiantiger.minecraft.nbt.LongArrayTag;
import org.cyberiantiger.minecraft.nbt.LongTag;
import org.cyberiantiger.minecraft.nbt.ShortTag;
import org.cyberiantiger.minecraft.nbt.StringTag;
import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagType;

public final class NBTTools
implements org.cyberiantiger.minecraft.unsafe.NBTTools {
    public NBTTagCompound toNativeCompound(CompoundTag tag) {
        NBTTagCompound result = new NBTTagCompound();
        for (Map.Entry e : tag.getValue().entrySet()) {
            NBTTagByte base;
            String name = (String)e.getKey();
            Tag t = (Tag)e.getValue();
            switch (t.getType()) {
                case BYTE: {
                    base = NBTTagByte.a((byte)((ByteTag)t).getRawValue());
                    break;
                }
                case BYTE_ARRAY: {
                    base = new NBTTagByteArray(((ByteArrayTag)t).getValue());
                    break;
                }
                case COMPOUND: {
                    base = this.toNativeCompound((CompoundTag)t);
                    break;
                }
                case DOUBLE: {
                    base = NBTTagDouble.a((double)((DoubleTag)t).getRawValue());
                    break;
                }
                case FLOAT: {
                    base = NBTTagFloat.a((float)((FloatTag)t).getRawValue());
                    break;
                }
                case INT: {
                    base = NBTTagInt.a((int)((IntTag)t).getRawValue());
                    break;
                }
                case INT_ARRAY: {
                    base = new NBTTagIntArray(((IntArrayTag)t).getValue());
                    break;
                }
                case LIST: {
                    base = this.toNativeList((ListTag)t);
                    break;
                }
                case LONG: {
                    base = NBTTagLong.a((long)((LongTag)t).getRawValue());
                    break;
                }
                case SHORT: {
                    base = NBTTagShort.a((short)((ShortTag)t).getRawValue());
                    break;
                }
                case STRING: {
                    base = NBTTagString.a((String)((StringTag)t).getValue());
                    break;
                }
                case LONG_ARRAY: {
                    base = new NBTTagLongArray(((LongArrayTag)t).getValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            result.set(name, (NBTBase)base);
        }
        return result;
    }

    public NBTTagList toNativeList(ListTag tag) {
        NBTTagList result = new NBTTagList();
        switch (tag.getListType()) {
            case BYTE: {
                for (ByteTag byteTag : (ByteTag[])tag.getValue()) {
                    result.add((Object)NBTTagByte.a((byte)byteTag.getRawValue()));
                }
                break;
            }
            case BYTE_ARRAY: {
                for (ByteArrayTag byteArrayTag : (ByteArrayTag[])tag.getValue()) {
                    result.add((Object)new NBTTagByteArray(byteArrayTag.getValue()));
                }
                break;
            }
            case COMPOUND: {
                for (CompoundTag compoundTag : (CompoundTag[])tag.getValue()) {
                    result.add((Object)this.toNativeCompound(compoundTag));
                }
                break;
            }
            case DOUBLE: {
                for (DoubleTag doubleTag : (DoubleTag[])tag.getValue()) {
                    result.add((Object)NBTTagDouble.a((double)doubleTag.getRawValue()));
                }
                break;
            }
            case FLOAT: {
                for (FloatTag floatTag : (FloatTag[])tag.getValue()) {
                    result.add((Object)NBTTagFloat.a((float)floatTag.getRawValue()));
                }
                break;
            }
            case INT: {
                for (IntTag intTag : (IntTag[])tag.getValue()) {
                    result.add((Object)NBTTagInt.a((int)intTag.getRawValue()));
                }
                break;
            }
            case INT_ARRAY: {
                for (IntArrayTag intArrayTag : (IntArrayTag[])tag.getValue()) {
                    result.add((Object)new NBTTagIntArray(intArrayTag.getValue()));
                }
                break;
            }
            case LIST: {
                for (ListTag listTag : (ListTag[])tag.getValue()) {
                    result.add((Object)this.toNativeList(listTag));
                }
            }
            case LONG: {
                for (ListTag listTag : (LongTag[])tag.getValue()) {
                    result.add((Object)NBTTagLong.a((long)listTag.getRawValue()));
                }
                break;
            }
            case SHORT: {
                for (ShortTag shortTag : (ShortTag[])tag.getValue()) {
                    result.add((Object)NBTTagShort.a((short)shortTag.getRawValue()));
                }
                break;
            }
            case STRING: {
                for (StringTag stringTag : (StringTag[])tag.getValue()) {
                    result.add((Object)NBTTagString.a((String)stringTag.getValue()));
                }
                break;
            }
            case LONG_ARRAY: {
                for (LongArrayTag longArrayTag : (LongArrayTag[])tag.getValue()) {
                    result.add((Object)new NBTTagLongArray(longArrayTag.getValue()));
                }
                break;
            }
        }
        return result;
    }

    public CompoundTag fromNativeCompound(NBTTagCompound tag) {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String name : tag.getKeys()) {
                NBTBase b = tag.get(name);
                switch (TagType.values()[b.getTypeId()]) {
                    case BYTE: {
                        result.put(name, new ByteTag(((NBTTagByte)b).asByte()));
                        break;
                    }
                    case BYTE_ARRAY: {
                        result.put(name, new ByteArrayTag(((NBTTagByteArray)b).getBytes()));
                        break;
                    }
                    case COMPOUND: {
                        result.put(name, this.fromNativeCompound((NBTTagCompound)b));
                        break;
                    }
                    case DOUBLE: {
                        result.put(name, new DoubleTag(((NBTTagDouble)b).asDouble()));
                        break;
                    }
                    case FLOAT: {
                        result.put(name, new FloatTag(((NBTTagFloat)b).asFloat()));
                        break;
                    }
                    case INT: {
                        result.put(name, new IntTag(((NBTTagInt)b).asInt()));
                        break;
                    }
                    case INT_ARRAY: {
                        result.put(name, new IntArrayTag(((NBTTagIntArray)b).getInts()));
                        break;
                    }
                    case LIST: {
                        result.put(name, this.fromNativeList((NBTTagList)b));
                        break;
                    }
                    case LONG: {
                        result.put(name, new LongTag(((NBTTagLong)b).asLong()));
                        break;
                    }
                    case SHORT: {
                        result.put(name, new ShortTag(((NBTTagShort)b).asShort()));
                        break;
                    }
                    case STRING: {
                        result.put(name, new StringTag(((NBTTagString)b).asString()));
                        break;
                    }
                    case LONG_ARRAY: {
                        result.put(name, new LongArrayTag(((NBTTagLongArray)b).getLongs()));
                        break;
                    }
                }
            }
            return new CompoundTag(result);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public ListTag fromNativeList(NBTTagList tag) {
        try {
            TagType type = TagType.values()[tag.d_()];
            if (type == TagType.END) {
                type = TagType.BYTE;
            }
            Tag[] t = (Tag[])Array.newInstance(type.getTagClass(), tag.size());
            switch (type) {
                case BYTE: 
                case END: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ByteTag(((NBTTagByte)tag.get(i)).asByte());
                    }
                    break;
                }
                case BYTE_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ByteArrayTag(((NBTTagByteArray)tag.get(i)).getBytes());
                    }
                    break;
                }
                case COMPOUND: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = tag.get(i) == null ? new CompoundTag() : this.fromNativeCompound((NBTTagCompound)tag.get(i));
                    }
                    break;
                }
                case DOUBLE: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new DoubleTag(((NBTTagDouble)tag.get(i)).asDouble());
                    }
                    break;
                }
                case FLOAT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new FloatTag(((NBTTagFloat)tag.get(i)).asFloat());
                    }
                    break;
                }
                case INT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new IntTag(((NBTTagInt)tag.get(i)).asInt());
                    }
                    break;
                }
                case INT_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new IntArrayTag(((NBTTagIntArray)tag.get(i)).getInts());
                    }
                    break;
                }
                case LIST: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = this.fromNativeList((NBTTagList)tag.get(i));
                    }
                    break;
                }
                case LONG: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new LongTag(((NBTTagLong)tag.get(i)).asLong());
                    }
                    break;
                }
                case SHORT: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new ShortTag(((NBTTagShort)tag.get(i)).asShort());
                    }
                    break;
                }
                case STRING: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new StringTag(((NBTTagString)tag.get(i)).asString());
                    }
                    break;
                }
                case LONG_ARRAY: {
                    for (int i = 0; i < tag.size(); ++i) {
                        t[i] = new LongArrayTag(((NBTTagLongArray)tag.get(i)).getLongs());
                    }
                    break;
                }
            }
            return new ListTag(type, t);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(NBTTools.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void writeTileEntity(Block block, CompoundTag tag) {
        CraftWorld craftWorld = (CraftWorld)block.getWorld();
        TileEntity tileEntity = craftWorld.getHandle().getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        if (tileEntity == null) {
            return;
        }
        BlockPosition pos = new BlockPosition(block.getX(), block.getY(), block.getZ());
        WorldServer handle = craftWorld.getHandle();
        IBlockData blockData = handle.getType(pos);
        tileEntity.load(blockData, this.toNativeCompound(tag));
        tileEntity.update();
        craftWorld.getHandle().notify(new BlockPosition(block.getX(), block.getY(), block.getZ()), blockData, blockData, 3);
    }

    public CompoundTag readTileEntity(Block block) {
        CraftWorld craftWorld = (CraftWorld)block.getWorld();
        BlockPosition pos = new BlockPosition(block.getX(), block.getY(), block.getZ());
        TileEntity tileEntity = craftWorld.getHandle().getTileEntity(pos);
        if (tileEntity == null) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tileEntity.save(tag);
        return this.fromNativeCompound(tag);
    }

    public CompoundTag readItemStack(org.bukkit.inventory.ItemStack stack) {
        ItemStack nativeStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)stack);
        if (nativeStack == null) {
            return null;
        }
        NBTTagCompound compound = new NBTTagCompound();
        nativeStack.save(compound);
        return this.fromNativeCompound(compound);
    }

    public org.bukkit.inventory.ItemStack createItemStack(CompoundTag tag) {
        ItemStack nativeStack = ItemStack.a((NBTTagCompound)this.toNativeCompound(tag));
        return CraftItemStack.asCraftMirror((ItemStack)nativeStack);
    }

    public CompoundTag readEntity(Entity e) {
        net.minecraft.server.v1_16_R2.Entity handle = ((CraftEntity)e).getHandle();
        NBTTagCompound compound = new NBTTagCompound();
        handle.save(compound);
        return this.fromNativeCompound(compound);
    }

    public void updateEntity(Entity entity, CompoundTag tag) {
        CraftEntity craftEntity = (CraftEntity)entity;
        craftEntity.getHandle().load(this.toNativeCompound(tag));
    }

    public Entity getEntityByUUID(World world, UUID id) {
        CraftWorld craftWorld = (CraftWorld)world;
        net.minecraft.server.v1_16_R2.Entity entity = craftWorld.getHandle().getEntity(id);
        if (entity == null) {
            return null;
        }
        return entity.getBukkitEntity();
    }

    public boolean isEntityByIdSupported() {
        return false;
    }

    public boolean isEntityByUuidSupported() {
        return true;
    }

    public Entity getEntityById(World world, int id) {
        throw new UnsupportedOperationException("Not supported");
    }
}

