/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.unsafe;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.cyberiantiger.minecraft.unsafe.VersionedNMS;

public class CBShim {
    private static final String CRAFTBUKKIT_PACKAGE = "org.bukkit.craftbukkit";
    private static final Map<Class, Class> PRIMITIVE_TYPES = new HashMap<Class, Class>();

    public static <T> T createShim(Class<T> type, Plugin plugin, Object ... args) {
        String version = CBShim.getNmsVersion(plugin);
        try {
            version = Optional.ofNullable(CBShim.loadVersioning(type, version)).map(VersionedNMS::getTargetVersion).orElse(version);
            Class<T> resultType = CBShim.loadShim(type, version);
            T result = CBShim.newInstance(resultType, args);
            plugin.getLogger().info("Loaded " + type.getName() + " as " + resultType.getName());
            return result;
        }
        catch (IllegalArgumentException | ReflectiveOperationException ex) {
            CBShim.unsupportedVersion(plugin.getServer(), ex);
            return null;
        }
    }

    private static String getNmsVersion(Plugin plugin) {
        Class<?> serverClass = plugin.getServer().getClass();
        while (!serverClass.getPackage().getName().startsWith(CRAFTBUKKIT_PACKAGE)) {
            if ((serverClass = serverClass.getSuperclass()) != null) continue;
            CBShim.unsupportedVersion(plugin.getServer());
        }
        String pkg = serverClass.getPackage().getName();
        int i = pkg.lastIndexOf(".");
        if (i == -1) {
            CBShim.unsupportedVersion(plugin.getServer());
        }
        return pkg.substring(i + 1);
    }

    private static <T> T newInstance(Class<? extends T> type, Object[] args) throws ReflectiveOperationException {
        block0: for (Constructor<?> constructor : type.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (args.length != parameterTypes.length) continue;
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class parameterType = parameterTypes[i];
                if (PRIMITIVE_TYPES.containsKey(parameterType)) {
                    parameterType = PRIMITIVE_TYPES.get(parameterType);
                }
                if (!parameterType.isInstance(args[i])) continue block0;
            }
            return (T)constructor.newInstance(args);
        }
        throw new IllegalArgumentException("Constructor with arguments :" + Arrays.toString(args) + " not found");
    }

    private static <T> Class<? extends T> loadShim(Class<T> type, String version) throws ReflectiveOperationException {
        String className = type.getPackage().getName() + '.' + version + '.' + type.getSimpleName();
        return Class.forName(className);
    }

    private static VersionedNMS loadVersioning(Class<?> type, String version) {
        try {
            String className = type.getPackage().getName() + '.' + version + '.' + type.getSimpleName() + "VersionedNMS";
            Class<?> versioningType = Class.forName(className);
            if (VersionedNMS.class.isAssignableFrom(versioningType)) {
                return (VersionedNMS)versioningType.newInstance();
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private static void unsupportedVersion(Server server) {
        CBShim.unsupportedVersion(server, null);
    }

    private static void unsupportedVersion(Server server, Exception ex) {
        throw new UnsupportedOperationException("Unsupported CraftBukkit version: " + server.getBukkitVersion(), ex);
    }

    static {
        PRIMITIVE_TYPES.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TYPES.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TYPES.put(Short.TYPE, Short.class);
        PRIMITIVE_TYPES.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TYPES.put(Long.TYPE, Long.class);
        PRIMITIVE_TYPES.put(Float.TYPE, Float.class);
        PRIMITIVE_TYPES.put(Double.TYPE, Double.class);
        PRIMITIVE_TYPES.put(Character.TYPE, Character.class);
        PRIMITIVE_TYPES.put(Void.TYPE, Void.class);
    }
}

