/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.libs.nmsutils.v1_19_R2;

import com.mojang.serialization.Lifecycle;
import de.cubeside.itemcontrol.libs.nmsutils.BiomeUtils;
import de.cubeside.itemcontrol.libs.nmsutils.NMSUtils;
import de.cubeside.itemcontrol.libs.nmsutils.biome.CustomBiome;
import de.cubeside.itemcontrol.libs.nmsutils.biome.Precipitation;
import de.cubeside.itemcontrol.libs.nmsutils.util.ReobfHelper;
import de.cubeside.itemcontrol.libs.nmsutils.v1_19_R2.CustomBiomeImpl;
import de.cubeside.itemcontrol.libs.nmsutils.v1_19_R2.NMSUtilsImpl;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.CaveSoundSettings;
import net.minecraft.world.level.chunk.Chunk;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.craftbukkit.v1_19_R2.CraftServer;
import org.bukkit.craftbukkit.v1_19_R2.CraftWorld;

public class BiomeUtilsImpl
implements BiomeUtils {
    private final NMSUtilsImpl nmsUtils;
    private HashMap<NamespacedKey, CustomBiomeImpl> customBiomes;
    private HashMap<BiomeBase, CustomBiomeImpl> customBiomesByBiome;
    private Collection<? extends CustomBiome> unmodifiableCustomBiomes;
    private static final Field FIELD_MAPPED_REGISTRY_FROZEN = ReobfHelper.getFieldByMojangName(RegistryMaterials.class, "frozen");
    private static final Field FIELD_MAPPED_REGISTRY_UNREGISTERED_INTRUSIVE_HOLDERS = ReobfHelper.getFieldByMojangName(RegistryMaterials.class, "unregisteredIntrusiveHolders");

    public BiomeUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
        this.customBiomes = new HashMap();
        this.customBiomesByBiome = new HashMap();
        this.unmodifiableCustomBiomes = Collections.unmodifiableCollection(this.customBiomes.values());
    }

    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    @Override
    public CustomBiome registerCustomBiome(NamespacedKey id, float downfall, float temperature, Precipitation precipitation, Integer fogColor, Integer waterColor, Integer waterFogColor, Integer skyColor, Integer foliageColor, Integer grassColor, BiomeUtils.GrassColorModifier grassColorModifier) {
        Server server = this.nmsUtils.getPlugin().getServer();
        CraftServer craftserver = (CraftServer)server;
        DedicatedServer dedicatedserver = craftserver.getServer();
        ResourceKey newKey = ResourceKey.a((ResourceKey)Registries.al, (MinecraftKey)new MinecraftKey(id.getNamespace(), id.getKey()));
        ResourceKey oldKey = Biomes.i;
        IRegistryWritable registrywritable = (IRegistryWritable)dedicatedserver.aW().d(Registries.al);
        try {
            FIELD_MAPPED_REGISTRY_FROZEN.set(registrywritable, false);
            FIELD_MAPPED_REGISTRY_UNREGISTERED_INTRUSIVE_HOLDERS.set(registrywritable, new IdentityHashMap());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        BiomeBase forestbiome = (BiomeBase)registrywritable.a(oldKey);
        BiomeBase.a builder = new BiomeBase.a();
        builder.b(downfall);
        builder.a(temperature);
        BiomeBase.Precipitation mojangPrecipitation = BiomeBase.Precipitation.a;
        if (precipitation == Precipitation.RAIN) {
            mojangPrecipitation = BiomeBase.Precipitation.b;
        } else if (precipitation == Precipitation.SNOW) {
            mojangPrecipitation = BiomeBase.Precipitation.c;
        }
        builder.a(mojangPrecipitation);
        builder.a(forestbiome.b());
        builder.a(forestbiome.e());
        builder.a(BiomeBase.TemperatureModifier.a);
        BiomeFog.a effects = new BiomeFog.a();
        effects.b(waterColor == null ? forestbiome.k() : waterColor.intValue());
        effects.c(waterFogColor == null ? forestbiome.l() : waterFogColor.intValue());
        effects.a(fogColor == null ? forestbiome.f() : fogColor.intValue());
        effects.d(skyColor == null ? forestbiome.a() : skyColor.intValue());
        if (foliageColor != null) {
            effects.e(foliageColor.intValue());
        }
        if (grassColor != null) {
            effects.f(grassColor.intValue());
        }
        effects.a(CaveSoundSettings.b);
        BiomeFog.GrassColor nativeGrassColorModifier = switch (grassColorModifier) {
            case BiomeUtils.GrassColorModifier.DARK_FOREST -> BiomeFog.GrassColor.b;
            case BiomeUtils.GrassColorModifier.SWAMP -> BiomeFog.GrassColor.c;
            default -> BiomeFog.GrassColor.a;
        };
        effects.a(nativeGrassColorModifier);
        builder.a(effects.a());
        BiomeBase newbiome = builder.a();
        registrywritable.f((Object)newbiome);
        Holder.c biomeHolder = registrywritable.a(newKey, (Object)newbiome, Lifecycle.stable());
        try {
            FIELD_MAPPED_REGISTRY_UNREGISTERED_INTRUSIVE_HOLDERS.set(registrywritable, null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        CustomBiomeImpl impl = new CustomBiomeImpl(id, (ResourceKey<BiomeBase>)newKey, newbiome, (Holder.c<BiomeBase>)biomeHolder);
        this.customBiomes.put(id, impl);
        this.customBiomesByBiome.put(newbiome, impl);
        return new CustomBiomeImpl(id, (ResourceKey<BiomeBase>)newKey, newbiome, (Holder.c<BiomeBase>)biomeHolder);
    }

    @Override
    public Collection<? extends CustomBiome> getAllCustomBiomes() {
        return this.unmodifiableCustomBiomes;
    }

    @Override
    public CustomBiome getCustomBiome(NamespacedKey id) {
        return this.customBiomes.get(id);
    }

    @Override
    public CustomBiome getCustomBiomeAt(Location location) {
        Holder biomeHolder;
        Chunk chunk;
        location.getWorld().getChunkAt(location);
        WorldServer level = ((CraftWorld)location.getWorld()).getHandle();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        BlockPosition pos = new BlockPosition(x, 0, z);
        if (level.o(pos) && (chunk = level.l(pos)) != null && (biomeHolder = chunk.getNoiseBiome(x >> 2, y >> 2, z >> 2)).b()) {
            BiomeBase biome = (BiomeBase)biomeHolder.a();
            return this.customBiomesByBiome.get(biome);
        }
        return null;
    }
}

