/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.checks;

import de.cubeside.itemcontrol.Main;
import de.cubeside.itemcontrol.checks.ComponentCheck;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.CompoundTag;
import de.cubeside.itemcontrol.util.ConfigUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.configuration.ConfigurationSection;

public abstract class BaseCheckEnchantments
implements ComponentCheck {
    protected HashMap<NamespacedKey, Integer> maxLevels = new HashMap();
    protected boolean allowHidden;
    protected boolean allowOnAllItems;

    @Override
    public void loadConfig(ConfigurationSection section) {
        ConfigurationSection data = ConfigUtil.getOrCreateSection(section, this.getComponentKey().asMinimalString());
        this.allowOnAllItems = ConfigUtil.getOrCreate(data, "allow_on_all_items", false);
        this.allowHidden = ConfigUtil.getOrCreate(data, "allow_hidden", false);
        this.maxLevels.clear();
        Registry.ENCHANTMENT.forEach(e -> this.maxLevels.put(e.getKey(), e.getMaxLevel()));
        ConfigurationSection overrideMapLevelSection = ConfigUtil.getOrCreateSection(data, "override_max_level");
        for (String s : overrideMapLevelSection.getKeys(false)) {
            NamespacedKey key = NamespacedKey.fromString((String)s);
            if (key == null || Registry.ENCHANTMENT.get(key) == null) {
                Main.getInstance().getLogger().warning("Invalid enchantment: " + s);
                continue;
            }
            int level = ConfigUtil.getOrCreate(overrideMapLevelSection, s, 0);
            this.maxLevels.put(key, level);
        }
    }

    @Override
    public boolean enforce(Material material, CompoundTag itemComponentsTag, String key) {
        return this.enforceEnchantmentLevels(material, itemComponentsTag, key, false);
    }

    private boolean enforceEnchantmentLevels(Material material, CompoundTag itemComponentsTag, String key, boolean inLevelsTag) {
        boolean changed = false;
        CompoundTag compound = itemComponentsTag.getCompound(key);
        if (compound != null) {
            int minSize = 0;
            for (String e : new ArrayList<String>(compound.getAllKeys())) {
                Integer maxLevel;
                if (!inLevelsTag && e.equals("levels")) {
                    changed |= this.enforceEnchantmentLevels(material, compound, e, true);
                    continue;
                }
                if (!inLevelsTag && e.equals("show_in_tooltip")) {
                    if (!this.allowHidden) {
                        compound.remove(e);
                        changed = true;
                        continue;
                    }
                    ++minSize;
                    continue;
                }
                NamespacedKey enchantmentKey = NamespacedKey.fromString((String)e);
                Integer n = maxLevel = enchantmentKey == null ? null : this.maxLevels.get(enchantmentKey);
                if (enchantmentKey == null || maxLevel == null) {
                    compound.remove(e);
                    changed = true;
                    continue;
                }
                int level = compound.getInt(e);
                if (level <= maxLevel && level >= 1 && !this.isInvalidOnItem(enchantmentKey, material)) continue;
                compound.remove(e);
                changed = true;
            }
            if (compound.size() <= minSize) {
                itemComponentsTag.remove(key);
                changed = true;
            }
        }
        return changed;
    }

    protected boolean isInvalidOnItem(NamespacedKey enchantmentKey, Material material) {
        return false;
    }
}

