/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.checks;

import de.cubeside.itemcontrol.checks.ComponentCheck;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.CompoundTag;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.ListTag;
import de.cubeside.itemcontrol.util.ConfigUtil;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;

public class CheckSuspiciousStewEffects
implements ComponentCheck {
    private static final NamespacedKey KEY = NamespacedKey.fromString((String)"minecraft:suspicious_stew_effects");
    private boolean allow;
    private int maxDuration;

    @Override
    public NamespacedKey getComponentKey() {
        return KEY;
    }

    @Override
    public void loadConfig(ConfigurationSection section) {
        ConfigurationSection data = ConfigUtil.getOrCreateSection(section, KEY.asMinimalString());
        this.allow = ConfigUtil.getOrCreate(data, "allow", true);
        this.maxDuration = ConfigUtil.getOrCreate(data, "max_duration", 160);
    }

    @Override
    public boolean enforce(Material material, CompoundTag itemComponentsTag, String key) {
        boolean changed = false;
        ListTag list = itemComponentsTag.getList(key);
        if (!this.allow || list == null) {
            itemComponentsTag.remove(key);
            changed = true;
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                CompoundTag compound = list.getCompound(i);
                if (compound == null) {
                    list.remove(i);
                    continue;
                }
                int duration = compound.getInt("duration", 0);
                if (this.maxDuration <= 0 || duration <= this.maxDuration) continue;
                compound.remove("duration");
                changed = true;
            }
        }
        return changed;
    }
}

