/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.checks;

import de.cubeside.itemcontrol.checks.ComponentCheck;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.CompoundTag;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.ListTag;
import de.cubeside.itemcontrol.util.ConfigUtil;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;

public class CheckBees
implements ComponentCheck {
    private static final NamespacedKey KEY = NamespacedKey.fromString((String)"minecraft:bees");
    private int maxBees;
    private boolean allowEntityData;
    private boolean allowAllEntities;

    @Override
    public NamespacedKey getComponentKey() {
        return KEY;
    }

    @Override
    public void loadConfig(ConfigurationSection section) {
        ConfigurationSection data = ConfigUtil.getOrCreateSection(section, KEY.asMinimalString());
        this.maxBees = ConfigUtil.getOrCreate(data, "max_bees", 0);
        this.allowEntityData = ConfigUtil.getOrCreate(data, "allow_entity_data", false);
        this.allowAllEntities = ConfigUtil.getOrCreate(data, "allow_all_entities", false);
    }

    @Override
    public boolean enforce(Material material, CompoundTag itemComponentsTag, String key) {
        boolean changed = false;
        ListTag beesList = itemComponentsTag.getList(key);
        if (beesList != null) {
            changed |= this.filterBees(beesList);
            if (beesList.isEmpty()) {
                itemComponentsTag.remove(key);
                changed = true;
            }
        } else {
            itemComponentsTag.remove(key);
            changed = true;
        }
        return changed;
    }

    private boolean filterBees(ListTag beesList) {
        int i;
        boolean changed = false;
        for (i = beesList.size() - 1; i >= this.maxBees; --i) {
            beesList.remove(i);
            changed = true;
        }
        for (i = beesList.size() - 1; i >= 0; --i) {
            CompoundTag beeCompound = beesList.getCompound(i);
            if (beeCompound != null) {
                CompoundTag entityData = beeCompound.getCompound("entity_data");
                if (entityData != null) {
                    String id;
                    if (!this.allowEntityData) {
                        for (String key : new ArrayList<String>(entityData.getAllKeys())) {
                            if (key.equals("id")) continue;
                            entityData.remove(key);
                            changed = true;
                        }
                    }
                    if (this.allowAllEntities || "bee".equals(id = entityData.getString("id")) || "minecraft:bee".equals(id)) continue;
                    beesList.remove(i);
                    changed = true;
                    continue;
                }
                beesList.remove(i);
                changed = true;
                continue;
            }
            beesList.remove(i);
            changed = true;
        }
        return changed;
    }
}

