/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.libs.nmsutils.paper1_21_11;

import com.destroystokyo.paper.entity.ai.VanillaGoal;
import de.cubeside.itemcontrol.libs.nmsutils.EntityUtils;
import de.cubeside.itemcontrol.libs.nmsutils.NMSUtils;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.CompoundTag;
import de.cubeside.itemcontrol.libs.nmsutils.paper1_21_11.CompoundTagImpl;
import de.cubeside.itemcontrol.libs.nmsutils.paper1_21_11.NMSUtilsImpl;
import de.cubeside.itemcontrol.libs.nmsutils.paper1_21_11.PathfinderGoalLimitedRandomStrollLand;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Level;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftBat;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftCamel;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftCreeper;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftMob;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPiglin;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftRaider;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftShulker;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftVex;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftWolf;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Camel;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Wolf;
import org.bukkit.util.Vector;

public class EntityUtilsImpl
implements EntityUtils {
    private final NMSUtilsImpl nmsUtils;

    public EntityUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    @Override
    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    @Override
    public void clearAI(Entity entity) {
        if (entity instanceof Mob) {
            this.nmsUtils.getPlugin().getServer().getMobGoals().removeAllGoals((Mob)entity);
        }
    }

    @Override
    public void addGoalFloat(Mob mob) {
        if (!Bukkit.getMobGoals().hasGoal(mob, VanillaGoal.FLOAT)) {
            EntityInsentient h = ((CraftMob)mob).getHandle();
            h.cs.a(1, (PathfinderGoal)new PathfinderGoalFloat(h));
        }
    }

    @Override
    public void addGoalLimitedStrollLand(Creature mob, double velocity, Function<Vector, Boolean> checkTargetFunction) {
        EntityCreature h = ((CraftCreature)mob).getHandle();
        h.cs.a(7, (PathfinderGoal)new PathfinderGoalLimitedRandomStrollLand(h, velocity, checkTargetFunction));
    }

    @Override
    public void removeGoalLimitedStrollLand(Creature mob) {
        EntityCreature h = ((CraftCreature)mob).getHandle();
        for (PathfinderGoalWrapped wrappedGoal : h.cs.b()) {
            PathfinderGoal pathfinderGoal = wrappedGoal.k();
            if (!(pathfinderGoal instanceof PathfinderGoalLimitedRandomStrollLand)) continue;
            PathfinderGoalLimitedRandomStrollLand goal = (PathfinderGoalLimitedRandomStrollLand)pathfinderGoal;
            wrappedGoal.e();
            h.cs.a((PathfinderGoal)goal);
            break;
        }
    }

    @Override
    public int getShulkerOpenState(Entity shulker) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return 0;
            }
            CraftShulker cs = (CraftShulker)shulker;
            return cs.getHandle().gX();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get shulker open state", e);
            return 0;
        }
    }

    @Override
    public void setShulkerOpenState(Entity shulker, int state) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return;
            }
            state = Math.max(0, Math.min(127, state));
            CraftShulker cs = (CraftShulker)shulker;
            cs.getHandle().a(state);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set shulker open state", e);
        }
    }

    @Override
    public boolean isPiglinDancing(Entity piglin) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return false;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            return cs.getHandle().gY();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get piglin dancing state", e);
            return false;
        }
    }

    @Override
    public void setPiglinDancing(Entity piglin, boolean dancing) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            cs.getHandle().y(dancing);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set piglin dancing state", e);
        }
    }

    @Override
    public void sendEntityPositionUpdate(Entity entity) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
        PlayerChunkMap.EntityTracker ete = handle.moonrise$getTrackedEntity();
        if (ete != null) {
            PacketPlayOutEntityTeleport positionPacket = new PacketPlayOutEntityTeleport(handle.aA(), PositionMoveRotation.a((net.minecraft.world.entity.Entity)handle), Set.of(), handle.bc);
            ete.f.stream().forEach(viewer -> viewer.b((Packet)positionPacket));
        }
    }

    @Override
    public void moveEntity(Entity e, double x, double y, double z) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        handle.a(EnumMoveType.a, new Vec3D(x, y, z));
    }

    @Override
    public void moveEntity(Entity e, Vector v) {
        this.moveEntity(e, v.getX(), v.getY(), v.getZ());
    }

    @Override
    public void setEntityHeadRotation(Entity e, float headRotation) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        if (handle instanceof EntityLiving) {
            ((EntityLiving)handle).bE = headRotation;
        } else {
            handle.r(headRotation);
        }
    }

    @Override
    public float getEntityHeadRotation(Entity e) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        return handle.cS();
    }

    @Override
    public void setEntityYaw(Entity e, float yaw) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        handle.v(yaw);
    }

    @Override
    public float getEntityYaw(Entity e) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        return handle.ec();
    }

    @Override
    public void setEntityPitch(Entity e, float pitch) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        handle.w(pitch);
    }

    @Override
    public float getEntityPitch(Entity e) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        return handle.ee();
    }

    @Override
    public void setEntityNavigationTarget(Entity entity, Location target, double speed) {
        if (entity instanceof Bat) {
            ((CraftBat)entity).getHandle().cw = new BlockPosition(target.getBlockX(), target.getBlockY(), target.getBlockZ());
        } else if (entity instanceof Vex) {
            EntityVex entityVex = ((CraftVex)entity).getHandle();
            entityVex.K().a(target.getX(), target.getY(), target.getZ(), speed);
            if (entityVex.ag_() == null) {
                entityVex.J().a(target.getX(), target.getY(), target.getZ(), 180.0f, 20.0f);
            }
        } else if (entity instanceof CraftMob) {
            ((CraftMob)entity).getHandle().N().a(target.getX(), target.getY(), target.getZ(), speed);
        } else {
            throw new IllegalArgumentException("Cannot set the navigation target for this mob: " + String.valueOf(entity == null ? "null" : entity.getType()));
        }
    }

    @Override
    public void setEntityLeftHanded(Entity ent, boolean left) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)nmsEntity;
            mob.v(left);
        }
    }

    @Override
    public boolean isEntityLeftHanded(Entity ent) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)nmsEntity;
            return mob.gH();
        }
        return false;
    }

    @Override
    public boolean isEntityInvisible(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.cG();
    }

    @Override
    public void setEntityInvisible(Entity entity, boolean invisible) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.l(invisible);
    }

    @Override
    public boolean hasEntityNoClip(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.ar;
    }

    @Override
    public void setEntityNoClip(Entity entity, boolean noClip) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.ar = noClip;
    }

    @Override
    public boolean areChunkEntitiesLoaded(Chunk c2) {
        return ((CraftWorld)c2.getWorld()).getHandle().c(ChunkCoordIntPair.d((int)c2.getX(), (int)c2.getZ()));
    }

    @Override
    public void loadChunkEntities(Chunk c2) {
        this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Call to unimplemented method", new RuntimeException());
    }

    @Override
    public void setOnGround(Entity entity, boolean onGround) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.e(onGround);
    }

    @Override
    public Entity getEntityById(World world, int id) {
        net.minecraft.world.entity.Entity entity = ((CraftWorld)world).getHandle().a(id);
        return entity == null ? null : entity.getBukkitEntity();
    }

    @Override
    public void setPose(Entity entity, Pose pose) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.c(EntityPose.values()[pose.ordinal()]);
    }

    @Override
    public void setWolfAngerTime(Wolf entity, int timeInTicks) {
        EntityWolf nmsEntity = ((CraftWolf)entity).getHandle();
        nmsEntity.a((long)timeInTicks);
    }

    @Override
    public void setAggressive(Mob entity, boolean aggressive) {
        EntityInsentient nmsEntity = ((CraftMob)entity).getHandle();
        nmsEntity.w(aggressive);
    }

    @Override
    public boolean isAggressive(Mob entity) {
        EntityInsentient nmsEntity = ((CraftMob)entity).getHandle();
        return nmsEntity.gI();
    }

    @Override
    public boolean isCelebrating(Raider entity) {
        EntityRaider nmsEntity = ((CraftRaider)entity).getHandle();
        return nmsEntity.hj();
    }

    @Override
    public void setCelebrating(Raider entity, boolean celebrating) {
        EntityRaider nmsEntity = ((CraftRaider)entity).getHandle();
        nmsEntity.B(celebrating);
    }

    @Override
    public void setCamelLastPoseChange(Camel entity, long tick) {
        net.minecraft.world.entity.animal.camel.Camel nmsEntity = ((CraftCamel)entity).getHandle();
        nmsEntity.a(nmsEntity.ao().au() - tick);
    }

    @Override
    public long getCamelLastPoseChange(Camel entity) {
        net.minecraft.world.entity.animal.camel.Camel nmsEntity = ((CraftCamel)entity).getHandle();
        return nmsEntity.hl();
    }

    @Override
    public boolean isCamelSitting(Camel entity) {
        net.minecraft.world.entity.animal.camel.Camel nmsEntity = ((CraftCamel)entity).getHandle();
        return nmsEntity.hd();
    }

    @Override
    public CompoundTag getNbt(Entity entity) {
        TagValueOutput tagValueOutput;
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(nmsEntity.es(), this.nmsUtils.getPlugin().getSLF4JLogger());){
            tagValueOutput = TagValueOutput.a((ProblemReporter)scopedCollector, (HolderLookup.a)nmsEntity.eo());
            nmsEntity.d((ValueOutput)tagValueOutput);
        }
        return new CompoundTagImpl(tagValueOutput.b());
    }

    @Override
    public void setNbt(Entity entity, CompoundTag nbt) {
        NBTTagCompound nativeNbt = ((CompoundTagImpl)nbt).handle;
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        UUID uuid = nmsEntity.cY();
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(nmsEntity.es(), this.nmsUtils.getPlugin().getSLF4JLogger());){
            ValueInput valueInput = TagValueInput.a((ProblemReporter)scopedCollector, (HolderLookup.a)nmsEntity.eo(), (NBTTagCompound)nativeNbt);
            nmsEntity.d(valueInput);
            nmsEntity.a(uuid);
        }
    }

    @Override
    public void mergeNbt(Entity entity, CompoundTag nbt) {
        NBTTagCompound nativeNbt = ((CompoundTagImpl)nbt).handle;
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(nmsEntity.es(), this.nmsUtils.getPlugin().getSLF4JLogger());){
            TagValueOutput tagValueOutput = TagValueOutput.a((ProblemReporter)scopedCollector, (HolderLookup.a)nmsEntity.eo());
            nmsEntity.d((ValueOutput)tagValueOutput);
            NBTTagCompound oldNbt = tagValueOutput.b();
            NBTTagCompound newNbt = oldNbt.l().a(nativeNbt);
            if (!oldNbt.equals((Object)newNbt)) {
                UUID uuid = nmsEntity.cY();
                ValueInput valueInput = TagValueInput.a((ProblemReporter)scopedCollector, (HolderLookup.a)nmsEntity.eo(), (NBTTagCompound)newNbt);
                nmsEntity.d(valueInput);
                nmsEntity.a(uuid);
            }
        }
    }

    @Override
    public void setSwellDir(Creeper creeper, int swellDir) {
        EntityCreeper mcCreeper = ((CraftCreeper)creeper).getHandle();
        mcCreeper.a(swellDir);
    }

    @Override
    public void resyncEntityPosition(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.moonrise$getTrackedEntity().b.onPlayerAdd();
        nmsEntity.aF = true;
    }

    @Override
    public void setCanInstaBuild(Player player, boolean instabuild) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        if (serverPlayer.gL().d != instabuild) {
            serverPlayer.gL().d = instabuild;
            serverPlayer.z();
        }
    }

    @Override
    public boolean canInstaBuild(Player player) {
        return ((CraftPlayer)player).getHandle().gL().d;
    }

    @Override
    public void setOriginWorld(Entity entity, World world) {
        ((CraftEntity)entity).getHandle().originWorld = world == null ? null : world.getUID();
    }
}

