/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.checks;

import de.cubeside.itemcontrol.checks.ComponentCheck;
import de.cubeside.itemcontrol.config.GroupConfig;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.CompoundTag;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.ListTag;
import de.cubeside.itemcontrol.util.ConfigUtil;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;

public class CheckConsumable
implements ComponentCheck {
    private static final NamespacedKey KEY = NamespacedKey.fromString((String)"minecraft:consumable");
    private boolean allow;
    private boolean allowSounds;
    private boolean allowEffects;
    private boolean allowTeleport;

    @Override
    public NamespacedKey getComponentKey() {
        return KEY;
    }

    @Override
    public void loadConfig(ConfigurationSection section) {
        ConfigurationSection data = ConfigUtil.getOrCreateSection(section, KEY.asMinimalString());
        this.allow = ConfigUtil.getOrCreate(data, "allow", false);
        this.allowSounds = ConfigUtil.getOrCreate(data, "allow_sounds", false);
        this.allowEffects = ConfigUtil.getOrCreate(data, "allow_effects", false);
        this.allowTeleport = ConfigUtil.getOrCreate(data, "allow_teleport", false);
    }

    @Override
    public boolean enforce(GroupConfig group, Material material, CompoundTag itemComponentsTag, String key) {
        boolean changed = false;
        CompoundTag compound = itemComponentsTag.getCompound(key);
        if (this.allow && compound != null) {
            ListTag consumeEffects;
            if (!this.allowSounds && compound.containsKey("sound")) {
                compound.remove("sound");
                changed = true;
            }
            if ((consumeEffects = compound.getList("on_consume_effects")) != null) {
                int count = consumeEffects.size();
                for (int i = count - 1; i >= 0; --i) {
                    CompoundTag consumeEffect = consumeEffects.getCompound(i);
                    String type = consumeEffect.getString("type");
                    if ("apply_effects".equals(type) || "remove_effects".equals(type) || "clear_all_effects".equals(type)) {
                        if (this.allowEffects) continue;
                        consumeEffects.remove(i);
                        changed = true;
                        continue;
                    }
                    if ("teleport_randomly".equals(type)) {
                        if (this.allowTeleport) continue;
                        consumeEffects.remove(i);
                        changed = true;
                        continue;
                    }
                    if ("play_sound".equals(type)) {
                        if (this.allowSounds) continue;
                        consumeEffects.remove(i);
                        changed = true;
                        continue;
                    }
                    consumeEffects.remove(i);
                    changed = true;
                }
                if (changed && consumeEffects.isEmpty()) {
                    compound.remove("on_consume_effects");
                }
            }
        } else {
            itemComponentsTag.remove(key);
            changed = true;
        }
        return changed;
    }
}

