/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.checks;

import de.cubeside.itemcontrol.checks.ComponentCheck;
import de.cubeside.itemcontrol.config.GroupConfig;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.CompoundTag;
import de.cubeside.itemcontrol.util.ConfigUtil;
import java.util.function.Supplier;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;

public class GenericSimpleCheck
implements ComponentCheck {
    private final NamespacedKey key;
    protected final boolean defaultValue;
    protected boolean allow;

    protected GenericSimpleCheck(NamespacedKey key, boolean defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public static Supplier<? extends GenericSimpleCheck> createFor(String key) {
        return GenericSimpleCheck.createFor(key, false);
    }

    public static Supplier<? extends GenericSimpleCheck> createFor(String key, boolean defaultValue) {
        return () -> new GenericSimpleCheck(NamespacedKey.fromString((String)key), defaultValue);
    }

    @Override
    public NamespacedKey getComponentKey() {
        return this.key;
    }

    @Override
    public void loadConfig(ConfigurationSection section) {
        ConfigurationSection data = ConfigUtil.getOrCreateSection(section, this.key.asMinimalString());
        this.allow = ConfigUtil.getOrCreate(data, "allow", this.defaultValue);
    }

    @Override
    public boolean enforce(GroupConfig group, Material material, CompoundTag itemComponentsTag, String key) {
        boolean changed = false;
        if (!this.allow) {
            itemComponentsTag.remove(key);
            changed = true;
        }
        return changed;
    }
}

