/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.libs.nmsutils.paper1_21_11;

import de.cubeside.itemcontrol.libs.nmsutils.BlockUtils;
import de.cubeside.itemcontrol.libs.nmsutils.NMSUtils;
import de.cubeside.itemcontrol.libs.nmsutils.paper1_21_11.NMSUtilsImpl;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import org.bukkit.NamespacedKey;
import org.bukkit.block.BlockState;
import org.bukkit.block.Vault;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.TrialSpawner;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftPlayer;

public class BlockUtilsImpl
implements BlockUtils {
    private final NMSUtilsImpl nmsUtils;

    public BlockUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    @Override
    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    @Override
    public boolean useBlock(org.bukkit.block.Block block, org.bukkit.entity.Player player) {
        CraftBlock craftBlock = (CraftBlock)block;
        CraftWorld world = (CraftWorld)block.getWorld();
        BlockHitResult blockHitResult = new BlockHitResult(craftBlock.getPosition().getCenter(), Direction.UP, craftBlock.getPosition(), false);
        return craftBlock.getNMS().useWithoutItem((Level)world.getHandle(), (Player)((CraftPlayer)player).getHandle(), blockHitResult).consumesAction();
    }

    @Override
    public Set<UUID> getVaultRewardedPlayers(org.bukkit.block.Block block) {
        BlockState blockState = block.getState();
        if (!(blockState instanceof Vault)) {
            throw new IllegalArgumentException("This block is not a vault");
        }
        Vault vault = (Vault)blockState;
        return new HashSet<UUID>(vault.getRewardedPlayers());
    }

    @Override
    public void setTrialSpawnerCooldown(org.bukkit.block.Block block, int ticks) {
        BlockData blockData;
        TrialSpawnerBlockEntity trialSpawnerBlock;
        CraftWorld world;
        block3: {
            block2: {
                CraftBlock craftBlock = (CraftBlock)block;
                world = (CraftWorld)block.getWorld();
                BlockEntity blockEntity = world.getHandle().getBlockEntity(craftBlock.getPosition());
                if (!(blockEntity instanceof TrialSpawnerBlockEntity)) break block2;
                trialSpawnerBlock = (TrialSpawnerBlockEntity)blockEntity;
                blockData = block.getBlockData();
                if (blockData instanceof TrialSpawner) break block3;
            }
            throw new IllegalArgumentException("This block is not a trial spawner");
        }
        TrialSpawner spawnerData = (TrialSpawner)blockData;
        trialSpawnerBlock.trialSpawner.getStateData().reset();
        trialSpawnerBlock.trialSpawner.getStateData().cooldownEndsAt = world.getHandle().getGameTime() + (long)ticks;
        spawnerData.setTrialSpawnerState(TrialSpawner.State.COOLDOWN);
        block.setBlockData((BlockData)spawnerData);
    }

    @Override
    public void setTrialSpawnerConfig(org.bukkit.block.Block block, NamespacedKey key) {
        CraftBlock craftBlock = (CraftBlock)block;
        CraftWorld world = (CraftWorld)block.getWorld();
        BlockEntity blockEntity = world.getHandle().getBlockEntity(craftBlock.getPosition());
        if (!(blockEntity instanceof TrialSpawnerBlockEntity)) {
            throw new IllegalArgumentException("This block is not a trial spawner");
        }
        TrialSpawnerBlockEntity trialSpawnerBlock = (TrialSpawnerBlockEntity)blockEntity;
        Registry trialSpawnerConfigRegistry = (Registry)MinecraftServer.getServer().registryAccess().lookup(Registries.TRIAL_SPAWNER_CONFIG).get();
        Identifier normal = Identifier.fromNamespaceAndPath((String)key.namespace(), (String)(key.value() + "/normal"));
        Identifier ominous = Identifier.fromNamespaceAndPath((String)key.namespace(), (String)(key.value() + "/ominous"));
        Optional normalConfig = trialSpawnerConfigRegistry.get(normal);
        Optional ominousConfig = trialSpawnerConfigRegistry.get(ominous);
        if (normalConfig.isEmpty() || ominousConfig.isEmpty()) {
            throw new IllegalArgumentException("Config does not exist: " + String.valueOf(key));
        }
        trialSpawnerBlock.trialSpawner.config = trialSpawnerBlock.trialSpawner.config.overrideConfigs((Holder)normalConfig.get(), (Holder)ominousConfig.get());
    }

    @Override
    public Set<NamespacedKey> getTrialSpawnerConfigs() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        Registry trialSpawnerConfigRegistry = (Registry)MinecraftServer.getServer().registryAccess().lookup(Registries.TRIAL_SPAWNER_CONFIG).get();
        for (Identifier loc : trialSpawnerConfigRegistry.keySet()) {
            if (!loc.getPath().endsWith("/normal")) continue;
            String path = loc.getPath().substring(0, loc.getPath().length() - 7);
            result.add(new NamespacedKey(loc.getNamespace(), path));
        }
        return result;
    }

    @Override
    public int getNetworkBlockDataId(BlockData block) {
        return Block.getId((net.minecraft.world.level.block.state.BlockState)((CraftBlockData)block).getState());
    }
}

