/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.libs.nmsutils.paper1_21_11;

import com.destroystokyo.paper.entity.ai.VanillaGoal;
import de.cubeside.itemcontrol.libs.nmsutils.EntityUtils;
import de.cubeside.itemcontrol.libs.nmsutils.NMSUtils;
import de.cubeside.itemcontrol.libs.nmsutils.paper1_21_11.CompoundTagImpl;
import de.cubeside.itemcontrol.libs.nmsutils.paper1_21_11.NMSUtilsImpl;
import de.cubeside.itemcontrol.libs.nmsutils.paper1_21_11.PathfinderGoalLimitedRandomStrollLand;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Level;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftBat;
import org.bukkit.craftbukkit.entity.CraftCamel;
import org.bukkit.craftbukkit.entity.CraftCreature;
import org.bukkit.craftbukkit.entity.CraftCreeper;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftMob;
import org.bukkit.craftbukkit.entity.CraftPiglin;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.entity.CraftRaider;
import org.bukkit.craftbukkit.entity.CraftShulker;
import org.bukkit.craftbukkit.entity.CraftVex;
import org.bukkit.craftbukkit.entity.CraftWolf;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Camel;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Wolf;
import org.bukkit.util.Vector;

public class EntityUtilsImpl
implements EntityUtils {
    private final NMSUtilsImpl nmsUtils;

    public EntityUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    @Override
    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    @Override
    public void clearAI(Entity entity) {
        if (entity instanceof org.bukkit.entity.Mob) {
            this.nmsUtils.getPlugin().getServer().getMobGoals().removeAllGoals((org.bukkit.entity.Mob)entity);
        }
    }

    @Override
    public void addGoalFloat(org.bukkit.entity.Mob mob) {
        if (!Bukkit.getMobGoals().hasGoal(mob, VanillaGoal.FLOAT)) {
            Mob h = ((CraftMob)mob).getHandle();
            h.goalSelector.addGoal(1, (Goal)new FloatGoal(h));
        }
    }

    @Override
    public void addGoalLimitedStrollLand(Creature mob, double velocity, Function<Vector, Boolean> checkTargetFunction) {
        PathfinderMob h = ((CraftCreature)mob).getHandle();
        h.goalSelector.addGoal(7, (Goal)new PathfinderGoalLimitedRandomStrollLand(h, velocity, checkTargetFunction));
    }

    @Override
    public void removeGoalLimitedStrollLand(Creature mob) {
        PathfinderMob h = ((CraftCreature)mob).getHandle();
        for (WrappedGoal wrappedGoal : h.goalSelector.getAvailableGoals()) {
            Goal goal = wrappedGoal.getGoal();
            if (!(goal instanceof PathfinderGoalLimitedRandomStrollLand)) continue;
            PathfinderGoalLimitedRandomStrollLand goal2 = (PathfinderGoalLimitedRandomStrollLand)goal;
            wrappedGoal.stop();
            h.goalSelector.removeGoal((Goal)goal2);
            break;
        }
    }

    @Override
    public int getShulkerOpenState(Entity shulker) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return 0;
            }
            CraftShulker cs = (CraftShulker)shulker;
            return cs.getHandle().getRawPeekAmount();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get shulker open state", e);
            return 0;
        }
    }

    @Override
    public void setShulkerOpenState(Entity shulker, int state) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return;
            }
            state = Math.max(0, Math.min(127, state));
            CraftShulker cs = (CraftShulker)shulker;
            cs.getHandle().setRawPeekAmount(state);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set shulker open state", e);
        }
    }

    @Override
    public boolean isPiglinDancing(Entity piglin) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return false;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            return cs.getHandle().isDancing();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get piglin dancing state", e);
            return false;
        }
    }

    @Override
    public void setPiglinDancing(Entity piglin, boolean dancing) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            cs.getHandle().setDancing(dancing);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set piglin dancing state", e);
        }
    }

    @Override
    public void sendEntityPositionUpdate(Entity entity) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
        ChunkMap.TrackedEntity ete = handle.moonrise$getTrackedEntity();
        if (ete != null) {
            ClientboundTeleportEntityPacket positionPacket = new ClientboundTeleportEntityPacket(handle.getId(), PositionMoveRotation.of((net.minecraft.world.entity.Entity)handle), Set.of(), handle.onGround);
            ete.seenBy.stream().forEach(viewer -> viewer.send((Packet)positionPacket));
        }
    }

    @Override
    public void moveEntity(Entity e, double x, double y, double z) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        handle.move(MoverType.SELF, new Vec3(x, y, z));
    }

    @Override
    public void moveEntity(Entity e, Vector v) {
        this.moveEntity(e, v.getX(), v.getY(), v.getZ());
    }

    @Override
    public void setEntityHeadRotation(Entity e, float headRotation) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        if (handle instanceof LivingEntity) {
            ((LivingEntity)handle).yHeadRot = headRotation;
        } else {
            handle.setYHeadRot(headRotation);
        }
    }

    @Override
    public float getEntityHeadRotation(Entity e) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        return handle.getYHeadRot();
    }

    @Override
    public void setEntityYaw(Entity e, float yaw) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        handle.setYRot(yaw);
    }

    @Override
    public float getEntityYaw(Entity e) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        return handle.getYRot();
    }

    @Override
    public void setEntityPitch(Entity e, float pitch) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        handle.setXRot(pitch);
    }

    @Override
    public float getEntityPitch(Entity e) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        return handle.getXRot();
    }

    @Override
    public void setEntityNavigationTarget(Entity entity, Location target, double speed) {
        if (entity instanceof Bat) {
            ((CraftBat)entity).getHandle().targetPosition = new BlockPos(target.getBlockX(), target.getBlockY(), target.getBlockZ());
        } else if (entity instanceof Vex) {
            net.minecraft.world.entity.monster.Vex entityVex = ((CraftVex)entity).getHandle();
            entityVex.getMoveControl().setWantedPosition(target.getX(), target.getY(), target.getZ(), speed);
            if (entityVex.getTarget() == null) {
                entityVex.getLookControl().setLookAt(target.getX(), target.getY(), target.getZ(), 180.0f, 20.0f);
            }
        } else if (entity instanceof CraftMob) {
            ((CraftMob)entity).getHandle().getNavigation().moveTo(target.getX(), target.getY(), target.getZ(), speed);
        } else {
            throw new IllegalArgumentException("Cannot set the navigation target for this mob: " + String.valueOf(entity == null ? "null" : entity.getType()));
        }
    }

    @Override
    public void setEntityLeftHanded(Entity ent, boolean left) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof Mob) {
            Mob mob = (Mob)nmsEntity;
            mob.setLeftHanded(left);
        }
    }

    @Override
    public boolean isEntityLeftHanded(Entity ent) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof Mob) {
            Mob mob = (Mob)nmsEntity;
            return mob.isLeftHanded();
        }
        return false;
    }

    @Override
    public boolean isEntityInvisible(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.isInvisible();
    }

    @Override
    public void setEntityInvisible(Entity entity, boolean invisible) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.setInvisible(invisible);
    }

    @Override
    public boolean hasEntityNoClip(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.noPhysics;
    }

    @Override
    public void setEntityNoClip(Entity entity, boolean noClip) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.noPhysics = noClip;
    }

    @Override
    public boolean areChunkEntitiesLoaded(Chunk c2) {
        return ((CraftWorld)c2.getWorld()).getHandle().areEntitiesLoaded(ChunkPos.asLong((int)c2.getX(), (int)c2.getZ()));
    }

    @Override
    public void loadChunkEntities(Chunk c2) {
        this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Call to unimplemented method", new RuntimeException());
    }

    @Override
    public void setOnGround(Entity entity, boolean onGround) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.setOnGround(onGround);
    }

    @Override
    public Entity getEntityById(World world, int id) {
        net.minecraft.world.entity.Entity entity = ((CraftWorld)world).getHandle().getEntity(id);
        return entity == null ? null : entity.getBukkitEntity();
    }

    @Override
    public void setPose(Entity entity, Pose pose) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.setPose(net.minecraft.world.entity.Pose.values()[pose.ordinal()]);
    }

    @Override
    public void setWolfAngerTime(Wolf entity, int timeInTicks) {
        net.minecraft.world.entity.animal.wolf.Wolf nmsEntity = ((CraftWolf)entity).getHandle();
        nmsEntity.setTimeToRemainAngry((long)timeInTicks);
    }

    @Override
    public void setAggressive(org.bukkit.entity.Mob entity, boolean aggressive) {
        Mob nmsEntity = ((CraftMob)entity).getHandle();
        nmsEntity.setAggressive(aggressive);
    }

    @Override
    public boolean isAggressive(org.bukkit.entity.Mob entity) {
        Mob nmsEntity = ((CraftMob)entity).getHandle();
        return nmsEntity.isAggressive();
    }

    @Override
    public boolean isCelebrating(org.bukkit.entity.Raider entity) {
        Raider nmsEntity = ((CraftRaider)entity).getHandle();
        return nmsEntity.isCelebrating();
    }

    @Override
    public void setCelebrating(org.bukkit.entity.Raider entity, boolean celebrating) {
        Raider nmsEntity = ((CraftRaider)entity).getHandle();
        nmsEntity.setCelebrating(celebrating);
    }

    @Override
    public void setCamelLastPoseChange(Camel entity, long tick) {
        net.minecraft.world.entity.animal.camel.Camel nmsEntity = ((CraftCamel)entity).getHandle();
        nmsEntity.resetLastPoseChangeTick(nmsEntity.level().getGameTime() - tick);
    }

    @Override
    public long getCamelLastPoseChange(Camel entity) {
        net.minecraft.world.entity.animal.camel.Camel nmsEntity = ((CraftCamel)entity).getHandle();
        return nmsEntity.getPoseTime();
    }

    @Override
    public boolean isCamelSitting(Camel entity) {
        net.minecraft.world.entity.animal.camel.Camel nmsEntity = ((CraftCamel)entity).getHandle();
        return nmsEntity.isCamelSitting();
    }

    @Override
    public de.cubeside.itemcontrol.libs.nmsutils.nbt.CompoundTag getNbt(Entity entity) {
        TagValueOutput tagValueOutput;
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(nmsEntity.problemPath(), this.nmsUtils.getPlugin().getSLF4JLogger());){
            tagValueOutput = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)nmsEntity.registryAccess());
            nmsEntity.saveWithoutId((ValueOutput)tagValueOutput);
        }
        return new CompoundTagImpl(tagValueOutput.buildResult());
    }

    @Override
    public void setNbt(Entity entity, de.cubeside.itemcontrol.libs.nmsutils.nbt.CompoundTag nbt) {
        CompoundTag nativeNbt = ((CompoundTagImpl)nbt).handle;
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        UUID uuid = nmsEntity.getUUID();
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(nmsEntity.problemPath(), this.nmsUtils.getPlugin().getSLF4JLogger());){
            ValueInput valueInput = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)nmsEntity.registryAccess(), (CompoundTag)nativeNbt);
            nmsEntity.load(valueInput);
            nmsEntity.setUUID(uuid);
        }
    }

    @Override
    public void mergeNbt(Entity entity, de.cubeside.itemcontrol.libs.nmsutils.nbt.CompoundTag nbt) {
        CompoundTag nativeNbt = ((CompoundTagImpl)nbt).handle;
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(nmsEntity.problemPath(), this.nmsUtils.getPlugin().getSLF4JLogger());){
            TagValueOutput tagValueOutput = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)nmsEntity.registryAccess());
            nmsEntity.saveWithoutId((ValueOutput)tagValueOutput);
            CompoundTag oldNbt = tagValueOutput.buildResult();
            CompoundTag newNbt = oldNbt.copy().merge(nativeNbt);
            if (!oldNbt.equals((Object)newNbt)) {
                UUID uuid = nmsEntity.getUUID();
                ValueInput valueInput = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)nmsEntity.registryAccess(), (CompoundTag)newNbt);
                nmsEntity.load(valueInput);
                nmsEntity.setUUID(uuid);
            }
        }
    }

    @Override
    public void setSwellDir(org.bukkit.entity.Creeper creeper, int swellDir) {
        Creeper mcCreeper = ((CraftCreeper)creeper).getHandle();
        mcCreeper.setSwellDir(swellDir);
    }

    @Override
    public void resyncEntityPosition(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.moonrise$getTrackedEntity().serverEntity.onPlayerAdd();
        nmsEntity.needsSync = true;
    }

    @Override
    public void setCanInstaBuild(Player player, boolean instabuild) {
        ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        if (serverPlayer.getAbilities().instabuild != instabuild) {
            serverPlayer.getAbilities().instabuild = instabuild;
            serverPlayer.onUpdateAbilities();
        }
    }

    @Override
    public boolean canInstaBuild(Player player) {
        return ((CraftPlayer)player).getHandle().getAbilities().instabuild;
    }

    @Override
    public void setOriginWorld(Entity entity, World world) {
        ((CraftEntity)entity).getHandle().originWorld = world == null ? null : world.getUID();
    }
}

