/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.checks;

import de.cubeside.itemcontrol.checks.ComponentCheck;
import de.cubeside.itemcontrol.config.GroupConfig;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.CompoundTag;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.ListTag;
import de.cubeside.itemcontrol.util.ConfigUtil;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.bukkit.configuration.ConfigurationSection;

public class CheckPotDecorations
implements ComponentCheck {
    private static final NamespacedKey KEY = NamespacedKey.fromString((String)"minecraft:pot_decorations");
    private boolean allow;

    @Override
    public NamespacedKey getComponentKey() {
        return KEY;
    }

    @Override
    public void loadConfig(ConfigurationSection section) {
        ConfigurationSection data = ConfigUtil.getOrCreateSection(section, KEY.asMinimalString());
        this.allow = ConfigUtil.getOrCreate(data, "allow", true);
    }

    @Override
    public boolean enforce(GroupConfig group, Material material, CompoundTag itemComponentsTag, String key) {
        boolean changed = false;
        ListTag sheardList = itemComponentsTag.getList(key);
        if (this.allow && sheardList != null) {
            while (sheardList.size() > 4) {
                sheardList.remove(sheardList.size() - 1);
                changed = true;
            }
            for (int i = sheardList.size() - 1; i >= 0; --i) {
                String s = sheardList.getString(i);
                if (s != null) {
                    Material m;
                    NamespacedKey sheardKey = NamespacedKey.fromString((String)s);
                    Material material2 = m = sheardKey != null ? (Material)Registry.MATERIAL.get(sheardKey) : null;
                    if (m != null && (m == Material.BRICK || Tag.ITEMS_DECORATED_POT_SHERDS.isTagged((Keyed)m))) continue;
                    sheardList.remove(i);
                    changed = true;
                    continue;
                }
                sheardList.remove(i);
                changed = true;
            }
            if (sheardList.isEmpty()) {
                itemComponentsTag.remove(key);
                changed = true;
            }
        } else {
            itemComponentsTag.remove(key);
            changed = true;
        }
        return changed;
    }
}

