/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio;

import de.cubeside.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.MappingVisitor;
import de.cubeside.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.format.EnigmaReader;
import de.cubeside.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.format.MappingFormat;
import de.cubeside.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.format.ProGuardReader;
import de.cubeside.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.format.SrgReader;
import de.cubeside.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.format.Tiny1Reader;
import de.cubeside.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.format.Tiny2Reader;
import de.cubeside.itemcontrol.libs.nmsutils.libs.net.fabricmc.mappingio.format.TsrgReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;

public final class MappingReader {
    private static final int DETECT_HEADER_LEN = 4096;

    public static MappingFormat detectFormat(Path file) throws IOException {
        if (Files.isDirectory(file, new LinkOption[0])) {
            return MappingFormat.ENIGMA;
        }
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(file, new OpenOption[0]), StandardCharsets.UTF_8);){
            MappingFormat mappingFormat = MappingReader.detectFormat(reader);
            return mappingFormat;
        }
    }

    public static MappingFormat detectFormat(Reader reader) throws IOException {
        int pos;
        int len;
        char[] buffer = new char[4096];
        for (pos = 0; pos < buffer.length && (len = reader.read(buffer, pos, buffer.length - pos)) >= 0; pos += len) {
        }
        if (pos < 3) {
            return null;
        }
        switch (String.valueOf(buffer, 0, 3)) {
            case "v1\t": {
                return MappingFormat.TINY;
            }
            case "tin": {
                return MappingFormat.TINY_2;
            }
            case "tsr": {
                return MappingFormat.TSRG2;
            }
            case "PK:": 
            case "CL:": 
            case "MD:": 
            case "FD:": {
                return MappingFormat.SRG;
            }
        }
        String headerStr = String.valueOf(buffer, 0, pos);
        if (headerStr.contains(" -> ")) {
            return MappingFormat.PROGUARD;
        }
        if (headerStr.contains("\n\t")) {
            return MappingFormat.TSRG;
        }
        return null;
    }

    public static List<String> getNamespaces(Path file) throws IOException {
        return MappingReader.getNamespaces(file, null);
    }

    public static List<String> getNamespaces(Path file, MappingFormat format) throws IOException {
        if (format == null && (format = MappingReader.detectFormat(file)) == null) {
            throw new IOException("invalid/unsupported mapping format");
        }
        if (format.hasNamespaces) {
            try (BufferedReader reader = Files.newBufferedReader(file);){
                List<String> list = MappingReader.getNamespaces(reader, format);
                return list;
            }
        }
        return Arrays.asList("source", "target");
    }

    public static List<String> getNamespaces(Reader reader) throws IOException {
        return MappingReader.getNamespaces(reader, null);
    }

    public static List<String> getNamespaces(Reader reader, MappingFormat format) throws IOException {
        if (format == null) {
            if (!reader.markSupported()) {
                reader = new BufferedReader(reader);
            }
            reader.mark(4096);
            format = MappingReader.detectFormat(reader);
            reader.reset();
            if (format == null) {
                throw new IOException("invalid/unsupported mapping format");
            }
        }
        if (format.hasNamespaces) {
            switch (format) {
                case TINY: {
                    return Tiny1Reader.getNamespaces(reader);
                }
                case TINY_2: {
                    return Tiny2Reader.getNamespaces(reader);
                }
                case TSRG2: {
                    return TsrgReader.getNamespaces(reader);
                }
            }
            throw new IllegalStateException();
        }
        return Arrays.asList("source", "target");
    }

    public static void read(Path file, MappingVisitor visitor) throws IOException {
        MappingReader.read(file, null, visitor);
    }

    public static void read(Path file, MappingFormat format, MappingVisitor visitor) throws IOException {
        if (format == null && (format = MappingReader.detectFormat(file)) == null) {
            throw new IOException("invalid/unsupported mapping format");
        }
        if (format.hasSingleFile()) {
            try (BufferedReader reader = Files.newBufferedReader(file);){
                MappingReader.read(reader, format, visitor);
            }
        } else {
            switch (format) {
                case ENIGMA: {
                    EnigmaReader.read(file, visitor);
                    break;
                }
                case MCP: {
                    throw new UnsupportedOperationException();
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public static void read(Reader reader, MappingVisitor visitor) throws IOException {
        MappingReader.read(reader, null, visitor);
    }

    public static void read(Reader reader, MappingFormat format, MappingVisitor visitor) throws IOException {
        if (format == null) {
            if (!reader.markSupported()) {
                reader = new BufferedReader(reader);
            }
            reader.mark(4096);
            format = MappingReader.detectFormat(reader);
            reader.reset();
            if (format == null) {
                throw new IOException("invalid/unsupported mapping format");
            }
        }
        switch (format) {
            case TINY: {
                Tiny1Reader.read(reader, visitor);
                break;
            }
            case TINY_2: {
                Tiny2Reader.read(reader, visitor);
                break;
            }
            case SRG: {
                SrgReader.read(reader, visitor);
                break;
            }
            case TSRG2: 
            case TSRG: {
                TsrgReader.read(reader, visitor);
                break;
            }
            case PROGUARD: {
                ProGuardReader.read(reader, visitor);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

