/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.paper1_20_4;

import com.destroystokyo.paper.entity.ai.VanillaGoal;
import java.io.Serializable;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Level;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftBat;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftCamel;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftMob;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPiglin;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftRaider;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftShulker;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftVex;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftWolf;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Camel;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Wolf;
import org.bukkit.util.Vector;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.EntityUtils;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.NMSUtils;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.nbt.CompoundTag;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.paper1_20_4.CompoundTagImpl;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.paper1_20_4.NMSUtilsImpl;
import org.cyberiantiger.minecraft.itemcontrol.libs.nmsutils.paper1_20_4.PathfinderGoalLimitedRandomStrollLand;

public class EntityUtilsImpl
implements EntityUtils {
    private final NMSUtilsImpl nmsUtils;

    public EntityUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    @Override
    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    @Override
    public void clearAI(Entity entity) {
        if (entity instanceof Mob) {
            this.nmsUtils.getPlugin().getServer().getMobGoals().removeAllGoals((Mob)entity);
        }
    }

    @Override
    public void addGoalFloat(Mob mob) {
        if (!Bukkit.getMobGoals().hasGoal(mob, VanillaGoal.FLOAT)) {
            EntityInsentient h = ((CraftMob)mob).getHandle();
            h.bO.a(1, (PathfinderGoal)new PathfinderGoalFloat(h));
        }
    }

    @Override
    public void addGoalLimitedStrollLand(Creature mob, double velocity, Function<Vector, Boolean> checkTargetFunction) {
        EntityCreature h = ((CraftCreature)mob).getHandle();
        h.bO.a(7, (PathfinderGoal)new PathfinderGoalLimitedRandomStrollLand(h, velocity, checkTargetFunction));
    }

    @Override
    public void removeGoalLimitedStrollLand(Creature mob) {
        EntityCreature h = ((CraftCreature)mob).getHandle();
        for (PathfinderGoalWrapped wrappedGoal : h.bO.b()) {
            PathfinderGoal pathfinderGoal = wrappedGoal.k();
            if (!(pathfinderGoal instanceof PathfinderGoalLimitedRandomStrollLand)) continue;
            PathfinderGoalLimitedRandomStrollLand goal = (PathfinderGoalLimitedRandomStrollLand)pathfinderGoal;
            wrappedGoal.d();
            h.bO.a((PathfinderGoal)goal);
            break;
        }
    }

    @Override
    public int getShulkerOpenState(Entity shulker) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return 0;
            }
            CraftShulker cs = (CraftShulker)shulker;
            return cs.getHandle().gl();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get shulker open state", e);
            return 0;
        }
    }

    @Override
    public void setShulkerOpenState(Entity shulker, int state) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return;
            }
            state = Math.max(0, Math.min(127, state));
            CraftShulker cs = (CraftShulker)shulker;
            cs.getHandle().b(state);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set shulker open state", e);
        }
    }

    @Override
    public boolean isPiglinDancing(Entity piglin) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return false;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            return cs.getHandle().gm();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get piglin dancing state", e);
            return false;
        }
    }

    @Override
    public void setPiglinDancing(Entity piglin, boolean dancing) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            cs.getHandle().x(dancing);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set piglin dancing state", e);
        }
    }

    @Override
    public void sendEntityPositionUpdate(Entity entity) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
        PlayerChunkMap.EntityTracker ete = handle.tracker;
        if (ete != null) {
            PacketPlayOutEntityTeleport positionPacket = new PacketPlayOutEntityTeleport(handle);
            ete.f.stream().forEach(viewer -> viewer.b((Packet)positionPacket));
        }
    }

    @Override
    public void moveEntity(Entity e, double x, double y, double z) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        handle.a(EnumMoveType.a, new Vec3D(x, y, z));
    }

    @Override
    public void moveEntity(Entity e, Vector v) {
        this.moveEntity(e, v.getX(), v.getY(), v.getZ());
    }

    @Override
    public void setEntityHeadRotation(Entity e, float headRotation) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        if (handle instanceof EntityLiving) {
            ((EntityLiving)handle).aW = headRotation;
        } else {
            handle.n(headRotation);
        }
    }

    @Override
    public float getEntityHeadRotation(Entity e) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        return handle.cp();
    }

    @Override
    public void setEntityYaw(Entity e, float yaw) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        handle.r(yaw);
    }

    @Override
    public float getEntityYaw(Entity e) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        return handle.dC();
    }

    @Override
    public void setEntityPitch(Entity e, float pitch) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        handle.s(pitch);
    }

    @Override
    public float getEntityPitch(Entity e) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        return handle.dE();
    }

    @Override
    public void setEntityNavigationTarget(Entity entity, Location target, double speed) {
        if (entity instanceof Bat) {
            ((CraftBat)entity).getHandle().bV = new BlockPosition(target.getBlockX(), target.getBlockY(), target.getBlockZ());
        } else if (entity instanceof Vex) {
            EntityVex entityVex = ((CraftVex)entity).getHandle();
            entityVex.K().a(target.getX(), target.getY(), target.getZ(), speed);
            if (entityVex.q() == null) {
                entityVex.I().a(target.getX(), target.getY(), target.getZ(), 180.0f, 20.0f);
            }
        } else if (entity instanceof CraftMob) {
            ((CraftMob)entity).getHandle().N().a(target.getX(), target.getY(), target.getZ(), speed);
        } else {
            throw new IllegalArgumentException("Cannot set the navigation target for this mob: " + (Serializable)((Object)(entity == null ? "null" : entity.getType())));
        }
    }

    @Override
    public void setEntityLeftHanded(Entity ent, boolean left) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)nmsEntity;
            mob.u(left);
        }
    }

    @Override
    public boolean isEntityLeftHanded(Entity ent) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)nmsEntity;
            return mob.fV();
        }
        return false;
    }

    @Override
    public boolean isEntityInvisible(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.ce();
    }

    @Override
    public void setEntityInvisible(Entity entity, boolean invisible) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.j(invisible);
    }

    @Override
    public boolean hasEntityNoClip(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.af;
    }

    @Override
    public void setEntityNoClip(Entity entity, boolean noClip) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.af = noClip;
    }

    @Override
    public boolean areChunkEntitiesLoaded(Chunk c2) {
        return ((CraftWorld)c2.getWorld()).getHandle().c(ChunkCoordIntPair.c((int)c2.getX(), (int)c2.getZ()));
    }

    @Override
    public void loadChunkEntities(Chunk c2) {
        this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Call to unimplemented method", new RuntimeException());
    }

    @Override
    public void setOnGround(Entity entity, boolean onGround) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.c(onGround);
    }

    @Override
    public Entity getEntityById(World world, int id) {
        net.minecraft.world.entity.Entity entity = ((CraftWorld)world).getHandle().a(id);
        return entity == null ? null : entity.getBukkitEntity();
    }

    @Override
    public void setPose(Entity entity, Pose pose) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.b(EntityPose.values()[pose.ordinal()]);
    }

    @Override
    public void setWolfAngerTime(Wolf entity, int timeInTicks) {
        EntityWolf nmsEntity = ((CraftWolf)entity).getHandle();
        nmsEntity.a(timeInTicks);
    }

    @Override
    public void setAggressive(Mob entity, boolean aggressive) {
        EntityInsentient nmsEntity = ((CraftMob)entity).getHandle();
        nmsEntity.v(aggressive);
    }

    @Override
    public boolean isAggressive(Mob entity) {
        EntityInsentient nmsEntity = ((CraftMob)entity).getHandle();
        return nmsEntity.fW();
    }

    @Override
    public boolean isCelebrating(Raider entity) {
        EntityRaider nmsEntity = ((CraftRaider)entity).getHandle();
        return nmsEntity.gv();
    }

    @Override
    public void setCelebrating(Raider entity, boolean celebrating) {
        EntityRaider nmsEntity = ((CraftRaider)entity).getHandle();
        nmsEntity.A(celebrating);
    }

    @Override
    public void setCamelLastPoseChange(Camel entity, long tick) {
        net.minecraft.world.entity.animal.camel.Camel nmsEntity = ((CraftCamel)entity).getHandle();
        nmsEntity.a(nmsEntity.dM().X() - tick);
    }

    @Override
    public long getCamelLastPoseChange(Camel entity) {
        net.minecraft.world.entity.animal.camel.Camel nmsEntity = ((CraftCamel)entity).getHandle();
        return nmsEntity.gs();
    }

    @Override
    public boolean isCamelSitting(Camel entity) {
        net.minecraft.world.entity.animal.camel.Camel nmsEntity = ((CraftCamel)entity).getHandle();
        return nmsEntity.gm();
    }

    @Override
    public CompoundTag getNbt(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        NBTTagCompound compoundTag = nmsEntity.f(new NBTTagCompound());
        return new CompoundTagImpl(compoundTag);
    }

    @Override
    public void setNbt(Entity entity, CompoundTag nbt) {
        NBTTagCompound nativeNbt = ((CompoundTagImpl)nbt).handle;
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        UUID uuid = nmsEntity.cw();
        nmsEntity.g(nativeNbt);
        nmsEntity.a_(uuid);
    }

    @Override
    public void mergeNbt(Entity entity, CompoundTag nbt) {
        NBTTagCompound newNbt;
        NBTTagCompound nativeNbt = ((CompoundTagImpl)nbt).handle;
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        NBTTagCompound oldNbt = nmsEntity.f(new NBTTagCompound());
        if (!oldNbt.equals((Object)(newNbt = oldNbt.h().a(nativeNbt)))) {
            UUID uuid = nmsEntity.cw();
            nmsEntity.g(newNbt);
            nmsEntity.a_(uuid);
        }
    }
}

