/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.nbt;

import java.util.Arrays;
import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagType;

public final class ByteArrayTag
extends Tag<byte[]> {
    private final byte[] value;

    public ByteArrayTag(byte[] value) {
        this.value = value;
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    @Override
    public TagType getType() {
        return TagType.BYTE_ARRAY;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append('<');
        byte[] v = this.getValue();
        for (int i = 0; i < v.length; ++i) {
            if (i != 0) {
                ret.append(", ");
            }
            ret.append(v[i] & 0xFF);
        }
        ret.append('>');
        return ret.toString();
    }

    public int hashCode() {
        int hash = 3;
        hash = 43 * hash + Arrays.hashCode(this.value);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayTag other = (ByteArrayTag)obj;
        return Arrays.equals(this.value, other.value);
    }
}

