/*
 * Decompiled with CFR 0.152.
 */
package org.cyberiantiger.minecraft.nbt;

import java.util.HashMap;
import java.util.Map;
import org.cyberiantiger.minecraft.nbt.ByteArrayTag;
import org.cyberiantiger.minecraft.nbt.ByteTag;
import org.cyberiantiger.minecraft.nbt.DoubleTag;
import org.cyberiantiger.minecraft.nbt.FloatTag;
import org.cyberiantiger.minecraft.nbt.IntArrayTag;
import org.cyberiantiger.minecraft.nbt.IntTag;
import org.cyberiantiger.minecraft.nbt.ListTag;
import org.cyberiantiger.minecraft.nbt.LongTag;
import org.cyberiantiger.minecraft.nbt.ShortTag;
import org.cyberiantiger.minecraft.nbt.StringTag;
import org.cyberiantiger.minecraft.nbt.Tag;
import org.cyberiantiger.minecraft.nbt.TagType;

public final class CompoundTag
extends Tag<Map<String, Tag>> {
    private final Map<String, Tag> value;

    public CompoundTag() {
        this(new HashMap<String, Tag>());
    }

    public CompoundTag(Map<String, Tag> value) {
        this.value = value;
    }

    public boolean containsKey(String key) {
        return this.value.containsKey(key);
    }

    public boolean containsKey(String key, TagType type) {
        Tag t = this.value.get(key);
        return t == null ? false : t.getType() == type;
    }

    public void remove(String string) {
        this.value.remove(string);
    }

    public byte getByte(String name) {
        ByteTag tag = (ByteTag)this.value.get(name);
        return tag == null ? (byte)0 : tag.getRawValue();
    }

    public void setByte(String name, byte b) {
        this.value.put(name, new ByteTag(b));
    }

    public byte[] getByteArray(String name) {
        ByteArrayTag tag = (ByteArrayTag)this.value.get(name);
        return tag == null ? null : tag.getValue();
    }

    public void setByteArray(String name, byte[] b) {
        this.value.put(name, new ByteArrayTag(b));
    }

    public CompoundTag getCompound(String name) {
        return (CompoundTag)this.value.get(name);
    }

    public void setCompound(String name) {
        this.setCompound(name, new CompoundTag());
    }

    public void setCompound(String name, CompoundTag c) {
        this.value.put(name, c);
    }

    public double getDouble(String name) {
        DoubleTag tag = (DoubleTag)this.value.get(name);
        return tag == null ? 0.0 : tag.getRawValue();
    }

    public void setDouble(String name, double d) {
        this.value.put(name, new DoubleTag(d));
    }

    public float getFloat(String name) {
        FloatTag tag = (FloatTag)this.value.get(name);
        return tag == null ? 0.0f : tag.getRawValue();
    }

    public void setFloat(String name, float f) {
        this.value.put(name, new FloatTag(f));
    }

    public int[] getIntArray(String name) {
        IntArrayTag tag = (IntArrayTag)this.value.get(name);
        return tag == null ? null : tag.getValue();
    }

    public void setIntArray(String name, int[] v) {
        this.value.put(name, new IntArrayTag(v));
    }

    public int getInt(String name) {
        IntTag tag = (IntTag)this.value.get(name);
        return tag == null ? 0 : tag.getRawValue();
    }

    public void setInt(String name, int v) {
        this.value.put(name, new IntTag(v));
    }

    public ListTag getList(String name) {
        return (ListTag)this.value.get(name);
    }

    public void setList(String name, ListTag l) {
        this.value.put(name, l);
    }

    public long getLong(String name) {
        LongTag tag = (LongTag)this.value.get(name);
        return tag == null ? 0L : tag.getRawValue();
    }

    public void setLong(String name, long l) {
        this.value.put(name, new LongTag(l));
    }

    public short getShort(String name) {
        ShortTag tag = (ShortTag)this.value.get(name);
        return tag == null ? (short)0 : tag.getRawValue();
    }

    public void setShort(String name, short s) {
        this.value.put(name, new ShortTag(s));
    }

    public String getString(String name) {
        StringTag tag = (StringTag)this.value.get(name);
        return tag == null ? null : tag.getValue();
    }

    public void setString(String name, String v) {
        this.value.put(name, new StringTag(v));
    }

    @Override
    public Map<String, Tag> getValue() {
        return this.value;
    }

    @Override
    public TagType getType() {
        return TagType.COMPOUND;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append('{');
        boolean first = true;
        for (Map.Entry<String, Tag> t : this.value.entrySet()) {
            if (first) {
                first = false;
            } else {
                ret.append(", ");
            }
            ret.append(StringTag.toString(t.getKey()));
            ret.append(" : ");
            ret.append(t.getValue());
        }
        ret.append('}');
        return ret.toString();
    }

    public int hashCode() {
        int hash = 5;
        hash = 31 * hash + (this.value != null ? this.value.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompoundTag other = (CompoundTag)obj;
        return this.value == other.value || this.value != null && this.value.equals(other.value);
    }
}

