/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.checks;

import de.cubeside.itemcontrol.Main;
import de.cubeside.itemcontrol.checks.BaseCheckName;
import de.cubeside.itemcontrol.checks.ComponentCheck;
import de.cubeside.itemcontrol.config.GroupConfig;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.CompoundTag;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.ListTag;
import de.cubeside.itemcontrol.util.ConfigUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.configuration.ConfigurationSection;

public class CheckAttributeModifiers
implements ComponentCheck {
    private static final NamespacedKey KEY = NamespacedKey.fromString((String)"minecraft:attribute_modifiers");
    private HashSet<NamespacedKey> allowed = new HashSet();
    private boolean allowAll;
    private boolean allowModifyDisplay;
    private int displayMaxCustomNameLength;

    @Override
    public NamespacedKey getComponentKey() {
        return KEY;
    }

    @Override
    public void loadConfig(ConfigurationSection section) {
        ConfigurationSection data = ConfigUtil.getOrCreateSection(section, KEY.asMinimalString());
        this.allowAll = ConfigUtil.getOrCreate(data, "allow_all", false);
        this.allowModifyDisplay = ConfigUtil.getOrCreate(data, "allow_modify_display", false);
        this.displayMaxCustomNameLength = ConfigUtil.getOrCreate(data, "display_max_custom_name_length", 1000);
        this.allowed.clear();
        boolean rewriteAllow = false;
        for (String s : ConfigUtil.getOrCreate(data, "allow", List.of())) {
            NamespacedKey key;
            if (s.startsWith("generic.")) {
                s = s.substring(8);
                rewriteAllow = true;
            }
            if ((key = NamespacedKey.fromString((String)s)) == null || Registry.ATTRIBUTE.get(key) == null) {
                Main.getInstance().getLogger().warning("Invalid attribute modifier: " + s);
                continue;
            }
            this.allowed.add(key);
        }
        if (rewriteAllow) {
            ArrayList<String> allow = new ArrayList<String>();
            for (String s : ConfigUtil.getOrCreate(data, "allow", List.of())) {
                if (s.startsWith("generic.")) {
                    s = s.substring(8);
                }
                allow.add(s);
                data.set("allow", allow);
                Main.getInstance().saveConfig();
            }
        }
    }

    @Override
    public boolean enforce(GroupConfig group, Material material, CompoundTag itemComponentsTag, String key) {
        boolean changed = false;
        ListTag modifiersList = itemComponentsTag.getList(key);
        if (modifiersList != null) {
            if (!this.allowAll) {
                changed |= this.filterModifiers(group, modifiersList);
            }
            if (modifiersList.isEmpty()) {
                itemComponentsTag.remove(key);
                changed = true;
            }
        } else {
            itemComponentsTag.remove(key);
            changed = true;
        }
        return changed;
    }

    private boolean filterModifiers(GroupConfig group, ListTag modifiersList) {
        boolean changed = false;
        for (int i = modifiersList.size() - 1; i >= 0; --i) {
            NamespacedKey key;
            String s;
            CompoundTag tag = modifiersList.getCompound(i);
            if (tag == null) {
                modifiersList.remove(i);
                changed = true;
                continue;
            }
            if (tag.containsKey("display")) {
                if (!this.allowModifyDisplay) {
                    tag.remove("display");
                    changed = true;
                } else if (this.displayMaxCustomNameLength <= 0) {
                    displayTag = tag.getCompound("display", false);
                    if (displayTag != null && (displayTag.containsKey("value") || "override".equals(displayTag.getString("type")))) {
                        tag.remove("display");
                        changed = true;
                    }
                } else {
                    displayTag = tag.getCompound("display", false);
                    if (displayTag != null && displayTag.containsKey("value") && BaseCheckName.enforce(displayTag, "value", true, true, this.displayMaxCustomNameLength, group.getMaxComponentExpansions())) {
                        changed = true;
                    }
                }
            }
            if ((s = tag.getString("type")) == null) {
                modifiersList.remove(i);
                changed = true;
                continue;
            }
            if (this.allowAll || (key = NamespacedKey.fromString((String)s)) != null && this.allowed.contains(key)) continue;
            modifiersList.remove(i);
            changed = true;
        }
        return changed;
    }
}

