/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.libs.nmsutils.paper1_21_11;

import com.destroystokyo.paper.profile.ProfileProperty;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import de.cubeside.itemcontrol.libs.nmsutils.MiscUtils;
import de.cubeside.itemcontrol.libs.nmsutils.NMSUtils;
import de.cubeside.itemcontrol.libs.nmsutils.paper1_21_11.NMSUtilsImpl;
import io.papermc.paper.adventure.PaperAdventure;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.numbers.BlankFormat;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.Util;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Team;

public class MiscUtilsImpl
implements MiscUtils {
    private final NMSUtilsImpl nmsUtils;
    private Field fieldBlockBehaviour_properties;
    private MapColor transparentColor;
    private Field fieldBlockStateBase_materialColor;
    private final ThreadLocal<UUID> currentContextPlayer;

    public MiscUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
        this.currentContextPlayer = this.getCurrentContextPlayerInstanceFromPacketListener();
    }

    private ThreadLocal<UUID> getCurrentContextPlayerInstanceFromPacketListener() {
        try {
            Field currentPacketHandledPlayer = ServerGamePacketListenerImpl.class.getDeclaredField("currentPacketHandledPlayer");
            currentPacketHandledPlayer.setAccessible(true);
            return (ThreadLocal)currentPacketHandledPlayer.get(null);
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            this.nmsUtils.getPlugin().getLogger().info("Could not find field currentContextPlayer");
            return null;
        }
    }

    @Override
    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    @Override
    public void setBlockMapColorTransparent(Material m) {
        if (this.fieldBlockBehaviour_properties == null) {
            Class<BlockBehaviour.Properties> classBlockProperties = BlockBehaviour.Properties.class;
            Class<BlockBehaviour> classBlockBehaviour = BlockBehaviour.class;
            this.fieldBlockBehaviour_properties = null;
            for (Field f2 : classBlockBehaviour.getDeclaredFields()) {
                if (f2.getType() != classBlockProperties) continue;
                this.fieldBlockBehaviour_properties = f2;
                this.fieldBlockBehaviour_properties.setAccessible(true);
            }
            if (this.fieldBlockBehaviour_properties == null) {
                throw new IllegalStateException("Could not find block properties field!");
            }
            Class<BlockBehaviour.BlockStateBase> classBlockStateBase = BlockBehaviour.BlockStateBase.class;
            for (Field f3 : classBlockStateBase.getDeclaredFields()) {
                if (f3.getType() != MapColor.class) continue;
                this.fieldBlockStateBase_materialColor = f3;
                this.fieldBlockStateBase_materialColor.setAccessible(true);
            }
            if (this.fieldBlockStateBase_materialColor == null) {
                throw new IllegalStateException("Could not find BlockStateBase materialColor field!");
            }
            try {
                Constructor constructorMaterialColor = MapColor.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE);
                constructorMaterialColor.setAccessible(true);
                this.transparentColor = (MapColor)constructorMaterialColor.newInstance(0, 0);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Could not create custom transparent MaterialColor!");
            }
        }
        if (!m.isBlock()) {
            throw new IllegalArgumentException("Material must be a block");
        }
        Block b2 = CraftMagicNumbers.getBlock((Material)m);
        try {
            BlockBehaviour.Properties properties = (BlockBehaviour.Properties)this.fieldBlockBehaviour_properties.get(b2);
            properties.mapColor(this.transparentColor);
            for (BlockState state : b2.getStateDefinition().getPossibleStates()) {
                this.fieldBlockStateBase_materialColor.set(state, this.transparentColor);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not set the MaterialColor!");
        }
    }

    @Override
    public Object createTeamParametersPacketObject(BaseComponent displayName, BaseComponent prefix, BaseComponent suffix, Team.OptionStatus nameTagDisplay, Team.OptionStatus collisionRule, ChatColor color, boolean seeFriendlyInvisibles, boolean allowFriendlyFire) {
        Scoreboard scoreboard = new Scoreboard();
        PlayerTeam team = new PlayerTeam(scoreboard, BaseComponent.toPlainText((BaseComponent[])new BaseComponent[]{displayName}));
        team.setDisplayName(MiscUtilsImpl.baseComponentToComponent(displayName));
        team.setPlayerPrefix(MiscUtilsImpl.baseComponentToComponent(prefix));
        team.setPlayerSuffix(MiscUtilsImpl.baseComponentToComponent(suffix));
        team.setNameTagVisibility(Team.Visibility.values()[nameTagDisplay.ordinal()]);
        team.setCollisionRule(Team.CollisionRule.values()[collisionRule.ordinal()]);
        team.setColor(color == null ? ChatFormatting.RESET : CraftChatMessage.getColor((ChatColor)color));
        team.setSeeFriendlyInvisibles(seeFriendlyInvisibles);
        team.setAllowFriendlyFire(allowFriendlyFire);
        return new ClientboundSetPlayerTeamPacket.Parameters(team);
    }

    private static net.minecraft.network.chat.Component baseComponentToComponent(BaseComponent c2) {
        if (c2 == null) {
            return PaperAdventure.asVanilla((Component)Component.empty());
        }
        String json = ComponentSerializer.toString((BaseComponent)c2);
        return PaperAdventure.asVanilla((Component)GsonComponentSerializer.gson().deserialize((Object)json));
    }

    @Override
    public Class<? extends Object> getNumberFormatClass() {
        return NumberFormat.class;
    }

    @Override
    public Object getBlankNumberFormatInstance() {
        return BlankFormat.INSTANCE;
    }

    @Override
    public Player getCurrentContextPlayer() {
        UUID possiblePlayer;
        if (this.currentContextPlayer != null && (possiblePlayer = this.currentContextPlayer.get()) != null && StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(s -> s.anyMatch(f2 -> f2.getDeclaringClass() == ServerGamePacketListenerImpl.class)).booleanValue()) {
            return this.nmsUtils.getPlugin().getServer().getPlayer(possiblePlayer);
        }
        return null;
    }

    @Override
    public Object createNMSProfile(UUID uniqueId, String name, Collection<ProfileProperty> properties) {
        LinkedHashMultimap propertiesInternal = LinkedHashMultimap.create();
        for (ProfileProperty e : properties) {
            propertiesInternal.put((Object)e.getName(), (Object)new Property(e.getName(), e.getValue(), e.getSignature()));
        }
        return new GameProfile(uniqueId != null ? uniqueId : Util.NIL_UUID, name != null ? name : "", new PropertyMap((Multimap)propertiesInternal));
    }
}

