/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol;

import de.cubeside.itemcontrol.Main;
import de.cubeside.itemcontrol.checks.ComponentCheck;
import de.cubeside.itemcontrol.config.GroupConfig;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.CompoundTag;
import java.util.ArrayList;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;

public class ItemChecker {
    public static Boolean filterItem(CompoundTag stack, GroupConfig group) {
        CompoundTag components;
        Material m;
        boolean modified = false;
        NamespacedKey id = NamespacedKey.fromString((String)stack.getString("id", "air"));
        Material material = m = id == null ? null : (Material)Registry.MATERIAL.get(id);
        if (group.getForbiddenItems().contains(m)) {
            stack.clear();
            return null;
        }
        int count = stack.getInt("count", 1);
        if (count < 1 || count > 99) {
            stack.setInt("count", 1);
        }
        if ((components = stack.getCompound("components")) != null && !group.isAllowAllComponents()) {
            for (String keyString : new ArrayList<String>(components.getAllKeys())) {
                NamespacedKey key = NamespacedKey.fromString((String)keyString);
                if (key == null) {
                    components.remove(keyString);
                    modified = true;
                    continue;
                }
                ComponentCheck check = group.getComponentHandler(key);
                if (check != null) {
                    try {
                        modified |= check.enforce(group, m, components, keyString);
                    }
                    catch (Exception ex) {
                        Main.getInstance().getLogger().log(Level.SEVERE, "Could not execute check for " + String.valueOf(key), ex);
                        Main.getInstance().getLogger().log(Level.SEVERE, Main.getInstance().getTools().getNbtUtils().writeString(stack));
                        stack.remove("components");
                        modified = true;
                    }
                    continue;
                }
                components.remove(keyString);
                modified = true;
            }
            if (components.size() == 0) {
                stack.remove("components");
                modified = true;
            }
        }
        return modified;
    }
}

