/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.libs.nmsutils.paper1_21_5;

import com.mojang.datafixers.DSL;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import de.cubeside.itemcontrol.libs.nmsutils.NbtUtils;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.CompoundTag;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.ListTag;
import de.cubeside.itemcontrol.libs.nmsutils.paper1_21_5.CompoundTagImpl;
import de.cubeside.itemcontrol.libs.nmsutils.paper1_21_5.ListTagImpl;
import de.cubeside.itemcontrol.libs.nmsutils.paper1_21_5.NMSUtilsImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.level.block.entity.TileEntity;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R4.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class NbtUtilsImpl
implements NbtUtils {
    public NbtUtilsImpl(NMSUtilsImpl nmsUtils) {
    }

    @Override
    public CompoundTag createEmptyCompound() {
        return new CompoundTagImpl(new NBTTagCompound());
    }

    @Override
    public ListTag createEmptyList() {
        return new ListTagImpl(new NBTTagList());
    }

    @Override
    public CompoundTag parseBinary(byte[] in) {
        try {
            return new CompoundTagImpl(NBTCompressedStreamTools.a((DataInput)new DataInputStream(new ByteArrayInputStream(in))));
        }
        catch (IOException e) {
            throw new RuntimeException("invalid nbt");
        }
    }

    @Override
    public byte[] writeBinary(CompoundTag in) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            NBTCompressedStreamTools.a((NBTTagCompound)((CompoundTagImpl)in).handle, (DataOutput)new DataOutputStream(os));
        }
        catch (IOException e) {
            throw new RuntimeException("could not serialize nbt");
        }
        return os.toByteArray();
    }

    @Override
    public CompoundTag parseString(String in) {
        try {
            return new CompoundTagImpl(GameProfileSerializer.a((String)in));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse snbt string", e);
        }
    }

    @Override
    public String writeString(CompoundTag in) {
        return GameProfileSerializer.a((NBTTagCompound)((CompoundTagImpl)in).handle);
    }

    @Override
    public int getCurrentDataVersion() {
        return SharedConstants.b().d().c();
    }

    private CompoundTag updateNbt(DSL.TypeReference type, CompoundTag in, int oldVersion) {
        int currentVersion = this.getCurrentDataVersion();
        if (oldVersion >= currentVersion || in == null) {
            return in;
        }
        Dynamic dyn = new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)((CompoundTagImpl)in).handle);
        NBTBase out = (NBTBase)DataConverterRegistry.a().update(type, dyn, oldVersion, currentVersion).getValue();
        if (out instanceof NBTTagCompound) {
            NBTTagCompound compound = (NBTTagCompound)out;
            return new CompoundTagImpl(compound);
        }
        throw new RuntimeException("Expected CompoundTag as result of update, but got " + out.getClass().getName() + " !");
    }

    private String updateName(DSL.TypeReference type, String in, int oldVersion) {
        int currentVersion = this.getCurrentDataVersion();
        if (oldVersion >= currentVersion || in == null) {
            return in;
        }
        NBTBase out = (NBTBase)DataConverterRegistry.a().update(type, new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)NBTTagString.a((String)in)), oldVersion, currentVersion).getValue();
        if (out instanceof NBTTagString) {
            NBTTagString stringTag = (NBTTagString)out;
            return stringTag.k();
        }
        throw new RuntimeException("Expected StringTag as result of update, but got " + out.getClass().getName() + " !");
    }

    @Override
    public CompoundTag updateEntity(CompoundTag in, int oldVersion) {
        return this.updateNbt(DataConverterTypes.D, in, oldVersion);
    }

    @Override
    public CompoundTag updateItem(CompoundTag in, int oldVersion) {
        return this.updateNbt(DataConverterTypes.t, in, oldVersion);
    }

    @Override
    public CompoundTag updateBlockEntity(CompoundTag in, int oldVersion) {
        return this.updateNbt(DataConverterTypes.s, in, oldVersion);
    }

    @Override
    public String updateItemTypeName(String in, int oldVersion) {
        return this.updateName(DataConverterTypes.F, in, oldVersion);
    }

    @Override
    public String updateBlockTypeName(String in, int oldVersion) {
        return this.updateName(DataConverterTypes.E, in, oldVersion);
    }

    @Override
    public CompoundTag getItemStackNbt(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        NBTBase tag = CraftItemStack.asNMSCopy((ItemStack)stack).a((HolderLookup.a)CraftRegistry.getMinecraftRegistry());
        if (tag instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)tag;
            return new CompoundTagImpl(compoundTag);
        }
        return null;
    }

    @Override
    public ItemStack createItemStack(CompoundTag tag) {
        net.minecraft.world.item.ItemStack nmsStack = net.minecraft.world.item.ItemStack.a((HolderLookup.a)CraftRegistry.getMinecraftRegistry(), (NBTBase)((CompoundTagImpl)tag).handle).orElse(null);
        return nmsStack != null ? CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsStack) : null;
    }

    @Override
    public CompoundTag getBlockEntityNbt(Block block) {
        CraftBlock craftBlock = (CraftBlock)block;
        BlockPosition blockPosition = craftBlock.getPosition();
        TileEntity tileEntity = craftBlock.getHandle().c_(blockPosition);
        if (tileEntity == null) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag = tileEntity.b((HolderLookup.a)CraftRegistry.getMinecraftRegistry());
        return new CompoundTagImpl(tag);
    }

    @Override
    public void setBlockEntityNbt(Block block, CompoundTag tag) {
        CraftBlock craftBlock = (CraftBlock)block;
        BlockPosition blockPosition = craftBlock.getPosition();
        TileEntity tileEntity = craftBlock.getHandle().c_(blockPosition);
        if (tileEntity == null) {
            return;
        }
        tileEntity.c(((CompoundTagImpl)tag).handle, (HolderLookup.a)CraftRegistry.getMinecraftRegistry());
    }
}

