/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.checks;

import com.google.gson.Gson;
import de.cubeside.itemcontrol.checks.ComponentCheck;
import de.cubeside.itemcontrol.config.GroupConfig;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.CompoundTag;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.ListTag;
import de.cubeside.itemcontrol.util.ConfigUtil;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;

public class CheckProfile
implements ComponentCheck {
    private static final NamespacedKey KEY = NamespacedKey.fromString((String)"minecraft:profile");
    private boolean allow;

    @Override
    public NamespacedKey getComponentKey() {
        return KEY;
    }

    @Override
    public void loadConfig(ConfigurationSection section) {
        ConfigurationSection data = ConfigUtil.getOrCreateSection(section, KEY.asMinimalString());
        this.allow = ConfigUtil.getOrCreate(data, "allow", true);
    }

    @Override
    public boolean enforce(GroupConfig group, Material material, CompoundTag itemComponentsTag, String key) {
        boolean changed = false;
        CompoundTag compound = itemComponentsTag.getCompound(key);
        if (!this.allow) {
            itemComponentsTag.remove(key);
            changed = true;
        } else if (compound != null) {
            boolean nameOrId = false;
            String name = compound.getString("name");
            if (name != null && !CheckProfile.isValidPlayerName(name)) {
                compound.remove("name");
                changed = true;
            } else if (name != null) {
                nameOrId = true;
            }
            int[] id = compound.getIntArray("id");
            if (id != null && id.length != 4) {
                compound.remove("id");
                changed = true;
            } else if (id != null) {
                nameOrId = true;
            }
            ListTag properties = compound.getList("properties");
            if (!nameOrId) {
                itemComponentsTag.remove(key);
                changed = true;
            } else if (properties != null) {
                for (int i = properties.size() - 1; i >= 0; --i) {
                    CompoundTag property = properties.getCompound(i);
                    if (property == null || !"textures".equals(property.getString("name"))) {
                        properties.remove(i);
                        changed = true;
                        continue;
                    }
                    String value = property.getString("value");
                    if (value == null) {
                        properties.remove(i);
                        changed = true;
                        continue;
                    }
                    boolean valid = false;
                    try {
                        String skinUrl;
                        URL url;
                        Map skin;
                        Object v;
                        Map m;
                        Object v2;
                        String valueString = new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8);
                        LinkedHashMap obj = (LinkedHashMap)new Gson().fromJson(valueString, LinkedHashMap.class);
                        Object v3 = obj.get("textures");
                        if (v3 instanceof Map && (v2 = (m = (Map)v3).get("SKIN")) instanceof Map && (v = (skin = (Map)v2).get("url")) instanceof String && (url = new URI(skinUrl = (String)v).toURL()).toString().startsWith("http://textures.minecraft.net/texture/")) {
                            valid = true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (valid) continue;
                    properties.remove(i);
                    changed = true;
                }
                if (properties.isEmpty()) {
                    compound.remove("properties");
                    changed = true;
                }
            }
        }
        return changed;
    }

    private static boolean isValidPlayerName(String name) {
        return name.length() <= 16 && name.chars().filter(c -> c <= 32 || c >= 127).findAny().isEmpty();
    }
}

