/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.itemcontrol.checks;

import de.cubeside.itemcontrol.checks.ComponentCheck;
import de.cubeside.itemcontrol.config.GroupConfig;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.CompoundTag;
import de.cubeside.itemcontrol.libs.nmsutils.nbt.ListTag;
import de.cubeside.itemcontrol.util.ConfigUtil;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;

public class CheckFireworks
implements ComponentCheck {
    private static final NamespacedKey KEY = NamespacedKey.fromString((String)"minecraft:fireworks");
    private boolean allow;
    private int maxExposions;
    private int maxFlightTime;

    @Override
    public NamespacedKey getComponentKey() {
        return KEY;
    }

    @Override
    public void loadConfig(ConfigurationSection section) {
        ConfigurationSection data = ConfigUtil.getOrCreateSection(section, KEY.asMinimalString());
        this.allow = ConfigUtil.getOrCreate(data, "allow", true);
        this.maxExposions = ConfigUtil.getOrCreate(data, "max_exposions", 6);
        this.maxFlightTime = ConfigUtil.getOrCreate(data, "max_flight_time", 3);
    }

    @Override
    public boolean enforce(GroupConfig group, Material material, CompoundTag itemComponentsTag, String key) {
        boolean changed = false;
        CompoundTag fireworksCompound = itemComponentsTag.getCompound(key);
        if (this.allow && fireworksCompound != null) {
            byte flightDuration;
            ListTag explosions = fireworksCompound.getList("explosions");
            if (explosions != null) {
                changed |= this.filterExplosions(explosions);
            }
            if ((flightDuration = itemComponentsTag.getByte("flight_duration")) > this.maxFlightTime) {
                itemComponentsTag.remove("flight_duration");
                changed = true;
            }
        } else {
            itemComponentsTag.remove(key);
            changed = true;
        }
        return changed;
    }

    private boolean filterExplosions(ListTag list) {
        boolean changed = false;
        for (int i = list.size() - 1; i >= this.maxExposions; --i) {
            list.remove(i);
            changed = true;
        }
        return changed;
    }
}

