/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest.commands;

import de.iani.cubesideutils.StringUtil;
import de.iani.cubesideutils.bukkit.commands.SubCommand;
import de.iani.cubesideutils.bukkit.commands.exceptions.DisallowsCommandBlockException;
import de.iani.cubesideutils.bukkit.commands.exceptions.IllegalSyntaxException;
import de.iani.cubesideutils.bukkit.commands.exceptions.InternalCommandException;
import de.iani.cubesideutils.bukkit.commands.exceptions.NoPermissionException;
import de.iani.cubesideutils.bukkit.commands.exceptions.RequiresPlayerException;
import de.iani.cubesideutils.commands.ArgsParser;
import de.iani.treasurechest.TreasureChest;
import de.iani.treasurechest.TreasureChestItem;
import java.util.Collection;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AddItemCommand
extends SubCommand {
    private TreasureChest plugin;

    public AddItemCommand(TreasureChest plugin) {
        this.plugin = plugin;
    }

    public String getRequiredPermission() {
        return "treasurechest.create";
    }

    public boolean requiresPlayer() {
        return true;
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String commandString, ArgsParser args) throws DisallowsCommandBlockException, RequiresPlayerException, NoPermissionException, IllegalSyntaxException, InternalCommandException {
        if (args.remaining() != 0) {
            this.plugin.sendMessage(sender, commandString + this.getUsage(), true);
            return true;
        }
        Player player = (Player)sender;
        ItemStack inHand = player.getInventory().getItemInMainHand();
        if (inHand == null || inHand.getType() == Material.AIR || inHand.getAmount() == 0) {
            this.plugin.sendMessage(sender, "You have to hold the item in hand!", true);
            return true;
        }
        TreasureChestItem activeItem = this.plugin.getData().getActiveItem(player.getUniqueId());
        if (activeItem == null) {
            this.plugin.sendMessage(sender, "You have no active item!", true);
            return true;
        }
        activeItem.addPriceItem(inHand.clone());
        this.plugin.sendMessage(sender, "Item added: " + inHand.getAmount() + " " + StringUtil.capitalizeFirstLetter((String)inHand.getType().name(), (boolean)true));
        return true;
    }

    public Collection<String> onTabComplete(CommandSender sender, Command command, String alias, ArgsParser args) {
        return List.of();
    }
}

