/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest.commands;

import de.iani.cubesideutils.bukkit.commands.SubCommand;
import de.iani.cubesideutils.bukkit.commands.exceptions.DisallowsCommandBlockException;
import de.iani.cubesideutils.bukkit.commands.exceptions.IllegalSyntaxException;
import de.iani.cubesideutils.bukkit.commands.exceptions.InternalCommandException;
import de.iani.cubesideutils.bukkit.commands.exceptions.NoPermissionException;
import de.iani.cubesideutils.bukkit.commands.exceptions.RequiresPlayerException;
import de.iani.cubesideutils.commands.ArgsParser;
import de.iani.treasurechest.TreasureChest;
import java.util.Collection;
import java.util.List;
import org.bukkit.Effect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetChestCommand
extends SubCommand {
    private TreasureChest plugin;

    public SetChestCommand(TreasureChest plugin) {
        this.plugin = plugin;
    }

    public String getRequiredPermission() {
        return "treasurechest.setchest";
    }

    public boolean requiresPlayer() {
        return true;
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String commandString, ArgsParser args) throws DisallowsCommandBlockException, RequiresPlayerException, NoPermissionException, IllegalSyntaxException, InternalCommandException {
        if (args.remaining() != 0) {
            this.plugin.sendMessage(sender, commandString + this.getUsage(), true);
            return true;
        }
        Player player = (Player)sender;
        Block target = player.getTargetBlockExact(5, FluidCollisionMode.NEVER);
        this.plugin.setChestLocation(target == null ? null : target.getLocation());
        if (target != null) {
            player.playEffect(target.getLocation(), Effect.MOBSPAWNER_FLAMES, null);
            player.playEffect(target.getLocation(), Effect.MOBSPAWNER_FLAMES, null);
            player.playEffect(target.getLocation(), Effect.MOBSPAWNER_FLAMES, null);
            this.plugin.sendMessage(sender, "Treasurechest location set!");
        } else {
            this.plugin.sendMessage(sender, "Treasurechest location removed!");
        }
        return true;
    }

    public Collection<String> onTabComplete(CommandSender sender, Command command, String alias, ArgsParser args) {
        return List.of();
    }
}

