/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest.commands;

import de.iani.cubesideutils.bukkit.commands.SubCommand;
import de.iani.cubesideutils.bukkit.commands.exceptions.DisallowsCommandBlockException;
import de.iani.cubesideutils.bukkit.commands.exceptions.IllegalSyntaxException;
import de.iani.cubesideutils.bukkit.commands.exceptions.InternalCommandException;
import de.iani.cubesideutils.bukkit.commands.exceptions.NoPermissionException;
import de.iani.cubesideutils.bukkit.commands.exceptions.RequiresPlayerException;
import de.iani.cubesideutils.commands.ArgsParser;
import de.iani.playerUUIDCache.CachedPlayer;
import de.iani.treasurechest.ListedItemsData;
import de.iani.treasurechest.PlayerTreasureChestContent;
import de.iani.treasurechest.TreasureChest;
import de.iani.treasurechest.database.DatabaseTreasureChestItem;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;

public class ListCommand
extends SubCommand {
    private TreasureChest plugin;

    public ListCommand(TreasureChest plugin) {
        this.plugin = plugin;
    }

    public String getRequiredPermission() {
        return "treasurechest.list";
    }

    public boolean requiresPlayer() {
        return false;
    }

    public String getUsage() {
        return "<player>";
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String commandString, ArgsParser args) throws DisallowsCommandBlockException, RequiresPlayerException, NoPermissionException, IllegalSyntaxException, InternalCommandException {
        if (args.remaining() != 1) {
            this.plugin.sendMessage(sender, commandString + this.getUsage(), true);
            return true;
        }
        CachedPlayer target = this.plugin.getPlayerUUIDCache().getPlayerFromNameOrUUID(args.getNext(), true);
        if (target == null) {
            this.plugin.sendMessage(sender, "Unknown player!", true);
            return true;
        }
        PlayerTreasureChestContent content = this.plugin.getData().getOrCreateChestContent(target.getUniqueId());
        content.loadAsync(() -> {
            this.plugin.sendMessage(sender, (Component)Component.text((String)("Preise von " + target.getName() + " (" + target.getUniqueId().toString() + "):"), (TextColor)NamedTextColor.GRAY));
            List<DatabaseTreasureChestItem> items = content.getItems();
            if (items.isEmpty()) {
                this.plugin.sendMessage(sender, "keine Preise vorhanden");
            } else {
                ListedItemsData lid = new ListedItemsData(target.getUniqueId());
                int nr = 1;
                for (DatabaseTreasureChestItem i : items) {
                    ItemMeta meta = i.getDisplayItem().getItemMeta();
                    this.plugin.sendMessage(sender, Component.text((String)(nr + ": ")).append((Component)(meta.hasDisplayName() ? meta.displayName() : (meta.hasItemName() ? meta.itemName() : Component.translatable((String)i.getDisplayItem().getType().getItemTranslationKey())))));
                    lid.addItem(nr, i.getId());
                    ++nr;
                }
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    this.plugin.getData().setListedItems(player.getUniqueId(), lid);
                } else {
                    this.plugin.getData().setListedItems(null, lid);
                }
            }
        });
        return true;
    }

    public Collection<String> onTabComplete(CommandSender sender, Command command, String alias, ArgsParser args) {
        if (args.remaining() == 1) {
            return null;
        }
        return List.of();
    }
}

