/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest.commands;

import de.iani.cubesideutils.bukkit.commands.SubCommand;
import de.iani.cubesideutils.bukkit.commands.exceptions.DisallowsCommandBlockException;
import de.iani.cubesideutils.bukkit.commands.exceptions.IllegalSyntaxException;
import de.iani.cubesideutils.bukkit.commands.exceptions.InternalCommandException;
import de.iani.cubesideutils.bukkit.commands.exceptions.NoPermissionException;
import de.iani.cubesideutils.bukkit.commands.exceptions.RequiresPlayerException;
import de.iani.cubesideutils.bukkit.items.ItemStacks;
import de.iani.cubesideutils.bukkit.updater.DataUpdater;
import de.iani.cubesideutils.commands.ArgsParser;
import de.iani.treasurechest.TreasureChest;
import de.iani.treasurechest.database.DatabaseTreasureChestItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UpdateAllCommand
extends SubCommand {
    private TreasureChest plugin;

    public UpdateAllCommand(TreasureChest plugin) {
        this.plugin = plugin;
    }

    public String getRequiredPermission() {
        return "treasurechest.updateall";
    }

    public boolean requiresPlayer() {
        return false;
    }

    public String getUsage() {
        return "CONFIRM|FORCEALL";
    }

    public boolean onCommand(final CommandSender sender, Command command, String alias, String commandString, ArgsParser args) throws DisallowsCommandBlockException, RequiresPlayerException, NoPermissionException, IllegalSyntaxException, InternalCommandException {
        ArrayList<DatabaseTreasureChestItem> allHeads;
        if (args.remaining() != 1) {
            this.plugin.sendMessage(sender, commandString + this.getUsage(), true);
            return true;
        }
        String arg = args.getNext("");
        if (!arg.equals("CONFIRM") && !arg.equals("FORCEALL")) {
            this.plugin.sendMessage(sender, commandString + this.getUsage(), true);
            return true;
        }
        final boolean forceAll = arg.equals("FORCEALL");
        try {
            sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + "Lade Schatztruheninhalte!");
            allHeads = this.plugin.getDatabase().getAllItems();
            sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + "Laden abgeschlossen (" + allHeads.size() + ") - Beginne Update!");
        }
        catch (SQLException e) {
            sender.sendMessage("Exception while loading");
            this.plugin.getLogger().log(Level.SEVERE, "Exception while loading", e);
            return true;
        }
        new BukkitRunnable(){
            int total;
            int checked;
            int converted;
            {
                this.total = allHeads.size();
                this.checked = 0;
                this.converted = 0;
            }

            public void run() {
                for (int k = 0; k < 100; ++k) {
                    ItemStack[] priceItems;
                    if (this.checked >= this.total) {
                        sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + "Update: " + this.checked + "/" + this.total + " (" + this.converted + " updated)");
                        sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + "Update abgeschlossen!");
                        this.cancel();
                        return;
                    }
                    DatabaseTreasureChestItem i = (DatabaseTreasureChestItem)allHeads.get(this.checked);
                    ++this.checked;
                    boolean changed = false;
                    ItemStack oldStack = i.getDisplayItem();
                    ItemStack newStack = ItemStacks.prepareForSerialization((ItemStack)DataUpdater.updateItemStack((ItemStack)ItemStacks.restoreAfterDeserialization((ItemStack)oldStack)));
                    if (!Objects.equals(newStack, oldStack)) {
                        i.setDisplayItem(newStack);
                        changed = true;
                    }
                    if ((priceItems = i.getPriceItems()) != null) {
                        for (int j = 0; j < priceItems.length; ++j) {
                            oldStack = priceItems[j];
                            newStack = ItemStacks.prepareForSerialization((ItemStack)DataUpdater.updateItemStack((ItemStack)ItemStacks.restoreAfterDeserialization((ItemStack)oldStack)));
                            if (Objects.equals(newStack, oldStack)) continue;
                            priceItems[j] = newStack;
                            changed = true;
                        }
                    }
                    if (forceAll || changed) {
                        try {
                            UpdateAllCommand.this.plugin.getDatabase().updateItem(i);
                        }
                        catch (SQLException e) {
                            sender.sendMessage("Exception while updating: " + i.getId());
                            UpdateAllCommand.this.plugin.getLogger().log(Level.SEVERE, "Exception while updating: " + i.getId(), e);
                        }
                        ++this.converted;
                    }
                    if (this.checked % 100 != 0) continue;
                    sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + "Update: " + this.checked + "/" + this.total + " (" + this.converted + " updated)");
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
        return true;
    }

    public Collection<String> onTabComplete(CommandSender sender, Command command, String alias, ArgsParser args) {
        return List.of();
    }
}

