/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest.commands;

import de.iani.cubesideutils.bukkit.commands.SubCommand;
import de.iani.cubesideutils.commands.ArgsParser;
import de.iani.treasurechest.TreasureChest;
import de.iani.treasurechest.TreasureChestItem;
import java.util.Collection;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CreateCommand
extends SubCommand {
    private TreasureChest plugin;

    public CreateCommand(TreasureChest plugin) {
        this.plugin = plugin;
    }

    public String getRequiredPermission() {
        return "treasurechest.create";
    }

    public boolean requiresPlayer() {
        return true;
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String commandString, ArgsParser args) {
        if (args.remaining() != 0) {
            this.plugin.sendMessage(sender, commandString + this.getUsage(), true);
            return true;
        }
        Player player = (Player)sender;
        ItemStack inHand = player.getInventory().getItemInMainHand();
        if (inHand == null || inHand.getType() == Material.AIR || inHand.getAmount() == 0) {
            this.plugin.sendMessage(sender, "You have to hold the display item in hand!", true);
            return true;
        }
        TreasureChestItem newItem = new TreasureChestItem(inHand.clone(), null, 0);
        this.plugin.getData().setActiveItem(player.getUniqueId(), newItem);
        this.plugin.sendMessage(sender, "Created a new Treasurechest item!");
        return true;
    }

    public Collection<String> onTabComplete(CommandSender sender, Command command, String alias, ArgsParser args) {
        return List.of();
    }
}

