/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest;

import de.iani.treasurechest.OpenInventoryData;
import de.iani.treasurechest.PlayerTreasureChestContent;
import de.iani.treasurechest.TreasureChest;
import de.iani.treasurechest.TreasureChestItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class ChestInventoryListener
implements Listener {
    private TreasureChest plugin;
    HashMap<Player, OpenInventoryData> openInventories = new HashMap();

    public ChestInventoryListener(TreasureChest plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onChestOpen(PlayerInteractEvent e) {
        if (this.plugin.getChestLocation() == null) {
            return;
        }
        Block b = e.getClickedBlock();
        if (e.getAction() == Action.RIGHT_CLICK_BLOCK && b != null && b.getLocation().equals((Object)this.plugin.getChestLocation())) {
            e.setCancelled(true);
            if (!e.getPlayer().hasPermission("treasurechest.access")) {
                this.plugin.sendMessage((CommandSender)e.getPlayer(), "Du hast keinen Zugriff auf die Schatztruhe!");
                return;
            }
            if (this.openInventories.containsKey(e.getPlayer())) {
                return;
            }
            PlayerTreasureChestContent content = this.plugin.getData().getChestContent(e.getPlayer().getUniqueId());
            if (content == null || content.isEmpty()) {
                this.plugin.sendMessage((CommandSender)e.getPlayer(), "Deine Schatztruhe ist leer!");
                return;
            }
            Inventory inventory = this.plugin.getServer().createInventory(null, 54, "Schatztruhe");
            OpenInventoryData openInventory = new OpenInventoryData(b.getLocation(), inventory);
            int pos = 0;
            for (TreasureChestItem item : content.getItems()) {
                if (pos < 54) {
                    ItemStack di = item.getDisplayItem().clone();
                    ItemMeta meta = di.getItemMeta();
                    ItemStack[] priceList = item.getPriceItems();
                    ArrayList<String> lore = new ArrayList<String>();
                    if (priceList != null) {
                        for (ItemStack stack : priceList) {
                            Damageable damageable;
                            StringBuilder t = new StringBuilder();
                            if (stack.getAmount() > 1) {
                                t.append(stack.getAmount()).append(" ");
                            }
                            t.append(TreasureChest.capitalize(stack.getType().name(), true));
                            ItemMeta stackMeta = stack.getItemMeta();
                            if (stackMeta instanceof Damageable && (damageable = (Damageable)stackMeta).hasDamage()) {
                                t.append(':').append(damageable.getDamage());
                            }
                            if (stackMeta.hasDisplayName()) {
                                t.append(" (benanntes Item)");
                            }
                            lore.add(t.toString());
                        }
                    }
                    if (item.getPriceMoney() > 0) {
                        lore.add(this.plugin.formatMoney(item.getPriceMoney()));
                    }
                    meta.setLore(lore);
                    di.setItemMeta(meta);
                    inventory.setItem(pos, di);
                    openInventory.setItemAtPosition(pos, pos);
                }
                ++pos;
            }
            e.getPlayer().openInventory(inventory);
            this.openInventories.put(e.getPlayer(), openInventory);
            e.getPlayer().playSound(b.getLocation(), Sound.BLOCK_CHEST_OPEN, 0.5f, 0.9f);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryClick(InventoryClickEvent event) {
        Player player;
        OpenInventoryData openInventory = this.openInventories.get(event.getWhoClicked());
        if (openInventory == null) {
            return;
        }
        InventoryAction action = event.getAction();
        switch (action) {
            case PICKUP_ALL: 
            case PICKUP_HALF: 
            case PICKUP_SOME: 
            case PICKUP_ONE: {
                int i;
                ItemStack[] temp;
                int priceCount;
                event.setCancelled(true);
                if (event.getRawSlot() >= event.getView().getTopInventory().getSize() || !(event.getWhoClicked() instanceof Player)) break;
                player = (Player)event.getWhoClicked();
                ItemStack[] playerInv = player.getInventory().getContents();
                playerInv = Arrays.copyOf(playerInv, 36);
                Inventory clonedPlayerInventory = Bukkit.createInventory(null, (int)36);
                clonedPlayerInventory.setContents(playerInv);
                PlayerTreasureChestContent content = this.plugin.getData().getChestContent(player.getUniqueId());
                int entryId = openInventory.getEntryAtPosition(event.getRawSlot());
                TreasureChestItem selectedItem = content.getItem(entryId);
                if (selectedItem == null) break;
                ItemStack[] priceList = selectedItem.getPriceItems();
                int n = priceCount = priceList == null ? 0 : priceList.length;
                if (priceCount > 0) {
                    temp = new ItemStack[priceCount];
                    for (i = 0; i < priceCount; ++i) {
                        temp[i] = priceList[i].clone();
                    }
                    if (!clonedPlayerInventory.addItem(temp).isEmpty()) {
                        this.plugin.sendMessage((CommandSender)player, "Du hast nicht gen\u00fcgend Platz in deinem Inventar!", true);
                        player.updateInventory();
                        return;
                    }
                }
                this.plugin.sendMessage((CommandSender)player, ChatColor.GRAY + "Du hast folgende Items erhalten:");
                if (priceCount > 0) {
                    temp = new ItemStack[priceCount];
                    for (i = 0; i < priceCount; ++i) {
                        temp[i] = priceList[i].clone();
                    }
                    player.getInventory().addItem(temp);
                    for (ItemStack stack : priceList) {
                        Damageable damageable;
                        StringBuilder t = new StringBuilder("  ");
                        if (stack.getAmount() > 1) {
                            t.append(stack.getAmount()).append(" ");
                        }
                        t.append(TreasureChest.capitalize(stack.getType().name(), true));
                        ItemMeta stackMeta = stack.getItemMeta();
                        if (stackMeta instanceof Damageable && (damageable = (Damageable)stackMeta).hasDamage()) {
                            t.append(':').append(damageable.getDamage());
                        }
                        if (stackMeta.hasDisplayName()) {
                            t.append(" (").append(stackMeta.getDisplayName()).append(ChatColor.YELLOW).append(")");
                        }
                        this.plugin.sendMessage((CommandSender)player, t.toString());
                    }
                }
                if (selectedItem.getPriceMoney() > 0) {
                    this.plugin.giveMoney(player, selectedItem.getPriceMoney());
                    this.plugin.sendMessage((CommandSender)player, "  " + this.plugin.formatMoney(selectedItem.getPriceMoney()));
                }
                player.playSound(event.getWhoClicked().getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
                content.removeItem(entryId);
                openInventory.getInventory().setItem(event.getRawSlot(), null);
                openInventory.removeEntryAtPositionAndShift(event.getRawSlot());
                player.updateInventory();
            }
        }
        player = (Player)event.getWhoClicked();
        player.updateInventory();
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryDrag(InventoryDragEvent event) {
        if (this.openInventories.containsKey(event.getWhoClicked())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        OpenInventoryData data = this.openInventories.remove(e.getPlayer());
        if (data != null) {
            ((Player)e.getPlayer()).playSound(data.getLocation(), Sound.BLOCK_CHEST_CLOSE, 0.5f, 0.9f);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.openInventories.remove(event.getPlayer());
    }
}

