/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest;

import de.iani.playerUUIDCache.CachedPlayer;
import de.iani.treasurechest.PlayerTreasureChestContent;
import de.iani.treasurechest.TreasureChest;
import de.iani.treasurechest.TreasureChestItem;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PriceChestCommandExecutor
implements CommandExecutor {
    private TreasureChest plugin;

    public PriceChestCommandExecutor(TreasureChest plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.displayHelp(sender, label);
        } else {
            String subcommand = args[0].toLowerCase();
            if (subcommand.equals("setchest")) {
                if (!this.checkPlayer(sender) || !this.checkPermission(sender, "pricechest.setchest")) {
                    return true;
                }
                Player player = (Player)sender;
                Block target = player.getTargetBlock((Set)null, 5);
                this.plugin.setChestLocation(target.getLocation());
                player.playEffect(target.getLocation(), Effect.MOBSPAWNER_FLAMES, null);
                player.playEffect(target.getLocation(), Effect.MOBSPAWNER_FLAMES, null);
                player.playEffect(target.getLocation(), Effect.MOBSPAWNER_FLAMES, null);
                this.plugin.sendMessage(sender, "Treasurechest location set!");
            } else if (subcommand.equals("create")) {
                if (!this.checkPlayer(sender) || !this.checkPermission(sender, "pricechest.create")) {
                    return true;
                }
                Player player = (Player)sender;
                ItemStack inHand = player.getInventory().getItemInMainHand();
                if (inHand == null || inHand.getType() == Material.AIR || inHand.getAmount() == 0) {
                    this.plugin.sendMessage(sender, "You have to hold the display item in hand!", true);
                    return true;
                }
                TreasureChestItem newItem = new TreasureChestItem(inHand.clone(), null, 0);
                this.plugin.getData().setActiveItem(player.getUniqueId(), newItem);
                this.plugin.sendMessage(sender, "Created a new Treasurechest item!");
            } else if (subcommand.equals("addmoney")) {
                if (!this.checkPlayer(sender) || !this.checkPermission(sender, "pricechest.create")) {
                    return true;
                }
                if (args.length < 2) {
                    this.plugin.sendMessage(sender, "/" + label + " addmoney <amount>", true);
                    return true;
                }
                int amount = this.getIntArgument(args[1], 0);
                Player player = (Player)sender;
                TreasureChestItem activeItem = this.plugin.getData().getActiveItem(player.getUniqueId());
                if (activeItem == null) {
                    this.plugin.sendMessage(sender, "You have no active item!", true);
                    return true;
                }
                activeItem.setPriceMoney(activeItem.getPriceMoney() + amount);
                this.plugin.sendMessage(sender, "Set the money to " + activeItem.getPriceMoney());
            } else if (subcommand.equals("additem")) {
                if (!this.checkPlayer(sender) || !this.checkPermission(sender, "pricechest.create")) {
                    return true;
                }
                Player player = (Player)sender;
                ItemStack inHand = player.getInventory().getItemInMainHand();
                if (inHand == null || inHand.getType() == Material.AIR || inHand.getAmount() == 0) {
                    this.plugin.sendMessage(sender, "You have to hold the item in hand!", true);
                    return true;
                }
                TreasureChestItem activeItem = this.plugin.getData().getActiveItem(player.getUniqueId());
                if (activeItem == null) {
                    this.plugin.sendMessage(sender, "You have no active item!", true);
                    return true;
                }
                activeItem.addPriceItem(inHand.clone());
                this.plugin.sendMessage(sender, "Item added: " + inHand.getAmount() + " " + TreasureChest.capitalize(inHand.getType().name(), true));
            } else {
                if (subcommand.equals("give")) {
                    if (!this.checkPlayer(sender) || !this.checkPermission(sender, "pricechest.give")) {
                        return true;
                    }
                    if (args.length < 2) {
                        this.plugin.sendMessage(sender, "/" + label + " give <player>", true);
                        return true;
                    }
                    Player player = (Player)sender;
                    TreasureChestItem activeItem = this.plugin.getData().getActiveItem(player.getUniqueId());
                    if (activeItem == null) {
                        this.plugin.sendMessage(sender, "You have no active item!", true);
                        return true;
                    }
                    for (int arg = 1; arg < args.length; ++arg) {
                        UUID targetuuid;
                        String nameOrId;
                        block45: {
                            nameOrId = args[arg].replace(",", "").trim();
                            targetuuid = null;
                            try {
                                targetuuid = UUID.fromString(nameOrId);
                            }
                            catch (Exception e) {
                                CachedPlayer target = this.plugin.getPlayerUUIDCache().getPlayerFromNameOrUUID(nameOrId, true);
                                if (target == null) break block45;
                                targetuuid = target.getUUID();
                                nameOrId = target.getName();
                            }
                        }
                        if (targetuuid == null) {
                            this.plugin.sendMessage(sender, "Unknown player!", true);
                            continue;
                        }
                        PlayerTreasureChestContent content = this.plugin.getData().getChestContent(targetuuid);
                        content.addItem(activeItem);
                        this.plugin.sendMessage(sender, "Item given to: " + nameOrId + " (" + targetuuid.toString() + ")");
                    }
                    return true;
                }
                if (subcommand.equals("list")) {
                    UUID targetuuid;
                    String nameOrId;
                    block46: {
                        if (!this.checkPermission(sender, "pricechest.list")) {
                            return true;
                        }
                        if (args.length < 2) {
                            this.plugin.sendMessage(sender, "/" + label + " list <player>", true);
                            return true;
                        }
                        nameOrId = args[1];
                        targetuuid = null;
                        try {
                            targetuuid = UUID.fromString(nameOrId);
                        }
                        catch (Exception e) {
                            CachedPlayer target = this.plugin.getPlayerUUIDCache().getPlayerFromNameOrUUID(nameOrId, true);
                            if (target == null) break block46;
                            targetuuid = target.getUUID();
                            nameOrId = target.getName();
                        }
                    }
                    if (targetuuid == null) {
                        this.plugin.sendMessage(sender, "Unknown player!", true);
                        return true;
                    }
                    PlayerTreasureChestContent content = this.plugin.getData().getChestContent(targetuuid);
                    this.plugin.sendMessage(sender, ChatColor.GRAY + "Preise von " + nameOrId + " (" + targetuuid.toString() + "):");
                    List<TreasureChestItem> items = content.getItems();
                    if (items.isEmpty()) {
                        this.plugin.sendMessage(sender, "keine Preise vorhanden");
                    } else {
                        int nr = 1;
                        for (TreasureChestItem i : items) {
                            this.plugin.sendMessage(sender, nr + ": " + i.getDisplayItem().getItemMeta().getDisplayName());
                            ++nr;
                        }
                    }
                } else if (subcommand.equals("remove")) {
                    UUID targetuuid;
                    block47: {
                        if (!this.checkPermission(sender, "pricechest.remove")) {
                            return true;
                        }
                        if (args.length < 3) {
                            this.plugin.sendMessage(sender, "/" + label + " remove <player> <nr>", true);
                            return true;
                        }
                        String nameOrId = args[1];
                        targetuuid = null;
                        try {
                            targetuuid = UUID.fromString(nameOrId);
                        }
                        catch (Exception e) {
                            CachedPlayer target = this.plugin.getPlayerUUIDCache().getPlayerFromNameOrUUID(nameOrId, true);
                            if (target == null) break block47;
                            targetuuid = target.getUUID();
                            nameOrId = target.getName();
                        }
                    }
                    if (targetuuid == null) {
                        this.plugin.sendMessage(sender, "Unknown player!", true);
                        return true;
                    }
                    int nr = this.getIntArgument(args[2], -1);
                    PlayerTreasureChestContent content = this.plugin.getData().getChestContent(targetuuid);
                    if (!content.removeItem(nr - 1)) {
                        this.plugin.sendMessage(sender, "Ung\u00fcltige ID", true);
                        return true;
                    }
                    this.plugin.sendMessage(sender, "Der Preis wurde entfernt!");
                } else {
                    this.plugin.sendMessage(sender, "Unknown subcommand!", true);
                    return true;
                }
            }
        }
        return true;
    }

    private void displayHelp(CommandSender sender, String label) {
        this.plugin.sendMessage(sender, ChatColor.GREEN + "Commands");
        if (this.checkPlayer(sender, true) && this.checkPermission(sender, "pricechest.setchest", true)) {
            this.plugin.sendMessage(sender, "/" + label + " setchest");
            this.plugin.sendMessage(sender, ChatColor.GREEN + "  Set the treasure chest location to the location you are looking at.");
        }
        if (this.checkPlayer(sender, true) && this.checkPermission(sender, "pricechest.create", true)) {
            this.plugin.sendMessage(sender, "/" + label + " create");
            this.plugin.sendMessage(sender, ChatColor.GREEN + "  Creates a price with the item in hand as display item.");
            this.plugin.sendMessage(sender, "/" + label + " additem");
            this.plugin.sendMessage(sender, ChatColor.GREEN + "  Adds the item in hand to the price.");
            this.plugin.sendMessage(sender, "/" + label + " addmoney <amount>");
            this.plugin.sendMessage(sender, ChatColor.GREEN + "  Adds money to a price.");
        }
        if (this.checkPlayer(sender, true) && this.checkPermission(sender, "pricechest.give", true)) {
            this.plugin.sendMessage(sender, "/" + label + " give <player>");
            this.plugin.sendMessage(sender, ChatColor.GREEN + "  Gives a price to a player.");
        }
        if (this.checkPermission(sender, "pricechest.list")) {
            this.plugin.sendMessage(sender, "/" + label + " list <player>");
            this.plugin.sendMessage(sender, ChatColor.GREEN + "  Gives price for a player.");
        }
        if (this.checkPermission(sender, "pricechest.remove")) {
            this.plugin.sendMessage(sender, "/" + label + " remove <player> <id>");
            this.plugin.sendMessage(sender, ChatColor.GREEN + "  Removes a price from a players chest.");
        }
    }

    private int getIntArgument(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    private boolean checkPermission(CommandSender sender, String perm) {
        return this.checkPermission(sender, perm, false);
    }

    private boolean checkPermission(CommandSender sender, String perm, boolean silent) {
        boolean hasPermission = sender.hasPermission(perm);
        if (!silent && !hasPermission) {
            this.plugin.sendMessage(sender, "No permission!", true);
        }
        return hasPermission;
    }

    private boolean checkPlayer(CommandSender sender) {
        return this.checkPlayer(sender, false);
    }

    private boolean checkPlayer(CommandSender sender, boolean silent) {
        boolean isPlayer = sender instanceof Player;
        if (!isPlayer && !silent) {
            this.plugin.sendMessage(sender, "You must be a player!", true);
        }
        return isPlayer;
    }
}

