/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest;

import de.iani.treasurechest.TreasureChest;
import de.iani.treasurechest.TreasureChestItem;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PlayerTreasureChestContent {
    private TreasureChest plugin;
    private File file;
    private ArrayList<TreasureChestItem> items;
    private long online;

    public PlayerTreasureChestContent(TreasureChest plugin, File file) {
        this.plugin = plugin;
        this.file = file;
        try {
            YamlConfiguration conf;
            ConfigurationSection prices;
            if (file.exists() && (prices = (conf = YamlConfiguration.loadConfiguration((File)file)).getConfigurationSection("prices")) != null) {
                for (String e : prices.getKeys(false)) {
                    ConfigurationSection price = prices.getConfigurationSection(e);
                    if (price == null) continue;
                    ItemStack display = price.getItemStack("displayItem");
                    if (display == null) {
                        display = new ItemStack(Material.BEDROCK);
                        ItemMeta meta = display.getItemMeta();
                        meta.setDisplayName("Unset displayitem");
                        display.setItemMeta(meta);
                    }
                    int priceMoney = price.getInt("priceMoney");
                    ArrayList<ItemStack> priceItems = new ArrayList<ItemStack>();
                    ConfigurationSection itemPricesSection = price.getConfigurationSection("itemPrices");
                    if (itemPricesSection != null) {
                        for (String pricee : itemPricesSection.getKeys(false)) {
                            ItemStack priceItem = itemPricesSection.getItemStack(pricee);
                            if (priceItem == null) continue;
                            priceItems.add(priceItem);
                        }
                    }
                    if (this.items == null) {
                        this.items = new ArrayList();
                    }
                    this.items.add(new TreasureChestItem(display, priceItems.toArray(new ItemStack[priceItems.size()]), priceMoney));
                }
            }
        }
        catch (Exception e) {
            plugin.getLogger().log(Level.SEVERE, "Could not load user chest file: " + file.getName(), e);
        }
    }

    private void save() {
        this.file.getParentFile().mkdirs();
        YamlConfiguration conf = new YamlConfiguration();
        ConfigurationSection prices = conf.createSection("prices");
        if (this.items != null) {
            int nr = 0;
            for (TreasureChestItem i : this.items) {
                ConfigurationSection price = prices.createSection(Integer.toString(nr++));
                price.set("displayItem", (Object)i.getDisplayItem().clone());
                price.set("priceMoney", (Object)i.getPriceMoney());
                ConfigurationSection itemsSec = price.createSection("itemPrices");
                if (i.getPriceItems() == null) continue;
                int nr2 = 0;
                for (ItemStack st : i.getPriceItems()) {
                    itemsSec.set(Integer.toString(nr2++), (Object)st.clone());
                }
            }
        }
        try {
            conf.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save user chest file: " + this.file.getName(), e);
        }
    }

    public void addItem(TreasureChestItem item) {
        item = item.clone();
        if (this.items == null) {
            this.items = new ArrayList();
        }
        this.items.add(item);
        this.save();
    }

    public boolean removeItem(int pos) {
        if (this.items == null || this.items.size() <= pos || pos < 0) {
            return false;
        }
        this.items.remove(pos);
        if (this.items.size() == 0) {
            this.items = null;
        }
        this.save();
        return true;
    }

    public boolean isEmpty() {
        return this.items == null || this.items.isEmpty();
    }

    public List<TreasureChestItem> getItems() {
        return this.items == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.items);
    }

    public TreasureChestItem getItem(int pos) {
        if (this.items == null || this.items.size() <= pos || pos < 0) {
            return null;
        }
        return this.items.get(pos);
    }

    public void setOnline(long t) {
        this.online = t;
    }

    public boolean isOnline(long t) {
        return this.online == t;
    }
}

