/*
 * Decompiled with CFR 0.152.
 */
package de.iani.playerUUIDCache;

import com.google.common.base.Preconditions;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class NameHistory {
    private final UUID uuid;
    private final String firstName;
    private final List<NameChange> changes;
    private long cacheLoadTime;

    public NameHistory(UUID uuid, String firstName, List<NameChange> changes, long cacheLoadTime) {
        Preconditions.checkNotNull((Object)uuid);
        Preconditions.checkNotNull((Object)firstName);
        Preconditions.checkNotNull(changes);
        this.uuid = uuid;
        this.firstName = firstName;
        changes = new ArrayList<NameChange>(changes);
        changes.sort(null);
        this.changes = Collections.unmodifiableList(changes);
        this.cacheLoadTime = cacheLoadTime;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public List<NameChange> getNameChanges() {
        return this.changes;
    }

    public String getName(long date) {
        NameChange change = this.getLastChange(date);
        if (change == null) {
            return this.firstName;
        }
        return change.getNewName();
    }

    public String getName(Date date) {
        return this.getName(date.getTime());
    }

    private NameChange getLastChange(long date) {
        if (this.changes.isEmpty() || this.changes.get(0).getDate() > date) {
            return null;
        }
        int upper = this.changes.size();
        int lower = 0;
        while (upper - lower > 1) {
            int index = (upper - lower) / 2 + lower;
            if (this.changes.get(index).getDate() <= date) {
                lower = index;
                continue;
            }
            upper = index;
        }
        return this.changes.get(lower);
    }

    long getCacheLoadTime() {
        return this.cacheLoadTime;
    }

    public static class NameChange
    implements Comparable<NameChange> {
        private String newName;
        private long date;

        public NameChange(String newName, long date) {
            Preconditions.checkNotNull((Object)newName);
            this.newName = newName;
            this.date = date;
        }

        public String getNewName() {
            return this.newName;
        }

        public long getDate() {
            return this.date;
        }

        public int hashCode() {
            int result = this.newName.hashCode();
            return result += 31 * Long.hashCode(this.date);
        }

        public boolean equals(Object other) {
            if (!(other instanceof NameChange)) {
                return false;
            }
            NameChange onc = (NameChange)other;
            return this.newName.equals(onc.newName) && this.date == onc.date;
        }

        @Override
        public int compareTo(NameChange other) {
            if (other == null) {
                throw new NullPointerException();
            }
            return Long.compare(this.date, other.date);
        }
    }
}

