/*
 * Decompiled with CFR 0.152.
 */
package de.iani.playerUUIDCache;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.bukkit.BanEntry;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public final class CachedPlayer
implements OfflinePlayer {
    private final UUID uuid;
    private final String name;
    private final long lastSeen;
    private final long cacheLoadTime;

    public CachedPlayer(UUID uuid, String name, long lastSeen, long cacheLoadTime) {
        Preconditions.checkNotNull((Object)uuid);
        Preconditions.checkNotNull((Object)name);
        this.uuid = uuid;
        this.name = name;
        this.lastSeen = lastSeen;
        this.cacheLoadTime = cacheLoadTime;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public long getLastLogin() {
        return this.lastSeen;
    }

    long getCacheLoadTime() {
        return this.cacheLoadTime;
    }

    public int hashCode() {
        return this.name.hashCode() + this.uuid.hashCode() + (int)this.lastSeen;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != CachedPlayer.class) {
            return false;
        }
        CachedPlayer other = (CachedPlayer)obj;
        return this.name.equalsIgnoreCase(other.name) && this.uuid.equals(other.uuid) && this.lastSeen == other.lastSeen;
    }

    public boolean isOp() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).isOp();
    }

    public void setOp(boolean value) {
        Bukkit.getOfflinePlayer((UUID)this.uuid).setOp(value);
    }

    public Map<String, Object> serialize() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).serialize();
    }

    public boolean isOnline() {
        return Bukkit.getPlayer((UUID)this.uuid) != null;
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public boolean isBanned() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).isBanned();
    }

    public boolean isWhitelisted() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).isWhitelisted();
    }

    public void setWhitelisted(boolean value) {
        Bukkit.getOfflinePlayer((UUID)this.uuid).setWhitelisted(value);
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    public long getFirstPlayed() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).getFirstPlayed();
    }

    @Deprecated
    public long getLastPlayed() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).getLastPlayed();
    }

    public boolean hasPlayedBefore() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).hasPlayedBefore();
    }

    @Deprecated
    public Location getBedSpawnLocation() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).getBedSpawnLocation();
    }

    public void incrementStatistic(Statistic statistic) throws IllegalArgumentException {
        Bukkit.getOfflinePlayer((UUID)this.uuid).incrementStatistic(statistic);
    }

    public void decrementStatistic(Statistic statistic) throws IllegalArgumentException {
        Bukkit.getOfflinePlayer((UUID)this.uuid).decrementStatistic(statistic);
    }

    public void incrementStatistic(Statistic statistic, int amount) throws IllegalArgumentException {
        Bukkit.getOfflinePlayer((UUID)this.uuid).incrementStatistic(statistic, amount);
    }

    public void decrementStatistic(Statistic statistic, int amount) throws IllegalArgumentException {
        Bukkit.getOfflinePlayer((UUID)this.uuid).decrementStatistic(statistic, amount);
    }

    public void setStatistic(Statistic statistic, int newValue) throws IllegalArgumentException {
        Bukkit.getOfflinePlayer((UUID)this.uuid).setStatistic(statistic, newValue);
    }

    public int getStatistic(Statistic statistic) throws IllegalArgumentException {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).getStatistic(statistic);
    }

    public void incrementStatistic(Statistic statistic, Material material) throws IllegalArgumentException {
        Bukkit.getOfflinePlayer((UUID)this.uuid).incrementStatistic(statistic, material);
    }

    public void decrementStatistic(Statistic statistic, Material material) throws IllegalArgumentException {
        Bukkit.getOfflinePlayer((UUID)this.uuid).decrementStatistic(statistic, material);
    }

    public int getStatistic(Statistic statistic, Material material) throws IllegalArgumentException {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).getStatistic(statistic, material);
    }

    public void incrementStatistic(Statistic statistic, Material material, int amount) throws IllegalArgumentException {
        Bukkit.getOfflinePlayer((UUID)this.uuid).incrementStatistic(statistic, material, amount);
    }

    public void decrementStatistic(Statistic statistic, Material material, int amount) throws IllegalArgumentException {
        Bukkit.getOfflinePlayer((UUID)this.uuid).decrementStatistic(statistic, material, amount);
    }

    public void setStatistic(Statistic statistic, Material material, int newValue) throws IllegalArgumentException {
        Bukkit.getOfflinePlayer((UUID)this.uuid).setStatistic(statistic, material, newValue);
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType) throws IllegalArgumentException {
        Bukkit.getOfflinePlayer((UUID)this.uuid).incrementStatistic(statistic, entityType);
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType) throws IllegalArgumentException {
        Bukkit.getOfflinePlayer((UUID)this.uuid).decrementStatistic(statistic, entityType);
    }

    public int getStatistic(Statistic statistic, EntityType entityType) throws IllegalArgumentException {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).getStatistic(statistic, entityType);
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType, int amount) throws IllegalArgumentException {
        Bukkit.getOfflinePlayer((UUID)this.uuid).incrementStatistic(statistic, entityType, amount);
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        Bukkit.getOfflinePlayer((UUID)this.uuid).decrementStatistic(statistic, entityType, amount);
    }

    public void setStatistic(Statistic statistic, EntityType entityType, int newValue) {
        Bukkit.getOfflinePlayer((UUID)this.uuid).setStatistic(statistic, entityType, newValue);
    }

    public boolean isConnected() {
        return false;
    }

    public PlayerProfile getPlayerProfile() {
        return Bukkit.createProfile((UUID)this.uuid, (String)this.name);
    }

    public <E extends BanEntry<? super PlayerProfile>> E ban(String reason, Date expires, String source) {
        return null;
    }

    public <E extends BanEntry<? super PlayerProfile>> E ban(String reason, Instant expires, String source) {
        return null;
    }

    public <E extends BanEntry<? super PlayerProfile>> E ban(String reason, Duration duration, String source) {
        return null;
    }

    public Location getRespawnLocation() {
        return null;
    }

    public Location getLastDeathLocation() {
        return null;
    }

    public Location getLocation() {
        return null;
    }
}

