/*
 * Decompiled with CFR 0.152.
 */
package de.iani.playerUUIDCache;

import de.iani.playerUUIDCache.BinaryStorage;
import de.iani.playerUUIDCache.CachedPlayer;
import de.iani.playerUUIDCache.CachedPlayerProfile;
import de.iani.playerUUIDCache.Callback;
import de.iani.playerUUIDCache.NameHistory;
import de.iani.playerUUIDCache.PaperProfileAPIListener;
import de.iani.playerUUIDCache.PaperProfilePropertiesAPIListener;
import de.iani.playerUUIDCache.PlayerUUIDCacheAPI;
import de.iani.playerUUIDCache.PluginConfig;
import de.iani.playerUUIDCache.UUIDDatabase;
import de.iani.playerUUIDCache.util.fetcher.NameFetcher;
import de.iani.playerUUIDCache.util.fetcher.ProfileFetcher;
import de.iani.playerUUIDCache.util.fetcher.UUIDFetcher;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerUUIDCache
extends JavaPlugin
implements PlayerUUIDCacheAPI {
    public static final long PROFILE_PROPERTIES_CACHE_EXPIRATION_TIME = 86400000L;
    public static final long PROFILE_PROPERTIES_LOCAL_CACHE_EXPIRATION_TIME = 1800000L;
    protected PluginConfig config;
    protected HashMap<String, CachedPlayer> playersByName;
    protected HashMap<UUID, CachedPlayer> playersByUUID;
    protected HashMap<UUID, CachedPlayerProfile> playerProfiles;
    protected HashMap<UUID, NameHistory> nameHistories;
    protected UUIDDatabase database;
    private BinaryStorage binaryStorage;
    private volatile int uuid2nameLookups;
    private volatile int name2uuidLookups;
    private volatile int nameHistoryLookups;
    private volatile int mojangQueries;
    private volatile int databaseUpdates;
    private volatile int databaseQueries;
    private volatile int profilePropertiesLookups;
    private volatile int profilePropertiesLookupQueries;
    private boolean hasProfileAPI;

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerLoginListener(), (Plugin)this);
        try {
            Class.forName("com.destroystokyo.paper.profile.PlayerProfile");
            this.getLogger().info("Paper Profile API detected, registering listener");
            this.getServer().getPluginManager().registerEvents((Listener)new PaperProfileAPIListener(this), (Plugin)this);
            if (this.config.useSQL()) {
                this.getLogger().info("Using profile properties cache");
                try {
                    this.database.createProfilePropertiesTable();
                    this.playerProfiles = new HashMap();
                    this.getServer().getPluginManager().registerEvents((Listener)new PaperProfilePropertiesAPIListener(this), (Plugin)this);
                    new BukkitRunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            PlayerUUIDCache playerUUIDCache = PlayerUUIDCache.this;
                            synchronized (playerUUIDCache) {
                                if (PlayerUUIDCache.this.playerProfiles != null) {
                                    Iterator<CachedPlayerProfile> it = PlayerUUIDCache.this.playerProfiles.values().iterator();
                                    while (it.hasNext()) {
                                        CachedPlayerProfile entry = it.next();
                                        if (entry.getLastSeen() + 86400000L > System.currentTimeMillis()) continue;
                                        it.remove();
                                    }
                                }
                            }
                            try {
                                PlayerUUIDCache.this.database.deleteOldPlayerProfiles();
                            }
                            catch (SQLException e) {
                                PlayerUUIDCache.this.getLogger().log(Level.SEVERE, "Error while trying to access the database", e);
                            }
                        }
                    }.runTaskTimerAsynchronously((Plugin)this, (long)(Math.random() * 20.0 * 60.0 * 60.0 * 24.0), 1728000L);
                }
                catch (SQLException e) {
                    this.getLogger().log(Level.SEVERE, "Could not create profiles table", e);
                }
            }
            this.hasProfileAPI = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.getServer().getServicesManager().register(PlayerUUIDCacheAPI.class, (Object)this, (Plugin)this, ServicePriority.Normal);
    }

    public void onDisable() {
        this.closeDatabase();
    }

    private synchronized void closeDatabase() {
        if (this.binaryStorage != null) {
            this.binaryStorage.close();
            this.binaryStorage = null;
        }
        if (this.database != null) {
            this.database.disconnect();
            this.database = null;
        }
    }

    public synchronized void reloadConfig() {
        block12: {
            this.closeDatabase();
            super.reloadConfig();
            this.config = new PluginConfig(this);
            if (this.config.getMemoryCacheExpirationTime() != 0L) {
                this.playersByName = new HashMap();
                this.playersByUUID = new HashMap();
                this.nameHistories = new HashMap();
            } else {
                this.playersByName = null;
                this.playersByUUID = null;
                this.nameHistories = null;
            }
            if (this.config.useSQL()) {
                this.getLogger().info("Using mysql backend");
                try {
                    this.database = new UUIDDatabase(this.config.getSqlConfig());
                    if (!BinaryStorage.getDatabaseFile(this).isFile()) break block12;
                    this.getLogger().info("Importing players from local file");
                    try {
                        BinaryStorage tempBinaryStorage = new BinaryStorage(this);
                        ArrayList<CachedPlayer> allPlayers = tempBinaryStorage.loadAllPlayers();
                        tempBinaryStorage.close();
                        this.updateEntries(true, allPlayers.toArray(new CachedPlayer[allPlayers.size()]));
                    }
                    catch (IOException e) {
                        this.getLogger().log(Level.SEVERE, "Error while trying to import from file backend", e);
                    }
                    BinaryStorage.getDatabaseFile(this).delete();
                    this.getLogger().info("Import completed");
                }
                catch (SQLException e) {
                    this.getLogger().log(Level.SEVERE, "Error while trying to access the database", e);
                }
            } else {
                this.getLogger().info("Using storage file backend");
                try {
                    this.binaryStorage = new BinaryStorage(this);
                    ArrayList<CachedPlayer> allPlayers = this.binaryStorage.loadAllPlayers();
                    this.getLogger().info("Loaded " + allPlayers.size() + " players");
                    if (!allPlayers.isEmpty()) {
                        this.updateEntries(false, allPlayers.toArray(new CachedPlayer[allPlayers.size()]));
                    } else {
                        this.getLogger().info("Importing local players on first run");
                        this.importLocalOfflinePlayers();
                        this.getLogger().info("Import completed");
                    }
                }
                catch (IOException e) {
                    this.getLogger().log(Level.SEVERE, "Error while trying to access the storage file", e);
                }
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.isOp()) {
            sender.sendMessage("No permission!");
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("stats")) {
            sender.sendMessage("uuid2nameLookups: " + this.uuid2nameLookups);
            sender.sendMessage("name2uuidLookups: " + this.name2uuidLookups);
            sender.sendMessage("nameHistoryLookups: " + this.nameHistoryLookups);
            sender.sendMessage("mojangQueries: " + this.mojangQueries);
            sender.sendMessage("databaseUpdates: " + this.databaseUpdates);
            sender.sendMessage("databaseQueries: " + this.databaseQueries);
            if (this.hasProfileAPI) {
                sender.sendMessage("profilePropertiesLookups: " + this.profilePropertiesLookups);
                sender.sendMessage("profilePropertiesLookupQueries: " + this.profilePropertiesLookupQueries);
            }
            return true;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("lookup")) {
            String nameOrId = args[1];
            CachedPlayer result = null;
            try {
                UUID id = UUID.fromString(nameOrId);
                result = this.getPlayer(id, true);
            }
            catch (Exception e) {
                result = this.getPlayer(nameOrId, true);
            }
            if (result == null) {
                sender.sendMessage("Unknown Account");
            } else {
                sender.sendMessage("Name: " + result.getName() + " ID: " + result.getUUID());
            }
            return true;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("lookupHistory")) {
            UUID uuid;
            String idString = args[1];
            CachedPlayer cachedPlayer = this.getPlayerFromNameOrUUID(idString, true);
            if (cachedPlayer != null) {
                uuid = cachedPlayer.getUniqueId();
            } else {
                try {
                    uuid = UUID.fromString(idString);
                }
                catch (IllegalArgumentException e) {
                    sender.sendMessage("Illegal UUID.");
                    return true;
                }
            }
            NameHistory result = null;
            result = this.getNameHistory(uuid);
            if (result == null) {
                sender.sendMessage("F\u00fcr diesen Account ist keine Namenshistory verf\u00fcgbar");
            } else {
                sender.sendMessage("First name: " + result.getFirstName());
                if (result.getNameChanges().isEmpty()) {
                    sender.sendMessage("(keine Umbenennungen)");
                    return true;
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                for (NameHistory.NameChange change : result.getNameChanges()) {
                    sender.sendMessage(format.format(new Date(change.getDate())) + ": change to " + change.getNewName());
                }
            }
            return true;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("lookupUUIDs")) {
            String name = args[1];
            sender.sendMessage("UUIDs for: " + name);
            for (UUID uuid : this.getCurrentAndPreviousPlayers(name)) {
                sender.sendMessage("  " + uuid.toString());
            }
            return true;
        }
        sender.sendMessage(label + " stats");
        sender.sendMessage(label + " lookup <player>");
        sender.sendMessage(label + " lookupHistory <player>");
        sender.sendMessage(label + " lookupUUIDs <name>");
        return true;
    }

    public void importLocalOfflinePlayers() {
        long now = System.currentTimeMillis();
        ArrayList<CachedPlayer> toUpdate = new ArrayList<CachedPlayer>();
        for (OfflinePlayer p : this.getServer().getOfflinePlayers()) {
            if (p.getName() == null || p.getUniqueId() == null) continue;
            long lastPlayed = p.getLastPlayed();
            CachedPlayer knownPlayer = this.getPlayer(p.getUniqueId());
            if (knownPlayer != null && knownPlayer.getLastSeen() >= lastPlayed) continue;
            toUpdate.add(new CachedPlayer(p.getUniqueId(), p.getName(), lastPlayed, now));
        }
        if (toUpdate.size() > 0) {
            this.updateEntries(true, toUpdate.toArray(new CachedPlayer[toUpdate.size()]));
        }
    }

    @Override
    public CachedPlayer getPlayer(OfflinePlayer player) {
        return this.getPlayer(player.getUniqueId());
    }

    @Override
    public CachedPlayer getPlayerFromNameOrUUID(String playerNameOrUUID) {
        return this.getPlayerFromNameOrUUID(playerNameOrUUID, false);
    }

    @Override
    public CachedPlayer getPlayerFromNameOrUUID(String playerNameOrUUID, boolean queryMojangIfUnknown) {
        if ((playerNameOrUUID = playerNameOrUUID.trim()).length() == 36) {
            try {
                return this.getPlayer(UUID.fromString(playerNameOrUUID), queryMojangIfUnknown);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.getPlayer(playerNameOrUUID, queryMojangIfUnknown);
    }

    @Override
    public Collection<CachedPlayer> getPlayers(Collection<String> playerNames, boolean queryMojangIfUnknown) {
        this.name2uuidLookups += playerNames.size();
        ArrayList<CachedPlayer> rv = new ArrayList<CachedPlayer>();
        ArrayList<String> loadNames = queryMojangIfUnknown ? new ArrayList<String>() : null;
        for (String player : playerNames) {
            CachedPlayer entry = this.getPlayer(player);
            if (entry == null) {
                if (!queryMojangIfUnknown) continue;
                loadNames.add(player);
                continue;
            }
            rv.add(entry);
        }
        if (queryMojangIfUnknown && loadNames.size() > 0) {
            try {
                ++this.mojangQueries;
                long now = System.currentTimeMillis();
                for (Map.Entry e : new UUIDFetcher(loadNames).call().entrySet()) {
                    CachedPlayer entry = new CachedPlayer((UUID)e.getValue(), (String)e.getKey(), now, now);
                    this.updateEntries(true, entry);
                    rv.add(entry);
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Error while trying to load players", e);
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedPlayer getPlayer(String playerName) {
        ++this.name2uuidLookups;
        PlayerUUIDCache playerUUIDCache = this;
        synchronized (playerUUIDCache) {
            CachedPlayer entry;
            if (this.playersByName != null && (entry = this.playersByName.get(playerName.toLowerCase())) != null && (this.config.getMemoryCacheExpirationTime() == -1L || entry.getCacheLoadTime() + this.config.getMemoryCacheExpirationTime() > System.currentTimeMillis())) {
                return entry;
            }
        }
        if (this.database != null) {
            try {
                ++this.databaseQueries;
                CachedPlayer entry = this.database.getPlayer(playerName);
                if (entry != null) {
                    this.updateEntries(false, entry);
                    return entry;
                }
            }
            catch (SQLException e) {
                this.getLogger().log(Level.SEVERE, "Error while trying to access the database", e);
            }
        }
        return null;
    }

    @Override
    public CachedPlayer getPlayer(String playerName, boolean queryMojangIfUnknown) {
        CachedPlayer entry = this.getPlayer(playerName);
        if (entry != null || !queryMojangIfUnknown) {
            return entry;
        }
        return this.getPlayerFromMojang(playerName);
    }

    @Override
    public Future<CachedPlayer> loadPlayerAsynchronously(String playerName) {
        FutureTask<CachedPlayer> futuretask = new FutureTask<CachedPlayer>(() -> this.getPlayerFromMojang(playerName));
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, futuretask);
        return futuretask;
    }

    @Override
    public void getPlayerAsynchronously(String playerName, Callback<CachedPlayer> synchronousCallback) {
        CachedPlayer entry = this.getPlayer(playerName);
        if (entry != null) {
            if (synchronousCallback != null) {
                if (Bukkit.isPrimaryThread()) {
                    synchronousCallback.onComplete(entry);
                } else {
                    this.getServer().getScheduler().runTask((Plugin)this, () -> synchronousCallback.onComplete(entry));
                }
            }
            return;
        }
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            CachedPlayer p = this.getPlayerFromMojang(playerName);
            if (synchronousCallback != null) {
                this.getServer().getScheduler().runTask((Plugin)this, () -> synchronousCallback.onComplete(p));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedPlayer getPlayer(UUID playerUUID) {
        ++this.uuid2nameLookups;
        PlayerUUIDCache playerUUIDCache = this;
        synchronized (playerUUIDCache) {
            CachedPlayer entry;
            if (this.playersByUUID != null && (entry = this.playersByUUID.get(playerUUID)) != null && (this.config.getMemoryCacheExpirationTime() == -1L || entry.getCacheLoadTime() + this.config.getMemoryCacheExpirationTime() > System.currentTimeMillis())) {
                return entry;
            }
        }
        if (this.database != null) {
            try {
                ++this.databaseQueries;
                CachedPlayer entry = this.database.getPlayer(playerUUID);
                if (entry != null) {
                    this.updateEntries(false, entry);
                    return entry;
                }
            }
            catch (SQLException e) {
                this.getLogger().log(Level.SEVERE, "Error while trying to access the database", e);
            }
        }
        return null;
    }

    @Override
    public CachedPlayer getPlayer(UUID playerUUID, boolean queryMojangIfUnknown) {
        CachedPlayer entry = this.getPlayer(playerUUID);
        if (entry != null || !queryMojangIfUnknown) {
            return entry;
        }
        return this.getPlayerFromMojang(playerUUID);
    }

    @Override
    public Future<CachedPlayer> loadPlayerAsynchronously(UUID playerUUID) {
        FutureTask<CachedPlayer> futuretask = new FutureTask<CachedPlayer>(() -> this.getPlayerFromMojang(playerUUID));
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, futuretask);
        return futuretask;
    }

    @Override
    public void getPlayerAsynchronously(UUID playerUUID, Callback<CachedPlayer> synchronousCallback) {
        CachedPlayer entry = this.getPlayer(playerUUID);
        if (entry != null) {
            if (synchronousCallback != null) {
                if (Bukkit.isPrimaryThread()) {
                    synchronousCallback.onComplete(entry);
                } else {
                    this.getServer().getScheduler().runTask((Plugin)this, () -> synchronousCallback.onComplete(entry));
                }
            }
            return;
        }
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            CachedPlayer p = this.getPlayerFromMojang(playerUUID);
            if (synchronousCallback != null) {
                this.getServer().getScheduler().runTask((Plugin)this, () -> synchronousCallback.onComplete(p));
            }
        });
    }

    protected CachedPlayer getPlayerFromMojang(String playerName) {
        ++this.mojangQueries;
        try {
            for (Map.Entry e : new UUIDFetcher(Collections.singletonList(playerName)).call().entrySet()) {
                if (!playerName.equalsIgnoreCase((String)e.getKey())) continue;
                long now = System.currentTimeMillis();
                CachedPlayer entry = new CachedPlayer((UUID)e.getValue(), (String)e.getKey(), now, now);
                if (this.getServer().isPrimaryThread()) {
                    this.updateEntries(true, entry);
                } else {
                    this.getServer().getScheduler().runTask((Plugin)this, () -> this.updateEntries(true, entry));
                }
                return entry;
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error while trying to load player", e);
        }
        return null;
    }

    protected CachedPlayer getPlayerFromMojang(UUID playerUUID) {
        ++this.mojangQueries;
        try {
            for (Map.Entry e : new NameFetcher(Collections.singletonList(playerUUID)).call().entrySet()) {
                if (!playerUUID.equals(e.getKey())) continue;
                long now = System.currentTimeMillis();
                CachedPlayer entry = new CachedPlayer((UUID)e.getKey(), (String)e.getValue(), now, now);
                if (this.getServer().isPrimaryThread()) {
                    this.updateEntries(true, entry);
                } else {
                    this.getServer().getScheduler().runTask((Plugin)this, () -> this.updateEntries(true, entry));
                }
                return entry;
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error while trying to load player", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CachedPlayer> searchPlayersByPartialName(String partialName) {
        List<CachedPlayer> result = null;
        if (this.database != null) {
            ++this.databaseQueries;
            try {
                result = this.database.searchPlayers(partialName);
                this.updateEntries(false, result.toArray(new CachedPlayer[result.size()]));
            }
            catch (SQLException e) {
                this.getLogger().log(Level.SEVERE, "Error while trying to access the database", e);
            }
        }
        if (result == null && this.playersByUUID != null) {
            partialName = partialName.toLowerCase();
            result = new ArrayList<CachedPlayer>();
            PlayerUUIDCache playerUUIDCache = this;
            synchronized (playerUUIDCache) {
                for (CachedPlayer player : this.playersByUUID.values()) {
                    if (!player.getName().toLowerCase().contains(partialName)) continue;
                    result.add(player);
                }
                result.sort((p1, p2) -> -1 * Long.compare(p1.getLastSeen(), p2.getLastSeen()));
            }
        }
        return result;
    }

    @Override
    public void loadAllPlayersFromDatabase() {
        if (this.database == null) {
            return;
        }
        try {
            Set<CachedPlayer> players = this.database.getAllPlayers();
            this.updateEntries(false, players.toArray(new CachedPlayer[players.size()]));
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error while trying to load players", e);
        }
    }

    protected synchronized void updateEntries(boolean updateDB, CachedPlayer ... entries) {
        if (entries == null || entries.length == 0) {
            return;
        }
        if (this.playersByUUID != null && this.playersByName != null) {
            for (CachedPlayer entry : entries) {
                String newLowerName;
                CachedPlayer oldNameEntry;
                String oldName;
                CachedPlayer oldEntry = this.playersByUUID.get(entry.getUUID());
                if (oldEntry != null && !(oldName = oldEntry.getName()).equalsIgnoreCase(entry.getName()) && (oldNameEntry = this.playersByName.get(oldName.toLowerCase())) != null && oldNameEntry.getUUID().equals(entry.getUUID())) {
                    this.playersByName.remove(oldName.toLowerCase());
                }
                if (oldEntry == null || oldEntry.getLastSeen() <= entry.getLastSeen()) {
                    this.playersByUUID.put(entry.getUUID(), entry);
                }
                if ((oldEntry = this.playersByName.get(newLowerName = entry.getName().toLowerCase())) != null && oldEntry.getLastSeen() > entry.getLastSeen()) continue;
                this.playersByName.put(newLowerName, entry);
            }
        }
        if (updateDB) {
            if (this.database != null) {
                try {
                    ++this.databaseUpdates;
                    this.database.addOrUpdatePlayers(entries);
                }
                catch (SQLException e) {
                    this.getLogger().log(Level.SEVERE, "Error while trying to access the database", e);
                }
            }
            if (this.binaryStorage != null) {
                try {
                    ++this.databaseUpdates;
                    for (CachedPlayer player : entries) {
                        this.binaryStorage.addOrUpdatePlayer(player);
                    }
                }
                catch (IOException e) {
                    this.getLogger().log(Level.SEVERE, "Error while trying to access the storage file", e);
                }
            }
        }
    }

    protected synchronized void updateProfileProperties(boolean updateDB, CachedPlayerProfile entry) {
        CachedPlayerProfile oldEntry;
        if (this.playerProfiles != null && ((oldEntry = this.playerProfiles.get(entry.getUUID())) == null || oldEntry.getLastSeen() <= entry.getLastSeen())) {
            this.playerProfiles.put(entry.getUUID(), entry);
        }
        if (updateDB && this.database != null) {
            try {
                ++this.databaseUpdates;
                this.database.addOrUpdatePlayerProfile(entry);
            }
            catch (SQLException e) {
                this.getLogger().log(Level.SEVERE, "Error while trying to access the database", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedPlayerProfile getPlayerProfile(UUID playerUUID) {
        ++this.profilePropertiesLookups;
        PlayerUUIDCache playerUUIDCache = this;
        synchronized (playerUUIDCache) {
            CachedPlayerProfile entry;
            if (this.playerProfiles != null && (entry = this.playerProfiles.get(playerUUID)) != null) {
                long now = System.currentTimeMillis();
                if (entry.getCacheLoadTime() + 1800000L > now && entry.getExpiration() > now) {
                    return entry;
                }
                this.playerProfiles.remove(playerUUID);
            }
        }
        if (this.database != null) {
            try {
                ++this.profilePropertiesLookupQueries;
                CachedPlayerProfile entry = this.database.getPlayerProfile(playerUUID);
                if (entry != null && entry.getExpiration() > System.currentTimeMillis()) {
                    this.updateProfileProperties(false, entry);
                    return entry;
                }
            }
            catch (SQLException e) {
                this.getLogger().log(Level.SEVERE, "Error while trying to access the database", e);
            }
        }
        return null;
    }

    public Future<CachedPlayerProfile> loadPlayerProfileAsynchronously(UUID playerUUID) {
        FutureTask<CachedPlayerProfile> futuretask = new FutureTask<CachedPlayerProfile>(() -> this.getPlayerProfileFromMojang(playerUUID));
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, futuretask);
        return futuretask;
    }

    public CachedPlayerProfile getPlayerProfile(UUID playerUUID, boolean queryMojangIfUnknown) {
        CachedPlayerProfile entry = this.getPlayerProfile(playerUUID);
        if (entry != null || !queryMojangIfUnknown) {
            return entry;
        }
        return this.getPlayerProfileFromMojang(playerUUID);
    }

    public void getPlayerProfileAsynchronously(UUID playerUUID, Callback<CachedPlayerProfile> synchronousCallback) {
        CachedPlayerProfile entry = this.getPlayerProfile(playerUUID);
        if (entry != null) {
            if (synchronousCallback != null) {
                if (Bukkit.isPrimaryThread()) {
                    synchronousCallback.onComplete(entry);
                } else {
                    this.getServer().getScheduler().runTask((Plugin)this, () -> synchronousCallback.onComplete(entry));
                }
            }
            return;
        }
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            CachedPlayerProfile p = this.getPlayerProfileFromMojang(playerUUID);
            if (synchronousCallback != null) {
                this.getServer().getScheduler().runTask((Plugin)this, () -> synchronousCallback.onComplete(p));
            }
        });
    }

    protected CachedPlayerProfile getPlayerProfileFromMojang(UUID playerUUID) {
        ++this.mojangQueries;
        try {
            CachedPlayerProfile entry = new ProfileFetcher(playerUUID).call();
            if (entry != null) {
                this.updateProfileProperties(true, entry);
            }
            return entry;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error while trying to load player", e);
            return null;
        }
    }

    @Override
    public NameHistory getNameHistory(OfflinePlayer player) {
        NameHistory history = this.getNameHistory(player.getUniqueId());
        String currentName = player.getName();
        if (currentName != null) {
            long time = System.currentTimeMillis();
            if (history == null) {
                history = new NameHistory(player.getUniqueId(), currentName, List.of(), time);
                this.updateHistory(true, history);
            } else if (!currentName.equals(history.getName(time)) && !currentName.equals((history = this.getNameHistoryInternal(player.getUniqueId(), true)).getName(time))) {
                ArrayList<NameHistory.NameChange> nameChanges = new ArrayList<NameHistory.NameChange>(history.getNameChanges());
                nameChanges.add(new NameHistory.NameChange(currentName, time));
                history = new NameHistory(history.getUUID(), history.getFirstName(), nameChanges, time);
                this.updateHistory(true, history);
            }
        }
        return history;
    }

    @Override
    @Deprecated
    public NameHistory getNameHistory(UUID playerUUID, boolean queryMojangIfUnknown) {
        return this.getNameHistory(playerUUID);
    }

    @Override
    public NameHistory getNameHistory(UUID playerUUID) {
        return this.getNameHistoryInternal(playerUUID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NameHistory getNameHistoryInternal(UUID playerUUID, boolean skipCache) {
        NameHistory result;
        ++this.nameHistoryLookups;
        if (!skipCache) {
            PlayerUUIDCache playerUUIDCache = this;
            synchronized (playerUUIDCache) {
                result = this.nameHistories.get(playerUUID);
                if (result != null && (this.config.getNameHistoryCacheExpirationTime() == -1L || result.getCacheLoadTime() + this.config.getNameHistoryCacheExpirationTime() > System.currentTimeMillis())) {
                    return result;
                }
            }
        }
        if (this.database != null) {
            ++this.databaseQueries;
            try {
                result = this.database.getNameHistory(playerUUID);
                if (result != null) {
                    this.updateHistory(false, result);
                    return result;
                }
            }
            catch (SQLException e) {
                this.getLogger().log(Level.SEVERE, "Error while trying to access the database", e);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public void getNameHistoryAsynchronously(UUID playerUUID, Callback<NameHistory> synchronousCallback) {
        NameHistory history = this.getNameHistory(playerUUID);
        if (history != null) {
            if (synchronousCallback != null) {
                if (Bukkit.isPrimaryThread()) {
                    synchronousCallback.onComplete(history);
                } else {
                    this.getServer().getScheduler().runTask((Plugin)this, () -> synchronousCallback.onComplete(history));
                }
            }
            return;
        }
    }

    @Override
    @Deprecated
    public Future<NameHistory> loadNameHistoryAsynchronously(UUID playerUUID) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Set<UUID> getCurrentAndPreviousPlayers(String name) {
        CachedPlayer current;
        Set<UUID> result = null;
        if (this.database != null) {
            try {
                ++this.databaseQueries;
                result = this.database.getKnownUsersFromHistory(name);
            }
            catch (SQLException e) {
                this.getLogger().log(Level.SEVERE, "Error while trying to access the database", e);
            }
        }
        if (result == null) {
            result = new HashSet<UUID>();
            block2: for (NameHistory history : this.nameHistories.values()) {
                if (history.getFirstName().equals(name)) {
                    result.add(history.getUUID());
                    continue;
                }
                for (NameHistory.NameChange change : history.getNameChanges()) {
                    if (!change.getNewName().equals(name)) continue;
                    result.add(history.getUUID());
                    continue block2;
                }
            }
        }
        if ((current = this.getPlayer(name, false)) != null) {
            result.add(current.getUniqueId());
        }
        return result;
    }

    protected synchronized void updateHistory(boolean updateDB, NameHistory history) {
        if (this.nameHistories != null) {
            this.nameHistories.put(history.getUUID(), history);
        }
        if (updateDB && this.database != null) {
            try {
                ++this.databaseUpdates;
                this.database.addOrUpdateHistory(history);
            }
            catch (SQLException e) {
                this.getLogger().log(Level.SEVERE, "Error while trying to access the database", e);
            }
        }
    }

    private class PlayerLoginListener
    implements Listener {
        private PlayerLoginListener() {
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void onPlayerLogin(PlayerLoginEvent e) {
            String name = e.getPlayer().getName();
            UUID uuid = e.getPlayer().getUniqueId();
            long now = System.currentTimeMillis();
            PlayerUUIDCache.this.updateEntries(true, new CachedPlayer(uuid, name, now, now));
            PlayerUUIDCache.this.getNameHistory((OfflinePlayer)e.getPlayer());
            PlayerUUIDCache.this.playerProfiles.remove(e.getPlayer().getUniqueId());
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void onPlayerQuit(PlayerQuitEvent e) {
            String name = e.getPlayer().getName();
            UUID uuid = e.getPlayer().getUniqueId();
            long now = System.currentTimeMillis();
            PlayerUUIDCache.this.updateEntries(true, new CachedPlayer(uuid, name, now, now));
        }
    }
}

