/*
 * Decompiled with CFR 0.152.
 */
package de.iani.playerUUIDCache;

import com.destroystokyo.paper.profile.ProfileProperty;
import de.iani.playerUUIDCache.CachedPlayer;
import de.iani.playerUUIDCache.CachedPlayerProfile;
import de.iani.playerUUIDCache.NameHistory;
import de.iani.playerUUIDCache.SQLConfig;
import de.iani.playerUUIDCache.util.sql.MySQLConnection;
import de.iani.playerUUIDCache.util.sql.SQLConnection;
import de.iani.playerUUIDCache.util.sql.SQLUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class UUIDDatabase {
    private final SQLConnection connection;
    private final String tableName;
    private final String profilesTableName;
    private final String nameHistoriesTableName;
    private final String nameChangesTableName;
    private final String insertPlayer;
    private final String selectPlayerByUUID;
    private final String selectPlayerByName;
    private final String searchPlayersByPartialName;
    private final String selectAllPlayers;
    private final String insertPlayerProfile;
    private final String selectPlayerProfileByUUID;
    private final String deleteOldPlayerProfiles;
    private boolean mayUseProfilesTable;
    private final String insertNameHistory;
    private final String updateNameHistoryRefreshed;
    private final String insertNameChange;
    private final String selectNameHistory;
    private final String selectNameChanges;
    private final String selectNameUsers;

    public UUIDDatabase(SQLConfig config) throws SQLException {
        this.connection = new MySQLConnection(config.getHost(), config.getDatabase(), config.getUser(), config.getPassword());
        this.tableName = config.getTableName();
        this.profilesTableName = config.getProfilesTableName();
        this.nameHistoriesTableName = config.getNameHistoriesTableName();
        this.nameChangesTableName = config.getNameChangesTableName();
        this.insertPlayer = "INSERT INTO " + this.tableName + " (uuid, name, lastSeen) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE name = ?, lastSeen = ?";
        this.selectPlayerByUUID = "SELECT name, lastSeen FROM " + this.tableName + " WHERE uuid = ?";
        this.selectPlayerByName = "SELECT uuid, name, lastSeen FROM " + this.tableName + " WHERE name = ?";
        this.searchPlayersByPartialName = "SELECT uuid, name, lastSeen FROM " + this.tableName + " WHERE name LIKE ? ORDER BY lastSeen DESC";
        this.selectAllPlayers = "SELECT uuid, name, lastSeen FROM " + this.tableName;
        this.connection.runCommands((connection, sqlConnection) -> {
            if (!sqlConnection.hasTable(this.tableName)) {
                Statement smt = connection.createStatement();
                smt.executeUpdate("CREATE TABLE `" + this.tableName + "` (`uuid` CHAR( 36 ) NOT NULL,`name` VARCHAR( 100 ) NOT NULL ,`lastSeen` BIGINT NOT NULL DEFAULT '0',PRIMARY KEY ( `uuid` ), INDEX ( `name` ) ) ENGINE = innodb");
                smt.close();
            }
            return null;
        });
        this.insertPlayerProfile = "INSERT INTO " + this.profilesTableName + " (uuid, profile, lastSeen) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE profile = ?, lastSeen = ?";
        this.selectPlayerProfileByUUID = "SELECT profile, lastSeen FROM " + this.profilesTableName + " WHERE uuid = ?";
        this.deleteOldPlayerProfiles = "DELETE FROM " + this.profilesTableName + " WHERE lastSeen < ?";
        this.insertNameHistory = "INSERT INTO " + this.nameHistoriesTableName + " (uuid, firstName, refreshed) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE refreshed = ?";
        this.updateNameHistoryRefreshed = "UPDATE " + this.nameHistoriesTableName + " SET refreshed = ? WHERE uuid = ?";
        this.insertNameChange = "INSERT IGNORE INTO " + this.nameChangesTableName + " (uuid, date, newName) VALUES (?, ?, ?)";
        this.selectNameHistory = "SELECT firstName, refreshed FROM " + this.nameHistoriesTableName + " WHERE uuid = ?";
        this.selectNameChanges = "SELECT date, newName FROM " + this.nameChangesTableName + " WHERE uuid = ?";
        this.selectNameUsers = "SELECT uuid, date FROM ((SELECT uuid, 0 AS date FROM " + this.nameHistoriesTableName + " WHERE firstName = ?) UNION (SELECT uuid, lastSeen AS date FROM " + this.tableName + " WHERE name = ?) UNION (SELECT uuid, date FROM " + this.nameChangesTableName + " WHERE newName = ?)) AS t ORDER BY date DESC";
        this.connection.runCommands((connection, sqlConnection) -> {
            Statement smt;
            if (!sqlConnection.hasTable(this.nameHistoriesTableName)) {
                smt = connection.createStatement();
                smt.executeUpdate("CREATE TABLE `" + this.nameHistoriesTableName + "` (`uuid` CHAR( 36 ) NOT NULL,`firstName` VARCHAR( 16 ) NOT NULL,`refreshed` BIGINT NOT NULL DEFAULT '0',PRIMARY KEY ( `uuid` ), INDEX ( `firstName` ) ) ENGINE = innodb");
                smt.close();
            }
            if (!sqlConnection.hasColumn(this.nameHistoriesTableName, "refreshed")) {
                smt = connection.createStatement();
                smt.executeUpdate("ALTER TABLE `" + this.nameHistoriesTableName + "` ADD `refreshed` BIGINT NOT NULL DEFAULT '0' AFTER firstName");
                smt.close();
            }
            return null;
        });
        this.connection.runCommands((connection, sqlConnection) -> {
            if (!sqlConnection.hasTable(this.nameChangesTableName)) {
                Statement smt = connection.createStatement();
                smt.executeUpdate("CREATE TABLE `" + this.nameChangesTableName + "` (`uuid` CHAR( 36 ) NOT NULL,`date` BIGINT NOT NULL,`newName` VARCHAR( 16 ) NOT NULL,PRIMARY KEY ( `uuid`, `date` ), INDEX( `newName` ) ) ENGINE = innodb");
                smt.close();
            }
            return null;
        });
    }

    public void createProfilePropertiesTable() throws SQLException {
        this.connection.runCommands((connection, sqlConnection) -> {
            if (!sqlConnection.hasTable(this.profilesTableName)) {
                Statement smt = connection.createStatement();
                smt.executeUpdate("CREATE TABLE `" + this.profilesTableName + "` (`uuid` CHAR( 36 ) NOT NULL,`profile` MEDIUMTEXT NOT NULL ,`lastSeen` BIGINT NOT NULL DEFAULT '0',PRIMARY KEY ( `uuid` ), INDEX ( `lastSeen` ) ) ENGINE = innodb");
                smt.close();
            }
            return null;
        });
        this.mayUseProfilesTable = true;
    }

    public void addOrUpdatePlayers(CachedPlayer ... entries) throws SQLException {
        if (entries == null || entries.length == 0) {
            return;
        }
        this.connection.runCommands((connection, sqlConnection) -> {
            PreparedStatement smt = sqlConnection.getOrCreateStatement(this.insertPlayer);
            for (CachedPlayer entry : entries) {
                smt.setString(1, entry.getUUID().toString());
                smt.setString(2, entry.getName());
                smt.setLong(3, entry.getLastSeen());
                smt.setString(4, entry.getName());
                smt.setLong(5, entry.getLastSeen());
                smt.executeUpdate();
            }
            return null;
        });
    }

    public CachedPlayer getPlayer(UUID uuid) throws SQLException {
        return this.connection.runCommands((connection, sqlConnection) -> {
            PreparedStatement smt = sqlConnection.getOrCreateStatement(this.selectPlayerByUUID);
            smt.setString(1, uuid.toString());
            ResultSet rs = smt.executeQuery();
            if (rs.next()) {
                String name = rs.getString(1);
                long time = rs.getLong(2);
                rs.close();
                return new CachedPlayer(uuid, name, time, System.currentTimeMillis());
            }
            rs.close();
            return null;
        });
    }

    public CachedPlayer getPlayer(String name) throws SQLException {
        return this.connection.runCommands((connection, sqlConnection) -> {
            String realName = name;
            PreparedStatement smt = sqlConnection.getOrCreateStatement(this.selectPlayerByName);
            smt.setString(1, name);
            ResultSet rs = smt.executeQuery();
            UUID uuid = null;
            long time = Long.MIN_VALUE;
            while (rs.next()) {
                long thisTime = rs.getLong(3);
                if (thisTime <= time) continue;
                try {
                    uuid = UUID.fromString(rs.getString(1));
                    realName = rs.getString(2);
                    time = thisTime;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            rs.close();
            if (uuid != null) {
                return new CachedPlayer(uuid, realName, time, System.currentTimeMillis());
            }
            return null;
        });
    }

    public List<CachedPlayer> searchPlayers(String partialName) throws SQLException {
        return this.connection.runCommands((connection, sqlConnection) -> {
            PreparedStatement smt = sqlConnection.getOrCreateStatement(this.searchPlayersByPartialName);
            smt.setString(1, "%" + SQLUtil.escapeLike(partialName) + "%");
            ResultSet rs = smt.executeQuery();
            ArrayList<CachedPlayer> result = new ArrayList<CachedPlayer>();
            while (rs.next()) {
                try {
                    UUID uuid = UUID.fromString(rs.getString(1));
                    String name = rs.getString(2);
                    long time = rs.getLong(3);
                    result.add(new CachedPlayer(uuid, name, time, System.currentTimeMillis()));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            rs.close();
            return result;
        });
    }

    public Set<CachedPlayer> getAllPlayers() throws SQLException {
        return this.connection.runCommands((connection, sqlConnection) -> {
            PreparedStatement smt = sqlConnection.getOrCreateStatement(this.selectAllPlayers);
            ResultSet rs = smt.executeQuery();
            HashSet<CachedPlayer> result = new HashSet<CachedPlayer>();
            while (rs.next()) {
                try {
                    UUID uuid = UUID.fromString(rs.getString(1));
                    String name = rs.getString(2);
                    long time = rs.getLong(3);
                    result.add(new CachedPlayer(uuid, name, time, System.currentTimeMillis()));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            rs.close();
            return result;
        });
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    public void addOrUpdatePlayerProfile(CachedPlayerProfile entry) throws SQLException {
        if (!this.mayUseProfilesTable) {
            return;
        }
        this.connection.runCommands((connection, sqlConnection) -> {
            PreparedStatement smt = sqlConnection.getOrCreateStatement(this.insertPlayerProfile);
            smt.setString(1, entry.getUUID().toString());
            YamlConfiguration yaml = new YamlConfiguration();
            for (ProfileProperty pp : entry.getProperties()) {
                ConfigurationSection section = yaml.createSection(pp.getName());
                section.set("value", (Object)pp.getValue());
                section.set("signature", (Object)pp.getSignature());
            }
            String properties = yaml.saveToString();
            smt.setString(2, properties);
            smt.setLong(3, entry.getLastSeen());
            smt.setString(4, properties);
            smt.setLong(5, entry.getLastSeen());
            smt.executeUpdate();
            return null;
        });
    }

    public CachedPlayerProfile getPlayerProfile(UUID uuid) throws SQLException {
        if (!this.mayUseProfilesTable) {
            return null;
        }
        return this.connection.runCommands((connection, sqlConnection) -> {
            PreparedStatement smt = sqlConnection.getOrCreateStatement(this.selectPlayerProfileByUUID);
            smt.setString(1, uuid.toString());
            ResultSet rs = smt.executeQuery();
            if (rs.next()) {
                YamlConfiguration yaml = new YamlConfiguration();
                try {
                    yaml.loadFromString(rs.getString(1));
                }
                catch (Throwable t) {
                    return null;
                }
                LinkedHashSet<ProfileProperty> properties = new LinkedHashSet<ProfileProperty>();
                for (String name : yaml.getKeys(false)) {
                    ConfigurationSection section = yaml.getConfigurationSection(name);
                    if (section == null) continue;
                    String value = section.getString("value");
                    String signature = section.getString("signature");
                    properties.add(new ProfileProperty(name, value, signature));
                }
                long time = rs.getLong(2);
                rs.close();
                return new CachedPlayerProfile(uuid, properties, time, System.currentTimeMillis());
            }
            rs.close();
            return null;
        });
    }

    public void deleteOldPlayerProfiles() throws SQLException {
        this.connection.runCommands((connection, sqlConnection) -> {
            PreparedStatement smt = sqlConnection.getOrCreateStatement(this.deleteOldPlayerProfiles);
            smt.setLong(1, System.currentTimeMillis() - 86400000L);
            smt.executeUpdate();
            return null;
        });
    }

    public void addOrUpdateHistory(NameHistory history) throws SQLException {
        this.connection.runCommands((connection, sqlConnection) -> {
            PreparedStatement smt = sqlConnection.getOrCreateStatement(this.insertNameHistory);
            smt.setString(1, history.getUUID().toString());
            smt.setString(2, history.getFirstName());
            smt.setLong(3, history.getCacheLoadTime());
            smt.setLong(4, history.getCacheLoadTime());
            smt.executeUpdate();
            smt = sqlConnection.getOrCreateStatement(this.insertNameChange);
            for (NameHistory.NameChange change : history.getNameChanges()) {
                smt.setString(1, history.getUUID().toString());
                smt.setLong(2, change.getDate());
                smt.setString(3, change.getNewName());
                smt.addBatch();
            }
            smt.executeBatch();
            return null;
        });
    }

    public NameHistory getNameHistory(UUID uuid) throws SQLException {
        return this.connection.runCommands((connection, sqlConnection) -> {
            PreparedStatement smt = sqlConnection.getOrCreateStatement(this.selectNameHistory);
            smt.setString(1, uuid.toString());
            ResultSet rs = smt.executeQuery();
            if (!rs.next()) {
                return null;
            }
            String firstName = rs.getString(1);
            long refreshed = rs.getLong(2);
            rs.close();
            smt = sqlConnection.getOrCreateStatement(this.selectNameChanges);
            smt.setString(1, uuid.toString());
            rs = smt.executeQuery();
            ArrayList<NameHistory.NameChange> changes = new ArrayList<NameHistory.NameChange>();
            while (rs.next()) {
                changes.add(new NameHistory.NameChange(rs.getString(2), rs.getLong(1)));
            }
            rs.close();
            return new NameHistory(uuid, firstName, changes, refreshed);
        });
    }

    public Set<UUID> getKnownUsersFromHistory(String name) throws SQLException {
        return this.connection.runCommands((connectino, sqlConnection) -> {
            PreparedStatement smt = sqlConnection.getOrCreateStatement(this.selectNameUsers);
            smt.setString(1, name);
            smt.setString(2, name);
            smt.setString(3, name);
            ResultSet rs = smt.executeQuery();
            LinkedHashSet<UUID> result = new LinkedHashSet<UUID>();
            while (rs.next()) {
                result.add(UUID.fromString(rs.getString(1)));
            }
            rs.close();
            return result;
        });
    }
}

