/*
 * Decompiled with CFR 0.152.
 */
package de.iani.playerUUIDCache;

import com.google.common.base.Preconditions;
import java.util.UUID;

public final class CachedPlayer {
    private final UUID uuid;
    private final String name;
    private final long lastSeen;
    private final long cacheLoadTime;

    public CachedPlayer(UUID uuid, String name, long lastSeen, long cacheLoadTime) {
        Preconditions.checkNotNull((Object)uuid);
        Preconditions.checkNotNull((Object)name);
        this.uuid = uuid;
        this.name = name;
        this.lastSeen = lastSeen;
        this.cacheLoadTime = cacheLoadTime;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    long getCacheLoadTime() {
        return this.cacheLoadTime;
    }

    public int hashCode() {
        return this.name.hashCode() + this.uuid.hashCode() + (int)this.lastSeen;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != CachedPlayer.class) {
            return false;
        }
        CachedPlayer other = (CachedPlayer)obj;
        return this.name.equalsIgnoreCase(other.name) && this.uuid.equals(other.uuid) && this.lastSeen == other.lastSeen;
    }
}

