/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.blockstate;

import de.diddiz.LogBlock.blockstate.BlockStateCodec;
import de.diddiz.LogBlock.blockstate.BlockStateCodecBanner;
import de.diddiz.LogBlock.blockstate.BlockStateCodecLectern;
import de.diddiz.LogBlock.blockstate.BlockStateCodecShulkerBox;
import de.diddiz.LogBlock.blockstate.BlockStateCodecSign;
import de.diddiz.LogBlock.blockstate.BlockStateCodecSkull;
import de.diddiz.LogBlock.blockstate.BlockStateCodecSpawner;
import java.util.EnumMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.file.YamlConfiguration;

public class BlockStateCodecs {
    private static Map<Material, BlockStateCodec> codecs = new EnumMap<Material, BlockStateCodec>(Material.class);

    public static void registerCodec(BlockStateCodec codec) {
        Material[] materials;
        for (Material material : materials = codec.getApplicableMaterials()) {
            if (codecs.containsKey(material)) {
                throw new IllegalArgumentException("BlockStateCodec for " + material + " already registered!");
            }
            codecs.put(material, codec);
        }
    }

    public static boolean hasCodec(Material material) {
        return codecs.containsKey(material);
    }

    public static YamlConfiguration serialize(BlockState state) {
        YamlConfiguration serialized;
        BlockStateCodec codec = codecs.get(state.getType());
        if (codec != null && (serialized = codec.serialize(state)) != null && !serialized.getKeys(false).isEmpty()) {
            return serialized;
        }
        return null;
    }

    public static void deserialize(BlockState block, YamlConfiguration state) {
        BlockStateCodec codec = codecs.get(block.getType());
        if (codec != null) {
            codec.deserialize(block, state);
        }
    }

    public static String toString(Material material, YamlConfiguration state) {
        BlockStateCodec codec = codecs.get(material);
        if (codec != null) {
            return codec.toString(state);
        }
        return null;
    }

    static {
        BlockStateCodecs.registerCodec(new BlockStateCodecSign());
        BlockStateCodecs.registerCodec(new BlockStateCodecSkull());
        BlockStateCodecs.registerCodec(new BlockStateCodecBanner());
        BlockStateCodecs.registerCodec(new BlockStateCodecSpawner());
        BlockStateCodecs.registerCodec(new BlockStateCodecLectern());
        BlockStateCodecs.registerCodec(new BlockStateCodecShulkerBox());
    }
}

