/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.LookupCacheElement;
import de.diddiz.LogBlock.MaterialConverter;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.componentwrapper.Component;
import de.diddiz.LogBlock.componentwrapper.Components;
import de.diddiz.LogBlock.util.ActionColor;
import de.diddiz.LogBlock.util.BukkitUtils;
import de.diddiz.LogBlock.util.MessagingUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bukkit.Location;
import org.bukkit.Material;

public class Kill
implements LookupCacheElement {
    final long id;
    final long date;
    public final Location loc;
    final String killerName;
    final String victimName;
    final int weapon;

    public Kill(String killerName, String victimName, int weapon, Location loc) {
        this.id = 0L;
        this.date = System.currentTimeMillis() / 1000L;
        this.loc = loc;
        this.killerName = killerName;
        this.victimName = victimName;
        this.weapon = weapon;
    }

    public Kill(ResultSet rs, QueryParams p) throws SQLException {
        this.id = p.needId ? rs.getLong("id") : 0L;
        this.date = p.needDate ? rs.getTimestamp("date").getTime() : 0L;
        this.loc = p.needCoords ? new Location(p.world, (double)rs.getInt("x"), (double)rs.getInt("y"), (double)rs.getInt("z")) : null;
        this.killerName = p.needKiller ? rs.getString("killer") : null;
        this.victimName = p.needVictim ? rs.getString("victim") : null;
        this.weapon = p.needWeapon ? rs.getInt("weapon") : 0;
    }

    public String toString() {
        return Components.toPlainText(this.getLogMessage());
    }

    @Override
    public Location getLocation() {
        return this.loc;
    }

    @Override
    public Component getLogMessage(int entry) {
        Component msg = Components.empty();
        if (this.date > 0L) {
            msg = msg.append(MessagingUtil.prettyDate(this.date));
            msg = msg.append(" ");
        }
        msg = msg.append(MessagingUtil.createTextComponentWithColor(this.killerName + " killed ", ActionColor.DESTROY.getColor()));
        msg = msg.append(Components.text(this.victimName));
        if (this.loc != null) {
            msg = msg.append(" at ");
            msg = msg.append(MessagingUtil.prettyLocation(this.loc, entry));
        }
        if (this.weapon != 0) {
            msg = msg.append(" with ");
            msg = msg.append(this.prettyItemName(MaterialConverter.getMaterial(this.weapon)));
        }
        return msg;
    }

    public Component prettyItemName(Material t) {
        if (t == null || BukkitUtils.isEmpty(t)) {
            return MessagingUtil.prettyMaterial("fist");
        }
        return MessagingUtil.prettyMaterial(t.toString().replace('_', ' '));
    }
}

