/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.componentwrapper;

import de.diddiz.LogBlock.componentwrapper.ChatColor;
import de.diddiz.LogBlock.componentwrapper.Click;
import de.diddiz.LogBlock.componentwrapper.Hover;
import java.util.List;

public abstract class Component {
    private final ChatColor color;
    private final Hover hover;
    private final Click click;
    private final List<Component> children;

    Component(ChatColor color, Hover hover, Click click, Component ... children) {
        this(color, hover, click, List.of(children));
        for (Component e : this.children) {
            if (e != null) continue;
            throw new NullPointerException("no null children allowed");
        }
    }

    Component(ChatColor color, Hover hover, Click click, List<Component> children) {
        this.color = color;
        this.hover = hover;
        this.click = click;
        this.children = children;
    }

    public ChatColor getColor() {
        return this.color;
    }

    public List<Component> getChildren() {
        return this.children;
    }

    public Hover getHover() {
        return this.hover;
    }

    public Click getClick() {
        return this.click;
    }

    public abstract Component append(Component var1);

    public abstract Component append(String var1);

    public abstract Component hover(Hover var1);

    public abstract Component click(Click var1);

    protected Component[] addChildInternal(Component child) {
        if (child == null) {
            throw new NullPointerException("no null children allowed");
        }
        if (this.children.isEmpty()) {
            return new Component[]{child};
        }
        int size = this.children.size();
        Component[] array = this.children.toArray(new Component[size + 1]);
        array[size] = child;
        return array;
    }
}

