/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.EntityChange;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.EntityLogging;
import de.diddiz.LogBlock.listeners.LoggingListener;
import de.diddiz.worldedit.WorldEditHelper;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Wither;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AdvancedEntityLogging
extends LoggingListener {
    private Player lastSpawner;
    private Class<? extends Entity> lastSpawning;
    private boolean lastSpawnerEgg;
    private UUID lastEntityDamagedForDeathUUID;
    private byte[] lastEntityDamagedForDeathSerialized;

    public AdvancedEntityLogging(LogBlock lb) {
        super(lb);
        new BukkitRunnable(){

            public void run() {
                AdvancedEntityLogging.this.resetOnTick();
            }
        }.runTaskTimer((Plugin)lb, 1L, 1L);
    }

    private void resetOnTick() {
        this.lastSpawner = null;
        this.lastSpawning = null;
        this.lastSpawnerEgg = false;
        this.lastEntityDamagedForDeathUUID = null;
        this.lastEntityDamagedForDeathSerialized = null;
    }

    private void setLastSpawner(Player player, Class<? extends Entity> spawning, boolean spawnEgg) {
        this.lastSpawner = player;
        this.lastSpawning = spawning;
        this.lastSpawnerEgg = spawnEgg;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerBlockPlace(BlockPlaceEvent event) {
        Material placed = event.getBlock().getType();
        if (placed == Material.WITHER_SKELETON_SKULL) {
            this.setLastSpawner(event.getPlayer(), Wither.class, false);
        } else if (placed == Material.CARVED_PUMPKIN) {
            Material below = event.getBlock().getRelative(BlockFace.DOWN).getType();
            if (below == Material.SNOW_BLOCK) {
                this.setLastSpawner(event.getPlayer(), Snowman.class, false);
            } else if (below == Material.IRON_BLOCK) {
                this.setLastSpawner(event.getPlayer(), IronGolem.class, false);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        ItemStack inHand;
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && (inHand = event.getItem()) != null) {
            Material mat = inHand.getType();
            if (mat == Material.ARMOR_STAND) {
                this.setLastSpawner(event.getPlayer(), ArmorStand.class, false);
            } else if (mat.name().endsWith("_SPAWN_EGG")) {
                this.setLastSpawner(event.getPlayer(), null, true);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        ItemStack inHand;
        ItemStack itemStack = inHand = event.getHand() == EquipmentSlot.HAND ? event.getPlayer().getInventory().getItemInMainHand() : event.getPlayer().getInventory().getItemInOffHand();
        if (inHand != null && inHand.getType() != Material.AIR) {
            ItemStack oldItem;
            Entity entity;
            Material mat = inHand.getType();
            if (mat.name().endsWith("_SPAWN_EGG")) {
                this.setLastSpawner(event.getPlayer(), null, true);
            }
            if ((entity = event.getRightClicked()) instanceof ItemFrame && ((oldItem = ((ItemFrame)entity).getItem()) == null || oldItem.getType() == Material.AIR) && Config.isLogging(entity.getWorld(), EntityLogging.MODIFY, entity)) {
                Actor actor = Actor.actorFromEntity((Entity)event.getPlayer());
                YamlConfiguration data = new YamlConfiguration();
                inHand = inHand.clone();
                inHand.setAmount(1);
                data.set("item", (Object)inHand);
                this.consumer.queueEntityModification(actor, entity.getUniqueId(), entity.getType(), entity.getLocation(), EntityChange.EntityChangeType.ADDEQUIP, data);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntitySpawn(CreatureSpawnEvent event) {
        if (!event.isCancelled()) {
            if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.CUSTOM) {
                return;
            }
            LivingEntity entity = event.getEntity();
            if (Config.isLogging(entity.getWorld(), EntityLogging.SPAWN, (Entity)entity)) {
                Actor actor = null;
                if (this.lastSpawner != null && this.lastSpawner.getWorld() == entity.getWorld() && this.lastSpawner.getLocation().distance(entity.getLocation()) < 10.0) {
                    if (this.lastSpawnerEgg && event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER_EGG) {
                        actor = Actor.actorFromEntity((Entity)this.lastSpawner);
                    } else if (this.lastSpawning != null && this.lastSpawning.isAssignableFrom(entity.getClass())) {
                        actor = Actor.actorFromEntity((Entity)this.lastSpawner);
                    }
                }
                if (actor == null) {
                    actor = new Actor(event.getSpawnReason().toString());
                }
                this.queueEntitySpawnOrKill((Entity)entity, actor, EntityChange.EntityChangeType.CREATE);
            }
        }
        this.resetOnTick();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (Config.isLogging(entity.getWorld(), EntityLogging.DESTROY, (Entity)entity)) {
            Entity damager;
            Actor actor = null;
            EntityDamageEvent lastDamage = entity.getLastDamageCause();
            if (lastDamage instanceof EntityDamageByEntityEvent && (damager = ((EntityDamageByEntityEvent)lastDamage).getDamager()) != null) {
                actor = Actor.actorFromEntity(damager);
            }
            if (actor == null) {
                actor = new Actor(lastDamage == null ? "UNKNOWN" : lastDamage.getCause().toString());
            }
            this.queueEntitySpawnOrKill((Entity)entity, actor, EntityChange.EntityChangeType.KILL);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent event) {
        Hanging entity = event.getEntity();
        if (Config.isLogging(entity.getWorld(), EntityLogging.SPAWN, (Entity)entity)) {
            Actor actor = Actor.actorFromEntity((Entity)event.getPlayer());
            this.queueEntitySpawnOrKill((Entity)entity, actor, EntityChange.EntityChangeType.CREATE);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakEvent event) {
        Hanging entity = event.getEntity();
        if (Config.isLogging(entity.getWorld(), EntityLogging.DESTROY, (Entity)entity)) {
            Actor actor = event instanceof HangingBreakByEntityEvent ? Actor.actorFromEntity(((HangingBreakByEntityEvent)event).getRemover()) : new Actor(event.getCause().toString());
            this.queueEntitySpawnOrKill((Entity)entity, actor, EntityChange.EntityChangeType.KILL);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        ItemStack oldItem;
        Entity entity = event.getEntity();
        if (entity instanceof ItemFrame && (oldItem = ((ItemFrame)entity).getItem()) != null && oldItem.getType() != Material.AIR && Config.isLogging(entity.getWorld(), EntityLogging.MODIFY, entity)) {
            Actor actor = event instanceof EntityDamageByEntityEvent ? Actor.actorFromEntity(((EntityDamageByEntityEvent)event).getDamager()) : new Actor(event.getCause().toString());
            YamlConfiguration data = new YamlConfiguration();
            data.set("item", (Object)oldItem);
            this.consumer.queueEntityModification(actor, entity.getUniqueId(), entity.getType(), entity.getLocation(), EntityChange.EntityChangeType.REMOVEEQUIP, data);
        }
        if (Config.isLogging(entity.getWorld(), EntityLogging.DESTROY, entity)) {
            this.lastEntityDamagedForDeathUUID = entity.getUniqueId();
            this.lastEntityDamagedForDeathSerialized = WorldEditHelper.serializeEntity(entity);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerArmorStandManipulate(PlayerArmorStandManipulateEvent event) {
        boolean newEmpty;
        ArmorStand entity = event.getRightClicked();
        ItemStack oldItem = event.getArmorStandItem();
        ItemStack newItem = event.getPlayerItem();
        boolean oldEmpty = oldItem == null || oldItem.getType() == Material.AIR;
        boolean bl = newEmpty = newItem == null || newItem.getType() == Material.AIR;
        if (!(oldEmpty && newEmpty || !Config.isLogging(entity.getWorld(), EntityLogging.MODIFY, (Entity)entity))) {
            YamlConfiguration data;
            Actor actor = Actor.actorFromEntity((Entity)event.getPlayer());
            if (!oldEmpty && !newEmpty && newItem.getAmount() > 1) {
                return;
            }
            if (!oldEmpty) {
                data = new YamlConfiguration();
                data.set("item", (Object)oldItem);
                data.set("slot", (Object)event.getSlot().name());
                this.consumer.queueEntityModification(actor, entity.getUniqueId(), entity.getType(), entity.getLocation(), EntityChange.EntityChangeType.REMOVEEQUIP, data);
            }
            if (!newEmpty) {
                data = new YamlConfiguration();
                data.set("item", (Object)newItem);
                data.set("slot", (Object)event.getSlot().name());
                this.consumer.queueEntityModification(actor, entity.getUniqueId(), entity.getType(), entity.getLocation(), EntityChange.EntityChangeType.ADDEQUIP, data);
            }
        }
    }

    protected void queueEntitySpawnOrKill(Entity entity, Actor actor, EntityChange.EntityChangeType changeType) {
        Location location = entity.getLocation();
        YamlConfiguration data = new YamlConfiguration();
        data.set("x", (Object)location.getX());
        data.set("y", (Object)location.getY());
        data.set("z", (Object)location.getZ());
        data.set("yaw", (Object)Float.valueOf(location.getYaw()));
        data.set("pitch", (Object)Float.valueOf(location.getPitch()));
        if (changeType == EntityChange.EntityChangeType.KILL && entity.getUniqueId().equals(this.lastEntityDamagedForDeathUUID)) {
            data.set("worldedit", (Object)this.lastEntityDamagedForDeathSerialized);
        } else {
            data.set("worldedit", (Object)WorldEditHelper.serializeEntity(entity));
        }
        this.consumer.queueEntityModification(actor, entity.getUniqueId(), entity.getType(), location, changeType, data);
    }
}

