/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.LogBlock.listeners.LoggingListener;
import de.diddiz.util.BukkitUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockFromToEvent;

public class FluidFlowLogging
extends LoggingListener {
    public FluidFlowLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent event) {
        block18: {
            Material typeTo;
            Block to;
            Material typeFrom;
            BlockData blockDataFrom;
            WorldConfig wcfg;
            block19: {
                block20: {
                    boolean canFlow;
                    wcfg = Config.getWorldConfig(event.getBlock().getWorld());
                    if (wcfg == null) break block18;
                    blockDataFrom = event.getBlock().getBlockData();
                    typeFrom = blockDataFrom.getMaterial();
                    to = event.getToBlock();
                    typeTo = to.getType();
                    boolean bl = canFlow = BukkitUtils.isEmpty(typeTo) || BukkitUtils.getNonFluidProofBlocks().contains(typeTo);
                    if (typeFrom != Material.LAVA || !wcfg.isLogging(Logging.LAVAFLOW)) break block19;
                    Levelled levelledFrom = (Levelled)blockDataFrom;
                    if (!canFlow) break block20;
                    if (FluidFlowLogging.isSurroundedByWater(to) && levelledFrom.getLevel() <= 2) {
                        this.consumer.queueBlockReplace(new Actor("LavaFlow"), to.getState(), Material.COBBLESTONE.createBlockData());
                    } else {
                        Levelled newBlock = (Levelled)blockDataFrom.clone();
                        newBlock.setLevel(levelledFrom.getLevel() + 1);
                        if (BukkitUtils.isEmpty(typeTo)) {
                            this.consumer.queueBlockPlace(new Actor("LavaFlow"), to.getLocation(), (BlockData)newBlock);
                        } else {
                            this.consumer.queueBlockReplace(new Actor("LavaFlow"), to.getState(), (BlockData)newBlock);
                        }
                    }
                    break block18;
                }
                if (typeTo != Material.WATER) break block18;
                if (event.getFace() == BlockFace.DOWN) {
                    this.consumer.queueBlockReplace(new Actor("LavaFlow"), to.getState(), Material.STONE.createBlockData());
                } else {
                    this.consumer.queueBlockReplace(new Actor("LavaFlow"), to.getState(), Material.COBBLESTONE.createBlockData());
                }
                break block18;
            }
            if (typeFrom == Material.WATER && wcfg.isLogging(Logging.WATERFLOW)) {
                Levelled levelledFrom = (Levelled)blockDataFrom;
                Levelled newBlock = (Levelled)blockDataFrom.clone();
                newBlock.setLevel(levelledFrom.getLevel() + 1);
                if (BukkitUtils.isEmpty(typeTo)) {
                    this.consumer.queueBlockPlace(new Actor("WaterFlow"), to.getLocation(), (BlockData)newBlock);
                } else if (BukkitUtils.getNonFluidProofBlocks().contains(typeTo)) {
                    this.consumer.queueBlockReplace(new Actor("WaterFlow"), to.getState(), (BlockData)newBlock);
                } else if (typeTo == Material.LAVA) {
                    int toLevel = ((Levelled)to.getBlockData()).getLevel();
                    if (toLevel == 0) {
                        this.consumer.queueBlockReplace(new Actor("WaterFlow"), to.getState(), Material.OBSIDIAN.createBlockData());
                    } else if (event.getFace() == BlockFace.DOWN) {
                        this.consumer.queueBlockReplace(new Actor("WaterFlow"), to.getState(), Material.STONE.createBlockData());
                    }
                }
                if (BukkitUtils.isEmpty(typeTo) || BukkitUtils.getNonFluidProofBlocks().contains(typeTo)) {
                    for (BlockFace face : new BlockFace[]{BlockFace.DOWN, BlockFace.NORTH, BlockFace.WEST, BlockFace.EAST, BlockFace.SOUTH}) {
                        Block lower = to.getRelative(face);
                        if (lower.getType() != Material.LAVA) continue;
                        int toLevel = ((Levelled)lower.getBlockData()).getLevel();
                        if (toLevel == 0) {
                            this.consumer.queueBlockReplace(new Actor("WaterFlow"), lower.getState(), Material.OBSIDIAN.createBlockData());
                            continue;
                        }
                        if (event.getFace() != BlockFace.DOWN) continue;
                        this.consumer.queueBlockReplace(new Actor("WaterFlow"), lower.getState(), Material.STONE.createBlockData());
                    }
                }
            }
        }
    }

    private static boolean isSurroundedByWater(Block block) {
        for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.WEST, BlockFace.EAST, BlockFace.SOUTH}) {
            if (block.getRelative(face).getType() != Material.WATER) continue;
            return true;
        }
        return false;
    }
}

