/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.BlockChange;
import de.diddiz.LogBlock.ChestAccess;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.LookupCacheElement;
import de.diddiz.LogBlock.blockstate.BlockStateCodecs;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.util.BukkitUtils;
import de.diddiz.util.Utils;
import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.Piston;
import org.bukkit.block.data.type.PistonHead;
import org.bukkit.block.data.type.TechnicalPiston;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class WorldEditor
implements Runnable {
    private final LogBlock logblock;
    private final Queue<Edit> edits = new LinkedBlockingQueue<Edit>();
    private final World world;
    private CommandSender sender;
    private int taskID;
    private int successes = 0;
    private int blacklistCollisions = 0;
    private long elapsedTime = 0L;
    public LookupCacheElement[] errors;
    private boolean forceReplace;

    public WorldEditor(LogBlock logblock, World world) {
        this(logblock, world, false);
    }

    public WorldEditor(LogBlock logblock, World world, boolean forceReplace) {
        this.logblock = logblock;
        this.world = world;
        this.forceReplace = forceReplace;
    }

    public int getSize() {
        return this.edits.size();
    }

    public int getSuccesses() {
        return this.successes;
    }

    public int getErrors() {
        return this.errors.length;
    }

    public int getBlacklistCollisions() {
        return this.blacklistCollisions;
    }

    public void setSender(CommandSender sender) {
        this.sender = sender;
    }

    public void queueEdit(int x, int y, int z, int replaced, int replaceData, byte[] replacedState, int type, int typeData, byte[] typeState, ChestAccess item) {
        this.edits.add(new Edit(0L, new Location(this.world, (double)x, (double)y, (double)z), null, replaced, replaceData, replacedState, type, typeData, typeState, item));
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public synchronized void start() throws Exception {
        long start = System.currentTimeMillis();
        this.taskID = this.logblock.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.logblock, (Runnable)this, 0L, 1L);
        if (this.taskID == -1) {
            throw new Exception("Failed to schedule task");
        }
        try {
            this.wait();
        }
        catch (InterruptedException ex) {
            throw new Exception("Interrupted");
        }
        this.elapsedTime = System.currentTimeMillis() - start;
    }

    @Override
    public synchronized void run() {
        ArrayList<WorldEditorException> errorList = new ArrayList<WorldEditorException>();
        float size = this.edits.size();
        for (int counter = 0; !this.edits.isEmpty() && counter < 100; ++counter) {
            float percentage;
            try {
                switch (this.edits.poll().perform()) {
                    case SUCCESS: {
                        ++this.successes;
                        break;
                    }
                    case BLACKLISTED: {
                        ++this.blacklistCollisions;
                        break;
                    }
                }
                continue;
            }
            catch (WorldEditorException ex) {
                errorList.add(ex);
                continue;
            }
            catch (Exception ex) {
                this.logblock.getLogger().log(Level.WARNING, "[WorldEditor] Exeption: ", ex);
            }
            if (this.sender == null || (percentage = (size - (float)this.edits.size()) / size * 100.0f) % 20.0f != 0.0f) continue;
            this.sender.sendMessage(ChatColor.GOLD + "[LogBlock]" + ChatColor.YELLOW + " Rollback progress: " + percentage + "% Blocks edited: " + counter);
        }
        if (this.edits.isEmpty()) {
            this.logblock.getServer().getScheduler().cancelTask(this.taskID);
            if (errorList.size() > 0) {
                try {
                    File file = new File("plugins/LogBlock/error/WorldEditor-" + new SimpleDateFormat("yy-MM-dd-HH-mm-ss").format(System.currentTimeMillis()) + ".log");
                    file.getParentFile().mkdirs();
                    PrintWriter writer = new PrintWriter(file);
                    for (LookupCacheElement lookupCacheElement : errorList) {
                        writer.println(lookupCacheElement.getMessage());
                    }
                    writer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.errors = errorList.toArray(new WorldEditorException[errorList.size()]);
            this.notify();
        }
    }

    public static class WorldEditorException
    extends Exception
    implements LookupCacheElement {
        private final Location loc;

        public WorldEditorException(Material typeBefore, Material typeAfter, Location loc) {
            this("Failed to replace " + typeBefore.name() + " with " + typeAfter.name(), loc);
        }

        public WorldEditorException(String msg, Location loc) {
            super(msg + " at " + loc.getWorld().getName() + ":" + loc.getBlockX() + ":" + loc.getBlockY() + ":" + loc.getBlockZ());
            this.loc = loc;
        }

        @Override
        public Location getLocation() {
            return this.loc;
        }
    }

    private class Edit
    extends BlockChange {
        public Edit(long time, Location loc, Actor actor, int replaced, int replaceData, byte[] replacedState, int type, int typeData, byte[] typeState, ChestAccess ca) {
            super(time, loc, actor, replaced, replaceData, replacedState, type, typeData, typeState, ca);
        }

        PerformResult perform() throws WorldEditorException {
            Chest chest;
            BlockData replacedBlock = this.getBlockReplaced();
            BlockData setBlock = this.getBlockSet();
            if (replacedBlock == null || setBlock == null) {
                throw new WorldEditorException("Could not parse the material", this.loc.clone());
            }
            if (Config.dontRollback.contains(replacedBlock.getMaterial())) {
                return PerformResult.BLACKLISTED;
            }
            Block block = this.loc.getBlock();
            if (!WorldEditor.this.world.isChunkLoaded(block.getChunk())) {
                WorldEditor.this.world.loadChunk(block.getChunk());
            }
            if (BukkitUtils.isEmpty(replacedBlock.getMaterial()) && BukkitUtils.isEmpty(block.getType())) {
                return PerformResult.NO_ACTION;
            }
            BlockState state = block.getState();
            if (setBlock.equals(replacedBlock) && this.ca != null) {
                if (state instanceof Container && state.getType() == replacedBlock.getMaterial()) {
                    int leftover;
                    try {
                        leftover = BukkitUtils.modifyContainer(state, new ItemStack(this.ca.itemStack), !this.ca.remove);
                    }
                    catch (Exception ex) {
                        throw new WorldEditorException(ex.getMessage(), block.getLocation());
                    }
                    if (leftover > 0 && this.ca.remove) {
                        throw new WorldEditorException("Not enough space left in " + block.getType(), block.getLocation());
                    }
                    return PerformResult.SUCCESS;
                }
                return PerformResult.NO_ACTION;
            }
            if (!(WorldEditor.this.forceReplace || block.getType() == setBlock.getMaterial() || block.isEmpty() || Config.replaceAnyway.contains(block.getType()))) {
                return PerformResult.NO_ACTION;
            }
            if (state instanceof Container && replacedBlock.getMaterial() != block.getType()) {
                ((Container)state).getSnapshotInventory().clear();
                state.update();
            }
            block.setBlockData(replacedBlock);
            BlockData newData = block.getBlockData();
            if (BlockStateCodecs.hasCodec(replacedBlock.getMaterial())) {
                state = block.getState();
                try {
                    BlockStateCodecs.deserialize(state, Utils.deserializeYamlConfiguration(this.replacedState));
                    state.update();
                }
                catch (Exception e) {
                    throw new WorldEditorException("Failed to restore blockstate of " + block.getType() + ": " + e, block.getLocation());
                }
            }
            Material curtype = block.getType();
            if (newData instanceof Bed) {
                Block secBlock;
                Bed bed = (Bed)newData;
                Block block2 = secBlock = bed.getPart() == Bed.Part.HEAD ? block.getRelative(bed.getFacing().getOppositeFace()) : block.getRelative(bed.getFacing());
                if (secBlock.isEmpty()) {
                    Bed bed2 = (Bed)bed.clone();
                    bed2.setPart(bed.getPart() == Bed.Part.HEAD ? Bed.Part.FOOT : Bed.Part.HEAD);
                    secBlock.setBlockData((BlockData)bed2);
                }
            } else if (curtype == Material.IRON_DOOR || BukkitUtils.isWoodenDoor(curtype) || BukkitUtils.isDoublePlant(curtype)) {
                Bisected firstPart = (Bisected)newData;
                Block secBlock = block.getRelative(firstPart.getHalf() == Bisected.Half.TOP ? BlockFace.DOWN : BlockFace.UP);
                if (secBlock.isEmpty()) {
                    Bisected secondPart = (Bisected)firstPart.clone();
                    secondPart.setHalf(firstPart.getHalf() == Bisected.Half.TOP ? Bisected.Half.BOTTOM : Bisected.Half.TOP);
                    secBlock.setBlockData((BlockData)secondPart);
                }
            } else if (curtype == Material.PISTON || curtype == Material.STICKY_PISTON) {
                Block secBlock;
                Piston piston = (Piston)newData;
                if (piston.isExtended() && (secBlock = block.getRelative(piston.getFacing())).isEmpty()) {
                    PistonHead head = (PistonHead)Material.PISTON_HEAD.createBlockData();
                    head.setFacing(piston.getFacing());
                    head.setType(curtype == Material.PISTON ? TechnicalPiston.Type.NORMAL : TechnicalPiston.Type.STICKY);
                    secBlock.setBlockData((BlockData)head);
                }
            } else if (curtype == Material.PISTON_HEAD) {
                PistonHead head = (PistonHead)newData;
                Block secBlock = block.getRelative(head.getFacing().getOppositeFace());
                if (secBlock.isEmpty()) {
                    Piston piston = (Piston)(head.getType() == TechnicalPiston.Type.NORMAL ? Material.PISTON : Material.STICKY_PISTON).createBlockData();
                    piston.setFacing(head.getFacing());
                    piston.setExtended(true);
                    secBlock.setBlockData((BlockData)piston);
                }
            } else if (newData instanceof Chest && (chest = (Chest)newData).getType() != Chest.Type.SINGLE && BukkitUtils.getConnectedChest(block) == null) {
                chest.setType(Chest.Type.SINGLE);
                block.setBlockData((BlockData)chest);
            }
            return PerformResult.SUCCESS;
        }
    }

    private static enum PerformResult {
        SUCCESS,
        BLACKLISTED,
        NO_ACTION;

    }
}

