/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.EntityTypeConverter;
import de.diddiz.LogBlock.LookupCacheElement;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.componentwrapper.Component;
import de.diddiz.LogBlock.componentwrapper.Components;
import de.diddiz.LogBlock.util.MessagingUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.bukkit.Location;

public class SummedEntityChanges
implements LookupCacheElement {
    private final int type;
    private final int created;
    private final int destroyed;
    private final float spaceFactor;
    private final Actor actor;

    public SummedEntityChanges(ResultSet rs, QueryParams p, float spaceFactor) throws SQLException {
        this.actor = p.sum == QueryParams.SummarizationMode.PLAYERS ? new Actor(rs) : null;
        this.type = p.sum == QueryParams.SummarizationMode.TYPES ? rs.getInt("entitytypeid") : 0;
        this.created = rs.getInt("created");
        this.destroyed = rs.getInt("destroyed");
        this.spaceFactor = spaceFactor;
    }

    @Override
    public Location getLocation() {
        return null;
    }

    @Override
    public Component getLogMessage(int entry) {
        return MessagingUtil.formatSummarizedChanges(this.created, this.destroyed, this.actor != null ? Components.text(this.actor.getName()) : MessagingUtil.prettyMaterial(Objects.toString(EntityTypeConverter.getEntityType(this.type))), 10, 10, this.spaceFactor);
    }

    @Override
    public int getNumChanges() {
        return this.created + this.destroyed;
    }
}

